var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors } from '@kui-shell/test';
import { createNS, waitForGreen, waitForRed } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
describe(`kubectl watch error handler ${process.env.MOCHA_RUN_TARGET}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    const testResourceNotFound = (watchCmd, resourceType, resourceName) => {
        const errorMessage = `Error from server (NotFound): ${resourceType} "${resourceName}" not found`;
        it(`should error out when watching a non-existent ${resourceType}`, () => {
            return CLI.command(watchCmd, this.app)
                .then(ReplExpect.error(404, errorMessage))
                .catch(Common.oops(this, true));
        });
    };
    const testWrongCommand = (watchCmd, code, errMessage) => {
        it(`should error out with wrong command ${watchCmd}`, () => {
            return CLI.command(watchCmd, this.app)
                .then(errMessage ? ReplExpect.error(code, errMessage) : ReplExpect.error(code))
                .catch(Common.oops(this, true));
        });
    };
    const flags = ['-w', '--watch=true', '-w -w -w'];
    flags.forEach(watch => {
        testResourceNotFound(`k get ns shouldNotExist ${watch}`, 'namespaces', 'shouldNotExist');
        testResourceNotFound(`k get ns ${watch} shouldNotExist`, 'namespaces', 'shouldNotExist');
        testResourceNotFound(`k get pod shouldNotExist ${watch}`, 'pods', 'shouldNotExist');
        testResourceNotFound(`k get ${watch} pod shouldNotExist`, 'pods', 'shouldNotExist');
        testResourceNotFound(`k get pods shouldNotExist -n shouldNotExist ${watch}`, 'namespaces', 'shouldNotExist');
    });
    const wrongFlags = ['--watch true', '-w true'];
    wrongFlags.forEach(watch => {
        testResourceNotFound(`k get pod ${watch}`, 'pods', 'true');
        testWrongCommand(`k get ${watch} pod`, 404, 'error: the server doesn\'t have a resource type "true"');
    });
    testWrongCommand(`k -w get pod`, 500);
    it(`should watch pods, starting from an non-existent namespace`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const ns = createNS();
            console.error('watch from non-existent namespace 0');
            const watchResult = yield CLI.command(`k get pods -w -n ${ns}`, this.app).then((result) => __awaiter(this, void 0, void 0, function* () {
                yield ReplExpect.ok(result);
                return result;
            }));
            console.error('watch from non-existent namespace 1');
            yield CLI.command(`k create ns ${ns}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(ns) }))
                .then(status => waitForGreen(this.app, status));
            console.error('watch from non-existent namespace 2');
            yield CLI.command(`k create -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod -n ${ns}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                .then(status => waitForGreen(this.app, status));
            console.error('watch from non-existent namespace 3');
            const watchStatus = `${Selectors.OUTPUT_N(watchResult.count)} ${Selectors.BY_NAME('nginx')}`;
            yield this.app.client.waitForExist(watchStatus, CLI.waitTimeout);
            yield waitForGreen(this.app, watchStatus);
            console.error('watch from non-existent namespace 4');
            yield CLI.command(`k delete pods nginx -n ${ns}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                .then(status => waitForRed(this.app, status));
            console.error('watch from non-existent namespace 5');
            yield waitForRed(this.app, watchStatus);
            console.error('watch from non-existent namespace 6');
            yield CLI.command(`k delete ns ${ns}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(ns) }))
                .then(nsStatus => waitForRed(this.app, nsStatus));
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
});
//# sourceMappingURL=watch-error-handling.js.map