"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const apiVersion_1 = require("../controller/kubectl/apiVersion");
exports.apiVersion = apiVersion_1.default;
exports.kind = 'LogEntry';
function isLogEntryResource(resource) {
    return resource.apiVersion === apiVersion_1.default && resource.kind === exports.kind;
}
exports.isLogEntryResource = isLogEntryResource;
function resourceFromLogEntry(logLine, { involvedObject }) {
    return __awaiter(this, void 0, void 0, function* () {
        const { safeDump } = yield Promise.resolve().then(() => require('js-yaml'));
        return {
            apiVersion: apiVersion_1.default,
            kind: exports.kind,
            isSimulacrum: true,
            originatingCommand: undefined,
            metadata: {
                name: involvedObject.name,
                namespace: involvedObject.namespace
            },
            spec: {
                entry: logLine
            },
            involvedObject,
            data: safeDump(logLine),
            summary: {
                content: logLine.message
            }
        };
    });
}
exports.resourceFromLogEntry = resourceFromLogEntry;
//# sourceMappingURL=resource.js.map