"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const resource_1 = require("../models/resource");
function hasScope(resource) {
    return resource_1.isLogEntryResource(resource) && resource.spec.entry.detail1Key === 'Logger';
}
const levelBadge = {
    when: hasScope,
    badge: (resource) => {
        const scope = resource.spec.entry.detail1;
        return {
            title: scope,
            css: 'scope'
        };
    }
};
exports.default = levelBadge;
//# sourceMappingURL=scope-badge.js.map