import { i18n } from '@kui-shell/core';
import { isLogEntryResource } from '../models/resource';
const strings = i18n('plugin-logui');
function hasError(resource) {
    return (isLogEntryResource(resource) &&
        resource.spec.entry.messageDetail !== undefined &&
        resource.spec.entry.messageDetail.error !== undefined);
}
function renderError(tab, resource) {
    return resource.spec.entry.messageDetail.error;
}
export default {
    when: hasError,
    mode: {
        mode: 'error-verbose',
        label: strings('Error'),
        content: renderError,
        order: -2
    }
};
//# sourceMappingURL=error-verbose.js.map