"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _debug = _interopRequireDefault(require("debug"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2017-19 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('util/tee');

function _default(response) {
  return __awaiter(this, void 0, void 0, function* () {
    try {
      // eslint-disable-next-line @typescript-eslint/no-var-requires
      // eslint-disable-next-line @typescript-eslint/no-var-requires
      const {
        createWriteStream
      } = yield Promise.resolve().then(() => require('fs'));
      const stream = createWriteStream(process.env.KUI_TEE_TO_FILE);

      const logger = data => stream.write(data);

      try {
        const {
          print
        } = yield Promise.resolve().then(() => require('../main/headless-pretty-print'));
        print(response, logger, stream);

        if (process.env.KUI_TEE_TO_FILE_END_MARKER) {
          stream.write(process.env.KUI_TEE_TO_FILE_END_MARKER);
        }
      } finally {
        stream.end();

        if (process.env.KUI_TEE_TO_FILE_EXIT_ON_END_MARKER) {
          // we were asked to exit after writing an end marker
          try {
            const {
              app
            } = require('electron').remote;

            debug('attempting to quit', app);
            app.quit();
          } catch (err) {
            console.error('Error exiting', err);
          }
        }
      }
    } catch (err) {
      debug('error teeing output to console');
      console.error(err);
    }
  });
}