/*
 * Copyright 2017-18 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function isErrorWithResultField(error) {
    const err = error;
    return !!(err.error && err.error.response && err.error.response.result && err.error.response.result.error);
}
function isErrorWithNestedResultField(error) {
    const err = error;
    return !!(err.error &&
        err.error.response &&
        err.error.response.result &&
        err.error.response.result.error &&
        err.error.response.result.error.error);
}
function isErrorWithNestedErrorField(error) {
    const err = error;
    return !!(err.error && err.error.error);
}
function isErrorWithErrorField(error) {
    const err = error;
    return !!(err.error && !err.message);
}
/**
 * Try to pull out some meaningful message from the given error
 *
 */
export const oopsMessage = (err) => {
    try {
        if (typeof err === 'string') {
            return err;
        }
        else if (isErrorWithNestedResultField(err)) {
            return err.error.response.result.error.error; // feed creation error. nice
        }
        else if (isErrorWithResultField(err)) {
            return err.error.response.result.error;
        }
        else if (isErrorWithNestedErrorField(err)) {
            return err.error.error;
        }
        else if (isErrorWithErrorField(err)) {
            return err.error;
        }
        else {
            return err.message || 'Internal Error';
        }
    }
    catch (err) {
        console.error(err);
        return 'Internal Error';
    }
};
//# sourceMappingURL=oops.js.map