/// <reference types="react" />
import { Table as KuiTable, Watchable } from '@kui-shell/core';
import PaginatedTable, { Props, State } from './PaginatedTable';
declare type LiveProps = Props<KuiTable & Watchable> & {
    onRender: (hasContent: boolean) => void;
};
interface LiveState extends State {
    isWatching: boolean;
}
export default class LivePaginatedTable extends PaginatedTable<LiveProps, LiveState> {
    /** To allow for batch updates, the setState can be deferred until a call to updateDone() */
    private _deferredUpdate;
    constructor(props: LiveProps);
    /**
     * Only after the dom is attached can we initialize the watcher,
     * because it may otherwise trigger render() calls before we have
     * been attached.
     *
     */
    componentDidMount(): void;
    /** Render the component */
    render(): JSX.Element;
    /**
     * Initialize watcher channel to the provider, and attach the job so
     * that it can be managed w.r.t. UI contexts (such as tabs) coming
     * and going.
     *
     */
    private initWatch;
    /**
     * offline takes the rowKey of the row to be deleted and applies this to the table view
     *
     */
    private offline;
    /**
     * allOffline allows pollers to indicate that all resources are not to be found
     *
     */
    private allOffline;
    /**
     * update consumes the update notification and apply it to the table view
     *
     */
    private update;
    /** End of a deferred batch of updates */
    private batchUpdateDone;
    /**
     * Update to reflect new header model
     *
     */
    private header;
    /**
     * Done watching!
     *
     */
    private done;
}
export {};
