import * as React from 'react';
import { REPL, KResponse, Tab as KuiTab, ParsedOptions, CommandCompleteEvent } from '@kui-shell/core';
import Width from './width';
import { Props as TitleBarProps } from './TitleBar';
import CircularBuffer, { BaseHistoryEntry } from '../util/CircularBuffer';
import '../../../../web/css/static/sidecar.css';
import '../../../../web/css/static/sidecar-main.css';
import '../../../../web/css/static/sidecar-carbon.css';
/**
 * In order to support a sidecar being managed from an enclosing
 * context, we offer these Props. This is helpful for those cases
 * where one wishes to broker multiple sidecar views into a single
 * enclosing view; e.g. so that the broker can show at most one of the
 * assorted views at a time.
 *
 * For managed sidecars, may pass down an `onClose` and
 * `willLoseFocus` event set, so that the enclosing container may also
 * manage those aspects of the view.
 *
 */
export interface SidecarOptions {
    defaultWidth?: Width;
    onClose?: () => void;
    /** Current presentation of the sidecar; e.g. Maximized or Closed or Default width? */
    width?: Width;
    willChangeSize?: (width: Width) => void;
    willLoseFocus?: () => void;
}
export declare type Props = SidecarOptions & {
    uuid?: string;
    tab?: KuiTab;
    active?: boolean;
};
export interface SidecarHistoryEntry extends BaseHistoryEntry {
    execUUID: string;
}
/** Mostly, this State deals with the current "width" of the view. */
export interface BaseState<HistoryEntry extends SidecarHistoryEntry> {
    /** TODO investigate removing these */
    repl: REPL;
    tab: KuiTab;
    /** screenshotable region */
    dom: HTMLElement;
    current: HistoryEntry;
    history: CircularBuffer<HistoryEntry>;
}
declare type Cleaner = () => void;
/** cwd */
export declare function cwd(): string;
export declare abstract class BaseSidecar<R extends KResponse, HistoryEntry extends SidecarHistoryEntry> extends React.PureComponent<Props, BaseState<HistoryEntry>> {
    protected cleaners: Cleaner[];
    protected constructor(props: Props);
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    /** @return a `HistoryEntry` for the given `Response` */
    protected abstract getState(tab: KuiTab, response: R, execUUID: string, argvNoOptions: string[], parsedOptions: ParsedOptions): HistoryEntry;
    /** Consult our History model for a match */
    protected lookupHistory(response: R, argvNoOptions: string[], parsedOptions: ParsedOptions, cwd: string): number;
    /** Enter a given `response` into the History model */
    protected onResponse(event: CommandCompleteEvent<R>): void;
    /** Capacity of the circular buffer; e.g. if 1, then no history */
    protected capacity(): number;
    /** Is getState() idempotent? i.e. Will two command executions that satisfy `sameCommand` always produce the same response? */
    protected idempotent(): boolean;
    /** Should we display Back/Forward arrows for history navigation? */
    protected useArrowNavigation(): boolean;
    /** We are about to go away; invoke the register cleaners. */
    componentWillUnmount(): void;
    /** @return the current History entry */
    protected get current(): HistoryEntry;
    protected defaultWidth(): Width;
    /** Escape key toggles sidecar visibility */
    private onEscape;
    protected onMaximize(): void;
    protected onRestore(): void;
    protected onClose(): void;
    protected isFixedWidth(): boolean;
    protected width(): Required<string>;
    private onScreenshot;
    protected title(props?: Omit<TitleBarProps, 'width' | 'fixedWidth' | 'onClose' | 'onRestore' | 'onMaximize' | 'onMinimize' | 'willScreenshot' | 'repl'>): JSX.Element;
}
export {};
