import * as React from 'react';
import { Tab, Table, Watchable } from '@kui-shell/core';
import CircularBuffer, { BaseHistoryEntry } from './util/CircularBuffer';
export declare const enum Height {
    Split = "calc(100% - 8em - 2 * 0.5em)",
    NotSplit = "100%"
}
interface Props {
    uuid: string;
    tab: Tab;
    openWatchPane: () => void;
    closeWatchPane: () => void;
}
interface HistoryEntry extends BaseHistoryEntry {
    command: string;
    key: string;
    response: Table & Watchable;
}
interface State {
    current: HistoryEntry;
    history: CircularBuffer<HistoryEntry>;
}
export default class WatchPane extends React.PureComponent<Props, State> {
    constructor(props: Props);
    private onResponse;
    /** Keep this in sync with WatchPane.scss $num-columns */
    private capacity;
    /** re-execute the command, but display the watch result in terminal */
    private watchInTerminal;
    /** `Card Actions`, will be rendred as `Dropdown` */
    private actions;
    /** render subpane header as Breadcrumb */
    private header;
    /** abort the watchable job and clear the watch pane */
    private clearSubPane;
    render(): JSX.Element;
}
export {};
