/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { isLinkWithCommand, i18n } from '@kui-shell/core';
import { Nav, NavExpandable, NavItem, NavList } from '@patternfly/react-core';
import '../../../../../web/scss/components/Navigation/Patternfly.scss';
const strings = i18n('client', 'about');
export default class PatternflyNavigation extends React.PureComponent {
    /** render menu options specified by client/config.d/about.json */
    renderSideNavMenu(menuIdx) {
        const thisNav = this.props.current.allNavs[menuIdx];
        return (React.createElement(NavExpandable, { title: strings(thisNav.title), key: menuIdx, isActive: this.props.current.current.menuIdx === menuIdx, isExpanded: true, className: menuIdx === 0 ? 'sidecar-header-name-content' : undefined }, thisNav.tabs.map((mode, idx) => (React.createElement(NavItem, { href: "#" // needed for tab navigation
            , key: idx, "data-mode": mode.mode, isActive: this.props.current.current.menuIdx === menuIdx && this.props.current.current.tabIdx === idx, onClick: () => {
                this.props.changeCurrent(menuIdx, idx);
            }, onMouseDown: event => event.preventDefault() },
            React.createElement("span", { className: "kui--mode-placeholder", "data-mode": mode.mode }, strings(mode.label || mode.mode)))))));
    }
    renderSideNavLink(idx, link) {
        if (isLinkWithCommand(link)) {
            return (React.createElement(NavItem, { className: "kui--nav-command-link", "data-link": strings(link.label), key: idx, to: "#", onClick: () => this.props.tab.REPL.pexec(link.command) }, strings(link.label)));
        }
        else {
            return (React.createElement(NavItem, { className: "kui--nav-href-link", "data-link": strings(link.label), key: idx, target: "_blank", to: link.href }, strings(link.label)));
        }
    }
    render() {
        return (React.createElement(Nav, { "aria-label": "Side navigation", theme: "dark" },
            React.createElement(NavList, null,
                this.props.current.allNavs.map((nav, idx) => this.renderSideNavMenu(idx)),
                this.props.current.allLinks.map((link, idx) => this.renderSideNavLink(idx, link)))));
    }
}
//# sourceMappingURL=PatternFly.js.map