# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [8.10.13](https://github.com/IBM/kui/compare/v8.10.12...v8.10.13) (2020-07-14)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [8.10.12](https://github.com/IBM/kui/compare/v8.10.11...v8.10.12) (2020-07-10)

### Bug Fixes

- multiple issues with tab switching versus status stripe widgets ([07245b2](https://github.com/IBM/kui/commit/07245b2)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([6cf94f0](https://github.com/IBM/kui/commit/6cf94f0)), closes [#5106](https://github.com/IBM/kui/issues/5106)

## [8.10.11](https://github.com/IBM/kui/compare/v8.10.10...v8.10.11) (2020-07-09)

### Bug Fixes

- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([0a23b10](https://github.com/IBM/kui/commit/0a23b10)), closes [#5097](https://github.com/IBM/kui/issues/5097)

## [8.10.10](https://github.com/IBM/kui/compare/v8.10.9...v8.10.10) (2020-07-07)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [8.10.9](https://github.com/IBM/kui/compare/v8.10.8...v8.10.9) (2020-07-06)

### Bug Fixes

- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([21aa6a6](https://github.com/IBM/kui/commit/21aa6a6)), closes [#5085](https://github.com/IBM/kui/issues/5085)

## [8.10.8](https://github.com/IBM/kui/compare/v8.10.7...v8.10.8) (2020-07-02)

### Bug Fixes

- kubectl help misformats helm help tables ([356e1c0](https://github.com/IBM/kui/commit/356e1c0)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([fba17fe](https://github.com/IBM/kui/commit/fba17fe)), closes [#5068](https://github.com/IBM/kui/issues/5068)

## [8.10.7](https://github.com/IBM/kui/compare/v8.10.6...v8.10.7) (2020-07-01)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [8.10.6](https://github.com/IBM/kui/compare/v8.10.5...v8.10.6) (2020-06-30)

### Bug Fixes

- reduce custom CSS rules for table UI ([c24dbc2](https://github.com/IBM/kui/commit/c24dbc2)), closes [#5024](https://github.com/IBM/kui/issues/5024)

## [8.10.5](https://github.com/IBM/kui/compare/v8.10.4...v8.10.5) (2020-06-27)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [8.10.4](https://github.com/IBM/kui/compare/v8.10.3...v8.10.4) (2020-06-26)

### Bug Fixes

- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([3786986](https://github.com/IBM/kui/commit/3786986)), closes [#5003](https://github.com/IBM/kui/issues/5003)

### Features

- add capability to show welcome widget to new users in Terminal ([332627f](https://github.com/IBM/kui/commit/332627f)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)

## [8.10.3](https://github.com/IBM/kui/compare/v8.10.2...v8.10.3) (2020-06-25)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [8.10.2](https://github.com/IBM/kui/compare/v8.10.1...v8.10.2) (2020-06-24)

### Bug Fixes

- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([6027968](https://github.com/IBM/kui/commit/6027968)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([4be867b](https://github.com/IBM/kui/commit/4be867b)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** oc logs does not work ([0d9dab3](https://github.com/IBM/kui/commit/0d9dab3)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([ee9da8e](https://github.com/IBM/kui/commit/ee9da8e)), closes [#4961](https://github.com/IBM/kui/issues/4961)

## [8.10.1](https://github.com/IBM/kui/compare/v8.10.0...v8.10.1) (2020-06-18)

### Bug Fixes

- avoid hard-coded use of /tmp in kubectl edit ([724b760](https://github.com/IBM/kui/commit/724b760)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- **plugins/plugin-kubectl:** kubectl explain subfields ([e85c1c6](https://github.com/IBM/kui/commit/e85c1c6)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([647ba75](https://github.com/IBM/kui/commit/647ba75)), closes [#4912](https://github.com/IBM/kui/issues/4912)

# [8.10.0](https://github.com/IBM/kui/compare/v4.5.0...v8.10.0) (2020-06-17)

### Bug Fixes

- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)

### Features

- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.9.0](https://github.com/IBM/kui/compare/v4.5.0...v8.9.0) (2020-06-09)

### Bug Fixes

- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)

### Features

- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.7.0](https://github.com/IBM/kui/compare/v4.5.0...v8.7.0) (2020-05-08)

### Bug Fixes

- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)

### Features

- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

## [8.6.1](https://github.com/IBM/kui/compare/v4.5.0...v8.6.1) (2020-04-25)

### Bug Fixes

- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.6.0](https://github.com/IBM/kui/compare/v4.5.0...v8.6.0) (2020-04-23)

### Bug Fixes

- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.5.0](https://github.com/IBM/kui/compare/v4.5.0...v8.5.0) (2020-04-19)

### Bug Fixes

- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

## [8.4.2](https://github.com/IBM/kui/compare/v4.5.0...v8.4.2) (2020-04-10)

### Bug Fixes

- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

## [8.4.1](https://github.com/IBM/kui/compare/v4.5.0...v8.4.1) (2020-04-10)

### Bug Fixes

- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

# [8.4.0](https://github.com/IBM/kui/compare/v4.5.0...v8.4.0) (2020-04-10)

### Bug Fixes

- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

# [8.1.0](https://github.com/IBM/kui/compare/v4.5.0...v8.1.0) (2020-04-04)

### Bug Fixes

- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)

### Features

- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
