"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _pluginClientCommon = require("@kui-shell/plugin-client-common");

var _core = require("@kui-shell/core");

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-kubectl');

class CurrentNamespace extends React.PureComponent {
  constructor(props = {}) {
    super(props);
    this.handler = this.reportCurrentNamespace.bind(this);
    this.state = {
      text: '',
      viewLevel: 'hidden'
    };
  }
  /** @return a short string that we can fit into a context UI widget */


  renderNamespace(context) {
    return context.metadata.namespace;
  }

  reportCurrentNamespace(idx) {
    return __awaiter(this, void 0, void 0, function* () {
      const tab = (0, _core.getTab)(idx);

      if (!tab || !tab.REPL) {
        if (tab && !tab.REPL) {
          _core.eventChannelUnsafe.once(`/tab/new/${tab.uuid}`, () => this.reportCurrentNamespace());
        }

        return;
      }

      try {
        const ns = yield (0, _pluginKubectl.getCurrentDefaultNamespace)(tab);

        if (ns) {
          this.setState({
            text: ns,
            viewLevel: 'normal' // only show normally if we succeed; see https://github.com/IBM/kui/issues/3537

          });
        }
      } catch (err) {
        console.error(err);
        this.setState({
          text: '',
          viewLevel: 'hidden' // only show normally if we succeed; see https://github.com/IBM/kui/issues/3537

        });
      }
    });
  }
  /**
   * Once we have mounted, we immediately check the current branch,
   * and schedule an update based on standard REPL events.
   *
   */


  componentDidMount() {
    if ((0, _core.inBrowser)()) {
      (0, _core.wireToTabEvents)(this.handler);
      (0, _pluginKubectl.onKubectlConfigChangeEvents)(this.handler);
    } else {
      (0, _core.wireToStandardEvents)(this.handler);
    }
  }
  /** Bye! */


  componentWillUnmount() {
    if ((0, _core.inBrowser)()) {
      (0, _pluginKubectl.offKubectlConfigChangeEvents)(this.handler);
    } else {// FIXME wireToStandardEvents(handler)
    }
  }

  render() {
    // FIXME disable the on-hover effect with the icon
    return React.createElement(_pluginClientCommon.TextWithIconWidget, {
      text: this.state.text,
      viewLevel: this.state.viewLevel,
      id: "kui--plugin-kubeui--current-namespace",
      textOnclick: "kubectl get namespaces",
      title: strings('Kubernetes namespace')
    }, React.createElement("div", {
      className: "current-namesapce-button",
      onClick: () => false
    }, React.createElement(_pluginClientCommon.Icons, {
      icon: "At"
    })));
  }

}

exports.default = CurrentNamespace;