import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Dropdown/dropdown';
import { css } from '@patternfly/react-styles';
import { DropdownMenu } from './DropdownMenu';
import { DropdownContext, DropdownDirection, DropdownPosition } from './dropdownConstants';
import { getOUIAProps } from '../../helpers';
export class DropdownWithContext extends React.Component {
    constructor(props) {
        super(props);
        this.openedOnEnter = false;
        this.baseComponentRef = React.createRef();
        this.onEnter = () => {
            this.openedOnEnter = true;
        };
        if (props.dropdownItems && props.dropdownItems.length > 0 && props.children) {
            // eslint-disable-next-line no-console
            console.error('Children and dropdownItems props have been provided. Only the dropdownItems prop items will be rendered');
        }
    }
    componentDidUpdate() {
        if (!this.props.isOpen) {
            this.openedOnEnter = false;
        }
    }
    render() {
        const _a = this.props, { children, className, direction, dropdownItems, isOpen, isPlain, isGrouped, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onSelect, position, toggle, autoFocus, ouiaId, ouiaComponentType } = _a, props = __rest(_a, ["children", "className", "direction", "dropdownItems", "isOpen", "isPlain", "isGrouped", "onSelect", "position", "toggle", "autoFocus", "ouiaId", "ouiaComponentType"]);
        const id = toggle.props.id || `pf-toggle-id-${DropdownWithContext.currentId++}`;
        let component;
        let renderedContent;
        let ariaHasPopup = false;
        if (dropdownItems && dropdownItems.length > 0) {
            component = 'ul';
            renderedContent = dropdownItems;
            ariaHasPopup = true;
        }
        else {
            component = 'div';
            renderedContent = React.Children.toArray(children);
        }
        const openedOnEnter = this.openedOnEnter;
        return (React.createElement(DropdownContext.Consumer, null, ({ baseClass, baseComponent, id: contextId }) => {
            const BaseComponent = baseComponent;
            return (React.createElement(BaseComponent, Object.assign({}, props, { className: css(baseClass, direction === DropdownDirection.up && styles.modifiers.top, position === DropdownPosition.right && styles.modifiers.alignRight, isOpen && styles.modifiers.expanded, className), ref: this.baseComponentRef }, getOUIAProps(ouiaComponentType, ouiaId)),
                React.Children.map(toggle, oneToggle => React.cloneElement(oneToggle, {
                    parentRef: this.baseComponentRef,
                    isOpen,
                    id,
                    isPlain,
                    'aria-haspopup': ariaHasPopup,
                    onEnter: () => this.onEnter()
                })),
                isOpen && (React.createElement(DropdownMenu, { component: component, isOpen: isOpen, position: position, "aria-labelledby": contextId ? `${contextId}-toggle` : id, openedOnEnter: openedOnEnter, isGrouped: isGrouped, autoFocus: openedOnEnter && autoFocus }, renderedContent))));
        }));
    }
}
// seed for the aria-labelledby ID
DropdownWithContext.currentId = 0;
DropdownWithContext.defaultProps = {
    className: '',
    dropdownItems: [],
    isOpen: false,
    isPlain: false,
    isGrouped: false,
    position: DropdownPosition.left,
    direction: DropdownDirection.down,
    onSelect: () => undefined,
    autoFocus: true,
    ouiaComponentType: 'Dropdown'
};
//# sourceMappingURL=DropdownWithContext.js.map