// Type definitions for html-minifier-terser 5.1
// Project: https://danielruf.github.io/html-minifier-terser/
// Definitions by: Piotr Błażejewicz <https://github.com/peterblazejewicz>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

declare namespace minify {
    function minify(value: string, options?: Options): string;

    /**
     * Most of the options are disabled by default
     */
    interface Options {
        /**
         * Treat attributes in case sensitive manner (useful for custom HTML tags)
         * @default false
         */
        caseSensitive?: boolean;
        /**
         * Omit attribute values from boolean attributes
         * @default false
         */
        collapseBooleanAttributes?: boolean;
        /**
         * Don't leave any spaces between display:inline;
         * elements when collapsing. Must be used in conjunction with collapseWhitespace=true
         * @default false
         */
        collapseInlineTagWhitespace?: boolean;
        /**
         * Collapse white space that contributes to text nodes in a document tree
         * @default false
         */
        collapseWhitespace?: boolean;
        /**
         * Always collapse to 1 space (never remove it entirely). Must be used in conjunction with `collapseWhitespace=true`
         * @default false
         */
        conservativeCollapse?: boolean;
        /**
         * Handle parse errors
         * @default false
         */
        continueOnParseError?: boolean;
        /**
         * Arrays of regex'es that allow to support custom attribute assign expressions (e.g. `'<div flex?="{{mode != cover}}"></div>'`)
         * @default []
         */
        customAttrAssign?: RegExp[];
        /**
         * Regex that specifies custom attribute to strip newlines from (e.g. `/ng-class/`
         */
        customAttrCollapse?: RegExp;
        /**
         * Arrays of regex'es that allow to support custom attribute surround expressions (e.g. `<input {{#if value}}checked="checked"{{/if}}>`)
         * @default []
         */
        customAttrSurround?: RegExp[];
        /**
         * Arrays of regex'es that allow to support custom event attributes for `minifyJS` (e.g. `ng-click`)
         * @default [/^on[a-z]{3,}$/]
         */
        customEventAttributes?: RegExp[];
        /**
         * Use direct Unicode characters whenever possible
         * @default false
         */
        decodeEntities?: boolean;
        /**
         * Parse input according to HTML5 specifications
         * @default true
         */
        html5?: boolean;
        /**
         * Array of regex'es that allow to ignore certain comments, when matched
         * @default [ /^!/, /^\s*#/ ]
         */
        ignoreCustomComments?: RegExp[];
        /**
         * Array of regex'es that allow to ignore certain fragments, when matched (e.g. `<?php ... ?>`, `{{ ... }}`, etc.)
         * @default [/<%[\s\S]*?%>/, /<\?[\s\S]\*?\?>/]
         */
        ignoreCustomFragments?: RegExp[];
        /**
         * Insert tags generated by HTML parser
         * @default true
         */
        includeAutoGeneratedTags?: boolean;
        /**
         * Keep the trailing slash on singleton elements
         * @default false
         */
        keepClosingSlash?: boolean;
        /**
         * Specify a maximum line length. Compressed output will be split by newlines at valid HTML split-points
         */
        maxLineLength?: number;
        /**
         * Minify CSS in style elements and style attributes
         * @default false
         */
        minifyCSS?: boolean | object | ((text: string, type?: string) => string);
        /**
         * Minify JavaScript in script elements and event attributes
         * @default false
         */
        minifyJS?: boolean | object | ((text: string, inline?: boolean) => string);
        /**
         * Minify URLs in various attributes
         * @default false
         */
        minifyURLs?: boolean | string | object | ((text: string) => string);
        /**
         * Always collapse to 1 line break (never remove it entirely) when whitespace between tags include a line break.
         * Must be used in conjunction with `collapseWhitespace=true`
         * @default false
         */
        preserveLineBreaks?: boolean;
        /**
         * Prevents the escaping of the values of attributes
         * @default false
         */
        preventAttributesEscaping?: boolean;
        /**
         * Process contents of conditional comments through minifier
         * @default false
         */
        processConditionalComments?: boolean;
        /**
         * Array of strings corresponding to types of script elements to process through minifier
         * (e.g. `text/ng-template`, `text/x-handlebars-template`, etc.)
         * @default []
         */
        processScripts?: string[];
        /**
         * Type of quote to use for attribute values (' or ")
         */
        quoteCharacter?: string;
        /**
         * Remove quotes around attributes when possible
         * @default false
         */
        removeAttributeQuotes?: boolean;
        /**
         * Strip HTML comments
         * @default false
         */
        removeComments?: boolean;
        /**
         * Remove all attributes with whitespace-only values
         * @default false
         */
        removeEmptyAttributes?: boolean | ((attrName: string, tag: string) => boolean);
        /**
         * Remove all elements with empty contents
         * @default false
         */
        removeEmptyElements?: boolean;
        /**
         * Remove optional tags
         * @default false
         */
        removeOptionalTags?: boolean;
        /**
         * Remove attributes when value matches default
         * @default false
         */
        removeRedundantAttributes?: boolean;
        /**
         * Remove `type="text/javascript"` from `script` tags. Other `type` attribute values are left intact
         * @default false
         */
        removeScriptTypeAttributes?: boolean;
        /**
         * Remove `type="text/css"` from `style` and `link` tags. Other `type` attribute values are left intact
         * @default false
         */
        removeStyleLinkTypeAttributes?: boolean;
        /**
         * Remove space between attributes whenever possible. **Note that this will result in invalid HTML!**
         * @default false
         */
        removeTagWhitespace?: boolean;
        /**
         * Sort attributes by frequency
         * @default false
         */
        sortAttributes?: boolean;
        /**
         * Sort style classes by frequency
         * @default false
         */
        sortClassName?: boolean;
        /**
         * Trim white space around `ignoreCustomFragments`
         * @default false
         */
        trimCustomFragments?: boolean;
        /**
         * Replaces the `doctype` with the short (HTML5) doctype
         * @default false
         */
        useShortDoctype?: boolean;
    }
}
// tslint:disable-next-line:export-just-namespace
export = minify;
