"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fullWidth = exports.condensedColumns = exports.condensed = exports.offset = exports.responsiveGrid = exports.autoColumns = exports.default = void 0;

require("./Grid-story.scss");

var _react = _interopRequireDefault(require("react"));

var _ = require("./");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = {
  decorators: [function (storyFn) {
    return _react.default.createElement("div", {
      id: "templates"
    }, storyFn());
  }],
  title: 'Grid'
};
exports.default = _default;

function DemoContent(_ref) {
  var children = _ref.children;
  return _react.default.createElement("div", {
    className: "outside"
  }, _react.default.createElement("div", {
    className: "inside"
  }, children));
}

var autoColumns = function autoColumns() {
  return _react.default.createElement(_.Grid, null, _react.default.createElement(_.Row, null, _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4"))));
};

exports.autoColumns = autoColumns;

var responsiveGrid = function responsiveGrid() {
  return _react.default.createElement(_.Grid, null, _react.default.createElement(_.Row, null, _react.default.createElement(_.Column, {
    sm: 1,
    md: 4,
    lg: 8
  }, _react.default.createElement(DemoContent, null, "sm: 1/4, md: 1/2, lg: 2/3")), _react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 2
  }, _react.default.createElement(DemoContent, null, "sm: 1/4, md: 1/4, lg: 1/6")), _react.default.createElement(_.Column, {
    sm: 1,
    md: 1,
    lg: 1
  }, _react.default.createElement(DemoContent, null, "sm: 1/4, md: 1/8, lg: 1/12")), _react.default.createElement(_.Column, {
    sm: 1,
    md: 1,
    lg: 1
  }, _react.default.createElement(DemoContent, null, "sm: 1/4, md: 1/8, lg: 1/12"))));
};

exports.responsiveGrid = responsiveGrid;

var offset = function offset() {
  return _react.default.createElement(_.Grid, null, _react.default.createElement(_.Row, null, _react.default.createElement(_.Column, {
    sm: {
      span: 1,
      offset: 3
    }
  }, _react.default.createElement(DemoContent, null, "Small Screen Offset 3")), _react.default.createElement(_.Column, {
    sm: {
      span: 2,
      offset: 2
    }
  }, _react.default.createElement(DemoContent, null, "Small Screen Offset 2")), _react.default.createElement(_.Column, {
    sm: {
      span: 3,
      offset: 1
    }
  }, _react.default.createElement(DemoContent, null, "Small Screen Offset 1")), _react.default.createElement(_.Column, {
    sm: {
      span: 4,
      offset: 0
    }
  }, _react.default.createElement(DemoContent, null, "Small Screen Offset 0"))));
};

exports.offset = offset;

var condensed = function condensed() {
  return _react.default.createElement(_.Grid, {
    condensed: true
  }, _react.default.createElement(_.Row, null, _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4"))));
};

exports.condensed = condensed;

var condensedColumns = function condensedColumns() {
  return _react.default.createElement(_.Grid, null, _react.default.createElement(_.Row, null, _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4"))), _react.default.createElement(_.Row, {
    condensed: true
  }, _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4"))), _react.default.createElement(_.Row, null, _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4"))));
};

exports.condensedColumns = condensedColumns;

var fullWidth = function fullWidth() {
  return _react.default.createElement(_.Grid, {
    fullWidth: true
  }, _react.default.createElement(_.Row, null, _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4")), _react.default.createElement(_.Column, null, _react.default.createElement(DemoContent, null, "1/4"))));
};

exports.fullWidth = fullWidth;