"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _react = _interopRequireDefault(require("react"));

var _Toolbar = _interopRequireWildcard(require("../Toolbar"));

var _OverflowMenu = _interopRequireDefault(require("../OverflowMenu"));

var _ToolbarSearch = _interopRequireDefault(require("../ToolbarSearch"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
describe('Toolbar', function () {
  describe('renders as expected', function () {
    var toolbar = (0, _enzyme.mount)(_react.default.createElement(_Toolbar.default, {
      className: "extra-class"
    }));
    describe('toolbar container', function () {
      it('should render the expected classes', function () {
        expect(toolbar.children().hasClass("".concat(prefix, "--toolbar"))).toEqual(true);
        expect(toolbar.children().hasClass('extra-class')).toEqual(true);
      });
    });
  });
  describe('Toolbar Search Item', function () {
    var toolbar = (0, _enzyme.mount)(_react.default.createElement(_Toolbar.default, {
      className: "extra-class"
    }, _react.default.createElement(_Toolbar.ToolbarItem, {
      type: "search"
    })));
    var toolbarSearch = (0, _enzyme.mount)(_react.default.createElement(_ToolbarSearch.default, {
      placeHolderText: "Test placeholder"
    }));
    var expandBtn = toolbarSearch.find('button');
    it('should render the toolbar search item inside the toolbar', function () {
      expect(toolbar.find(_Toolbar.ToolbarItem).length).toEqual(1);
    });
    it('should have the expected placeholder text', function () {
      expect(toolbarSearch.props().placeHolderText).toEqual('Test placeholder');
    });
    it('should expand the search item when the search icon is clicked', function () {
      expect(toolbarSearch.state().expanded).toEqual(false);
      expandBtn.simulate('click');
      expect(toolbarSearch.state().expanded).toEqual(true);
    });
    it('should minimize the search item when the search icon is clicked when the state is expanded', function () {
      expect(toolbarSearch.state().expanded).toEqual(true);
      expandBtn.simulate('click');
      expect(toolbarSearch.state().expanded).toEqual(false);
    });
    it('should minimize the search when clicking outside of the search item', function () {
      var rootWrapper = (0, _enzyme.shallow)(_react.default.createElement(_ToolbarSearch.default, null));
      expect(rootWrapper.state().expanded).toEqual(false);
      rootWrapper.setState({
        expanded: true
      });
      rootWrapper.props().onClickOutside();
      expect(rootWrapper.state().expanded).toEqual(false);
    });
  });
  describe('ToolbarItem with an overflow menu', function () {
    var toolbarItem = (0, _enzyme.mount)(_react.default.createElement(_Toolbar.ToolbarItem, null, _react.default.createElement(_OverflowMenu.default, null)));
    it('should render an overflow menu inside a toolbar item', function () {
      expect(toolbarItem.find(_OverflowMenu.default).length).toEqual(1);
    });
    describe('with ToolbarTitle ', function () {
      var withToolbarTitle = (0, _enzyme.mount)(_react.default.createElement(_Toolbar.ToolbarItem, null, _react.default.createElement(_OverflowMenu.default, {
        open: true
      }, _react.default.createElement(_Toolbar.ToolbarTitle, {
        title: "Test title"
      }))));
      var toolbarTitle = withToolbarTitle.find(_Toolbar.ToolbarTitle);
      it('should render a toolbar title with the expected className', function () {
        expect(toolbarTitle.children().hasClass("".concat(prefix, "--toolbar-menu__title"))).toEqual(true);
      });
      it('should render a toolbar title with the expected title', function () {
        expect(toolbarTitle.props().title).toEqual('Test title');
      });
    });
    describe('with ToolbarOption ', function () {
      var withToolbarOption = (0, _enzyme.mount)(_react.default.createElement(_Toolbar.ToolbarItem, null, _react.default.createElement(_OverflowMenu.default, {
        open: true
      }, _react.default.createElement(_Toolbar.ToolbarOption, null, _react.default.createElement("div", null, "Test child")))));
      var toolbarOption = withToolbarOption.find(_Toolbar.ToolbarOption);
      it('should render a toolbar option with the expected className', function () {
        expect(toolbarOption.children().hasClass("".concat(prefix, "--toolbar-menu__option"))).toEqual(true);
      });
      it('should render with the expected children', function () {
        expect(toolbarOption.find('div').length).toEqual(1);
      });
    });
    describe('with ToolbarDivider ', function () {
      var withToolbarDivider = (0, _enzyme.mount)(_react.default.createElement(_Toolbar.ToolbarItem, null, _react.default.createElement(_OverflowMenu.default, {
        open: true
      }, _react.default.createElement(_Toolbar.ToolbarDivider, null))));
      var toolbarDivider = withToolbarDivider.find(_Toolbar.ToolbarDivider);
      it('should render a toolbar divider with the expected className', function () {
        expect(toolbarDivider.children().hasClass("".concat(prefix, "--toolbar-menu__divider"))).toEqual(true);
      });
    });
  });
});