"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _ToggleSmall = _interopRequireDefault(require("../ToggleSmall"));

var _ToggleSmall2 = _interopRequireDefault(require("../ToggleSmall/ToggleSmall.Skeleton"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var a11yprops = function a11yprops() {
  return _defineProperty({
    labelText: (0, _addonKnobs.text)('Label toggle input control (labelText)', '')
  }, 'aria-label', (0, _addonKnobs.text)('ARIA label of the toggle (aria-label)', ''));
};

var toggleProps = function toggleProps() {
  return _objectSpread({}, a11yprops(), {
    className: 'some-class',
    labelA: (0, _addonKnobs.text)('Label for untoggled state (labelA)', ''),
    labelB: (0, _addonKnobs.text)('Label for toggled state (labelB)', ''),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    onChange: (0, _addonActions.action)('onChange'),
    onToggle: (0, _addonActions.action)('onToggle')
  });
};

(0, _react2.storiesOf)('ToggleSmall', module).addDecorator(_addonKnobs.withKnobs).add('toggled', function () {
  return _react.default.createElement(_ToggleSmall.default, _extends({
    defaultToggled: true
  }, toggleProps(), {
    className: "some-class",
    id: "toggle-1"
  }));
}, {
  info: {
    text: "\n            Toggles are controls that are used to quickly switch between two possible states. The example below shows\n            an uncontrolled Toggle component. To use the Toggle component as a controlled component, set the toggled property.\n            Setting the toggled property will allow you to change the value dynamically, whereas setting the defaultToggled\n            prop will only set the value initially. This example has defaultToggled set to true. Small toggles may be used\n            when there is not enough space for a regular sized toggle. This issue is most commonly found in tables.\n          "
  }
}).add('untoggled', function () {
  return _react.default.createElement(_ToggleSmall.default, _extends({}, toggleProps(), {
    className: "some-class",
    id: "toggle-1"
  }));
}, {
  info: {
    text: "\n            Toggles are controls that are used to quickly switch between two possible states. The example below shows\n            an uncontrolled Toggle component. To use the Toggle component as a controlled component, set the toggled property.\n            Setting the toggled property will allow you to change the value dynamically, whereas setting the defaultToggled\n            prop will only set the value initially. Small toggles may be used when there is not enough space for a regular sized toggle. This issue is most\n            commonly found in tables.\n          "
  }
}).add('skeleton', function () {
  return _react.default.createElement(_ToggleSmall2.default, a11yprops());
}, {
  info: {
    text: "\n            Placeholder skeleton state to use when content is loading.\n          "
  }
});