# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [8.10.17](https://github.com/IBM/kui/compare/v8.10.16...v8.10.17) (2020-10-01)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [8.10.16](https://github.com/IBM/kui/compare/v8.10.15...v8.10.16) (2020-10-01)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [8.10.15](https://github.com/IBM/kui/compare/v8.10.14...v8.10.15) (2020-07-22)

### Bug Fixes

- Editor component does not respond to tab layout changes ([b4201f9](https://github.com/IBM/kui/commit/b4201f9)), closes [#5231](https://github.com/IBM/kui/issues/5231) [#5232](https://github.com/IBM/kui/issues/5232)
- **plugins/plugin-client-common:** close tabs doesn't produce the correct tab content ([e9602ec](https://github.com/IBM/kui/commit/e9602ec)), closes [#5220](https://github.com/IBM/kui/issues/5220)
- **plugins/plugin-client-common:** editor component does not respond to font zooming ([6919338](https://github.com/IBM/kui/commit/6919338)), closes [#5120](https://github.com/IBM/kui/issues/5120)

## [8.10.14](https://github.com/IBM/kui/compare/v8.10.13...v8.10.14) (2020-07-22)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [8.10.13](https://github.com/IBM/kui/compare/v8.10.12...v8.10.13) (2020-07-14)

### Bug Fixes

- **plugins/plugin-client-common:** clearing Terminal does not abort watchers ([4ff89e5](https://github.com/IBM/kui/commit/4ff89e5)), closes [#5116](https://github.com/IBM/kui/issues/5116)

## [8.10.12](https://github.com/IBM/kui/compare/v8.10.11...v8.10.12) (2020-07-10)

### Bug Fixes

- multiple issues with tab switching versus status stripe widgets ([07245b2](https://github.com/IBM/kui/commit/07245b2)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-client-common:** input may not receive focus on tab switch ([9e61c3a](https://github.com/IBM/kui/commit/9e61c3a)), closes [#5102](https://github.com/IBM/kui/issues/5102)

## [8.10.11](https://github.com/IBM/kui/compare/v8.10.10...v8.10.11) (2020-07-09)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [8.10.10](https://github.com/IBM/kui/compare/v8.10.9...v8.10.10) (2020-07-07)

### Bug Fixes

- **plugins/plugin-client-common:** clicking 'remove' of a watchable response doesn't abort the underlying pty job ([22bd236](https://github.com/IBM/kui/commit/22bd236)), closes [#5090](https://github.com/IBM/kui/issues/5090)

## [8.10.9](https://github.com/IBM/kui/compare/v8.10.8...v8.10.9) (2020-07-06)

### Bug Fixes

- **plugins/plugin-client-default:** improve debug logging of client properties ([82eb6a2](https://github.com/IBM/kui/commit/82eb6a2)), closes [#5088](https://github.com/IBM/kui/issues/5088)

## [8.10.8](https://github.com/IBM/kui/compare/v8.10.7...v8.10.8) (2020-07-02)

### Bug Fixes

- kubectl help misformats helm help tables ([356e1c0](https://github.com/IBM/kui/commit/356e1c0)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- **plugins/plugin-client-common:** "No resources" in watch pane can occlude watch pane title ([ce00dd6](https://github.com/IBM/kui/commit/ce00dd6)), closes [#5064](https://github.com/IBM/kui/issues/5064)
- **plugins/plugin-client-common:** decrease height of table footer ([365b819](https://github.com/IBM/kui/commit/365b819)), closes [#5072](https://github.com/IBM/kui/issues/5072)

## [8.10.7](https://github.com/IBM/kui/compare/v8.10.6...v8.10.7) (2020-07-01)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [8.10.6](https://github.com/IBM/kui/compare/v8.10.5...v8.10.6) (2020-06-30)

### Bug Fixes

- **plugins/plugin-client-common:** disableTableTitle also disables title of watch panes ([06cd62b](https://github.com/IBM/kui/commit/06cd62b)), closes [#5036](https://github.com/IBM/kui/issues/5036)
- **plugins/plugin-client-common:** double watch panes may open up ([874291c](https://github.com/IBM/kui/commit/874291c)), closes [#5034](https://github.com/IBM/kui/issues/5034)
- **plugins/plugin-client-common:** leftover debug printfs in table sorting ([5db023a](https://github.com/IBM/kui/commit/5db023a)), closes [#5030](https://github.com/IBM/kui/issues/5030)
- move default loadingDone icon into plugin-client-common ([708a058](https://github.com/IBM/kui/commit/708a058)), closes [#5026](https://github.com/IBM/kui/issues/5026)
- reduce custom CSS rules for table UI ([c24dbc2](https://github.com/IBM/kui/commit/c24dbc2)), closes [#5024](https://github.com/IBM/kui/issues/5024)

### Features

- **plugins/plugin-client-common:** use Cards to wrap kube tables and grids ([8b824d4](https://github.com/IBM/kui/commit/8b824d4)), closes [#5032](https://github.com/IBM/kui/issues/5032)

## [8.10.5](https://github.com/IBM/kui/compare/v8.10.4...v8.10.5) (2020-06-27)

### Features

- allow clients to modify the session lifecycle UI by providing custom strings ([1d1ebcc](https://github.com/IBM/kui/commit/1d1ebcc)), closes [#5019](https://github.com/IBM/kui/issues/5019)

## [8.10.4](https://github.com/IBM/kui/compare/v8.10.3...v8.10.4) (2020-06-26)

### Bug Fixes

- still see name-related breadcrumbs and short-name header with feature flag sidecarName 'heroText' ([71c3f06](https://github.com/IBM/kui/commit/71c3f06)), closes [#5013](https://github.com/IBM/kui/issues/5013)
- **plugins/plugin-client-common:** WatchPane has incorrect padding ([51eeedf](https://github.com/IBM/kui/commit/51eeedf)), closes [#5015](https://github.com/IBM/kui/issues/5015)
- Card component does not render well in dark themes ([f3c9b89](https://github.com/IBM/kui/commit/f3c9b89)), closes [#4996](https://github.com/IBM/kui/issues/4996)
- clients should be able to enable watcher auto pinning without enabling splitTerminals ([1126316](https://github.com/IBM/kui/commit/1126316)), closes [#5002](https://github.com/IBM/kui/issues/5002)
- Confirm dialog color contrast issues ([5681983](https://github.com/IBM/kui/commit/5681983)), closes [#4995](https://github.com/IBM/kui/issues/4995)
- increase contrast in watch pane ([f443886](https://github.com/IBM/kui/commit/f443886)), closes [#5000](https://github.com/IBM/kui/issues/5000) [#5001](https://github.com/IBM/kui/issues/5001)

### Features

- add capability to show welcome widget to new users in Terminal ([332627f](https://github.com/IBM/kui/commit/332627f)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- Update default loadingDone to use Card component ([73d6dd7](https://github.com/IBM/kui/commit/73d6dd7)), closes [#4986](https://github.com/IBM/kui/issues/4986)

## [8.10.3](https://github.com/IBM/kui/compare/v8.10.2...v8.10.3) (2020-06-25)

### Bug Fixes

- move patternfly alignment out of patternfly themes plugin ([ef048a7](https://github.com/IBM/kui/commit/ef048a7)), closes [#4988](https://github.com/IBM/kui/issues/4988)

## [8.10.2](https://github.com/IBM/kui/compare/v8.10.1...v8.10.2) (2020-06-24)

### Bug Fixes

- **plugins/plugin-client-common:** carbon breadcrumbs may not have proper hover effect ([b8ab712](https://github.com/IBM/kui/commit/b8ab712)), closes [#4962](https://github.com/IBM/kui/issues/4962)
- **plugins/plugin-client-common:** improve Terminal screenshots by adding padding ([6764be3](https://github.com/IBM/kui/commit/6764be3)), closes [#4981](https://github.com/IBM/kui/issues/4981)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([6027968](https://github.com/IBM/kui/commit/6027968)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** poor alignment of sidecar toolbar elements ([9fd411c](https://github.com/IBM/kui/commit/9fd411c)), closes [#4970](https://github.com/IBM/kui/issues/4970)
- **plugins/plugin-client-common:** reverse-i-search does not properly report no matches ([ad947fc](https://github.com/IBM/kui/commit/ad947fc)), closes [#4943](https://github.com/IBM/kui/issues/4943)
- **plugins/plugin-client-common:** Screenshot modal never goes away ([334f921](https://github.com/IBM/kui/commit/334f921)), closes [#4979](https://github.com/IBM/kui/issues/4979)
- **plugins/plugin-client-common:** spurious warning in the console re: Tag ([5440458](https://github.com/IBM/kui/commit/5440458)), closes [#4959](https://github.com/IBM/kui/issues/4959)
- **plugins/plugin-client-common:** UpdateNotification widget has invisible background color ([7542e85](https://github.com/IBM/kui/commit/7542e85)), closes [#4968](https://github.com/IBM/kui/issues/4968)
- **plugins/plugin-patternfly-themes:** update theme alignment to patternfly v4 ([cac1ad3](https://github.com/IBM/kui/commit/cac1ad3)), closes [#4948](https://github.com/IBM/kui/issues/4948)
- upgrade @patternfly/react-core to latest ([04e4668](https://github.com/IBM/kui/commit/04e4668)), closes [#4937](https://github.com/IBM/kui/issues/4937)

### Features

- add a command to return the Card Component in Terminal ([da9ab17](https://github.com/IBM/kui/commit/da9ab17)), closes [#4973](https://github.com/IBM/kui/issues/4973)
- add alert command to display Alert component in Terminal ([27dd17e](https://github.com/IBM/kui/commit/27dd17e)), closes [#4957](https://github.com/IBM/kui/issues/4957)
- **plugins/plugin-client-common:** add support for Tags in StatusStripe ([738ec22](https://github.com/IBM/kui/commit/738ec22)), closes [#4951](https://github.com/IBM/kui/issues/4951)
- **plugins/plugin-client-common:** improve accessibility of "red" error grid cells ([22f8db8](https://github.com/IBM/kui/commit/22f8db8)), closes [#4938](https://github.com/IBM/kui/issues/4938)

## [8.10.1](https://github.com/IBM/kui/compare/v8.10.0...v8.10.1) (2020-06-18)

### Bug Fixes

- **plugins/plugin-client-common:** add error icon for error blocks ([b1bd048](https://github.com/IBM/kui/commit/b1bd048)), closes [#4907](https://github.com/IBM/kui/issues/4907)
- **plugins/plugin-client-common:** kubectl edit saves can result in unstyled notification ([f763d94](https://github.com/IBM/kui/commit/f763d94)), closes [#4930](https://github.com/IBM/kui/issues/4930)
- **plugins/plugin-client-common:** regression: non-empty repl output has 'ok' at the end ([4e763c1](https://github.com/IBM/kui/commit/4e763c1)), closes [#4924](https://github.com/IBM/kui/issues/4924)
- page-content p should not use text-align: justify ([30c8851](https://github.com/IBM/kui/commit/30c8851)), closes [#4908](https://github.com/IBM/kui/issues/4908)

### Features

- **plugins/plugin-client-common:** support client option for hero names in sidecar ([6b930d9](https://github.com/IBM/kui/commit/6b930d9)), closes [#4909](https://github.com/IBM/kui/issues/4909)

# [8.10.0](https://github.com/IBM/kui/compare/v4.5.0...v8.10.0) (2020-06-17)

### Bug Fixes

- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** Screenshot button should not be offered inBrowser ([d1c2cfb](https://github.com/IBM/kui/commit/d1c2cfb)), closes [#4636](https://github.com/IBM/kui/issues/4636)
- **plugins/plugin-client-common:** status cells of live tables do not always blink ([c94b05e](https://github.com/IBM/kui/commit/c94b05e)), closes [#4903](https://github.com/IBM/kui/issues/4903)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- erratic scroll region behavior ([be0e2a0](https://github.com/IBM/kui/commit/be0e2a0)), closes [#4898](https://github.com/IBM/kui/issues/4898)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** clicking the remove button of a repl block results in an error white screen ([49bfbcc](https://github.com/IBM/kui/commit/49bfbcc)), closes [#4855](https://github.com/IBM/kui/issues/4855)
- **plugins/plugin-client-common:** dropdown in sidecar theming and spacing tweaks ([1a48af3](https://github.com/IBM/kui/commit/1a48af3)), closes [#4680](https://github.com/IBM/kui/issues/4680)
- **plugins/plugin-client-common:** improve visibility of sidecar scrollbars ([827d75a](https://github.com/IBM/kui/commit/827d75a)), closes [#4667](https://github.com/IBM/kui/issues/4667)
- **plugins/plugin-client-common:** in Popup mode, use > rather than / for prompt in bottom input ([1360bed](https://github.com/IBM/kui/commit/1360bed)), closes [#4887](https://github.com/IBM/kui/issues/4887)
- **plugins/plugin-client-common:** increase font size of status stripe ([2fab637](https://github.com/IBM/kui/commit/2fab637)), closes [#4698](https://github.com/IBM/kui/issues/4698)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** input element changes height with i-search and bottomInput ([abf9890](https://github.com/IBM/kui/commit/abf9890)), closes [#4685](https://github.com/IBM/kui/issues/4685)
- **plugins/plugin-client-common:** LeftNav sidecar nav column width inconsistency ([17e403f](https://github.com/IBM/kui/commit/17e403f)), closes [#4688](https://github.com/IBM/kui/issues/4688)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** LeftNavSidecar does not always reflect updated content ([0f2e1e1](https://github.com/IBM/kui/commit/0f2e1e1)), closes [#4727](https://github.com/IBM/kui/issues/4727) [#4732](https://github.com/IBM/kui/issues/4732)
- **plugins/plugin-client-common:** LeftNavSidecar font size and layout issues ([d9914f1](https://github.com/IBM/kui/commit/d9914f1)), closes [#4718](https://github.com/IBM/kui/issues/4718) [#4719](https://github.com/IBM/kui/issues/4719)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** move screenshot button out of status stripe ([0ef900b](https://github.com/IBM/kui/commit/0ef900b)), closes [#4556](https://github.com/IBM/kui/issues/4556)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** PatternFly DropDown rendering glitches ([8efedd8](https://github.com/IBM/kui/commit/8efedd8)), closes [#4649](https://github.com/IBM/kui/issues/4649) [#4651](https://github.com/IBM/kui/issues/4651)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** refine Loading component ([7a07ad3](https://github.com/IBM/kui/commit/7a07ad3)), closes [#4702](https://github.com/IBM/kui/issues/4702)
- **plugins/plugin-client-common:** reverse the dependency of Card and DropDown ([00b8ecf](https://github.com/IBM/kui/commit/00b8ecf)), closes [#4641](https://github.com/IBM/kui/issues/4641)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- **plugins/plugin-client-common:** session init done message messes up Terminal scrolling ([7e80ac1](https://github.com/IBM/kui/commit/7e80ac1)), closes [#4683](https://github.com/IBM/kui/issues/4683)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- **plugins/plugin-client-common:** split button errors are not reported to the user ([fc4e2a2](https://github.com/IBM/kui/commit/fc4e2a2)), closes [#4876](https://github.com/IBM/kui/issues/4876)
- **plugins/plugin-client-common:** table container should only be width:100% for table not display-as-grid ([8f327cd](https://github.com/IBM/kui/commit/8f327cd)), closes [#4871](https://github.com/IBM/kui/issues/4871)
- **plugins/plugin-client-common:** top tab buttons should be owned by the top tab stripe ([9a45c43](https://github.com/IBM/kui/commit/9a45c43)), closes [#4690](https://github.com/IBM/kui/issues/4690)
- **plugins/plugn-client-common:** TopTabStripe stays blue after command execution completes ([68f5841](https://github.com/IBM/kui/commit/68f5841)), closes [#4883](https://github.com/IBM/kui/issues/4883)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- sidecar back/forward should be ordered by visitation rather than insertion ([fba613a](https://github.com/IBM/kui/commit/fba613a)), closes [#4746](https://github.com/IBM/kui/issues/4746)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- split screen terminals sometimes incorrect handle exit ([d63cde7](https://github.com/IBM/kui/commit/d63cde7)), closes [#4860](https://github.com/IBM/kui/issues/4860)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugins/plugin-client-common:** sidecar toolbar text incorrectly aligned ([ddd7460](https://github.com/IBM/kui/commit/ddd7460)), closes [#4659](https://github.com/IBM/kui/issues/4659)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- sidecar container selection kebab has different color with its menu ([639617a](https://github.com/IBM/kui/commit/639617a)), closes [#4676](https://github.com/IBM/kui/issues/4676)
- TopNavSidecar doesn't return to the previous selected Tab when back button is hit ([32acee5](https://github.com/IBM/kui/commit/32acee5)), closes [#4745](https://github.com/IBM/kui/issues/4745)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-client-common:** Terminal screenshot odd w.r.t. auto-focus ([4b1c7d8](https://github.com/IBM/kui/commit/4b1c7d8)), closes [#4739](https://github.com/IBM/kui/issues/4739)
- **plugins/plugin-client-common:** TopNavSidecar tabs easily overflow with narrower windows ([a555cd4](https://github.com/IBM/kui/commit/a555cd4)), closes [#4735](https://github.com/IBM/kui/issues/4735)
- **plugins/plugin-client-common:** WatchPane has non-zero height even when empty ([67a7070](https://github.com/IBM/kui/commit/67a7070)), closes [#4629](https://github.com/IBM/kui/issues/4629)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- <Kui> should allow for custom Input elements ([193a108](https://github.com/IBM/kui/commit/193a108)), closes [#4672](https://github.com/IBM/kui/issues/4672)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for <Kui noPromptContext/> and <Kui prompt=">"/> ([a92063d](https://github.com/IBM/kui/commit/a92063d)), closes [#4653](https://github.com/IBM/kui/issues/4653)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow <Kui/> users to provide custom views for session init ([1f35894](https://github.com/IBM/kui/commit/1f35894)), closes [#4596](https://github.com/IBM/kui/issues/4596)
- allow subclasses of InputProvider to specify their own State ([c3fc88e](https://github.com/IBM/kui/commit/c3fc88e)), closes [#4756](https://github.com/IBM/kui/issues/4756)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- Dropdown spi and use in Terminal Block ([327917b](https://github.com/IBM/kui/commit/327917b)), closes [#4589](https://github.com/IBM/kui/issues/4589) [#4556](https://github.com/IBM/kui/issues/4556)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- RadioTable and port of the themes table to use it ([79a3e8e](https://github.com/IBM/kui/commit/79a3e8e)), closes [#4507](https://github.com/IBM/kui/issues/4507)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- update checker ([a7908d2](https://github.com/IBM/kui/commit/a7908d2)), closes [#4537](https://github.com/IBM/kui/issues/4537)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [8.9.0](https://github.com/IBM/kui/compare/v4.5.0...v8.9.0) (2020-06-09)

### Bug Fixes

- **plugins/plugin-client-common:** improve visibility of sidecar scrollbars ([827d75a](https://github.com/IBM/kui/commit/827d75a)), closes [#4667](https://github.com/IBM/kui/issues/4667)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** dropdown in sidecar theming and spacing tweaks ([1a48af3](https://github.com/IBM/kui/commit/1a48af3)), closes [#4680](https://github.com/IBM/kui/issues/4680)
- **plugins/plugin-client-common:** increase font size of status stripe ([2fab637](https://github.com/IBM/kui/commit/2fab637)), closes [#4698](https://github.com/IBM/kui/issues/4698)
- **plugins/plugin-client-common:** input element changes height with i-search and bottomInput ([abf9890](https://github.com/IBM/kui/commit/abf9890)), closes [#4685](https://github.com/IBM/kui/issues/4685)
- **plugins/plugin-client-common:** LeftNav sidecar nav column width inconsistency ([17e403f](https://github.com/IBM/kui/commit/17e403f)), closes [#4688](https://github.com/IBM/kui/issues/4688)
- **plugins/plugin-client-common:** LeftNavSidecar font size and layout issues ([d9914f1](https://github.com/IBM/kui/commit/d9914f1)), closes [#4718](https://github.com/IBM/kui/issues/4718) [#4719](https://github.com/IBM/kui/issues/4719)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** Screenshot button should not be offered inBrowser ([d1c2cfb](https://github.com/IBM/kui/commit/d1c2cfb)), closes [#4636](https://github.com/IBM/kui/issues/4636)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- sidecar back/forward should be ordered by visitation rather than insertion ([fba613a](https://github.com/IBM/kui/commit/fba613a)), closes [#4746](https://github.com/IBM/kui/issues/4746)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- TopNavSidecar doesn't return to the previous selected Tab when back button is hit ([32acee5](https://github.com/IBM/kui/commit/32acee5)), closes [#4745](https://github.com/IBM/kui/issues/4745)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** LeftNavSidecar does not always reflect updated content ([0f2e1e1](https://github.com/IBM/kui/commit/0f2e1e1)), closes [#4727](https://github.com/IBM/kui/issues/4727) [#4732](https://github.com/IBM/kui/issues/4732)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** move screenshot button out of status stripe ([0ef900b](https://github.com/IBM/kui/commit/0ef900b)), closes [#4556](https://github.com/IBM/kui/issues/4556)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** PatternFly DropDown rendering glitches ([8efedd8](https://github.com/IBM/kui/commit/8efedd8)), closes [#4649](https://github.com/IBM/kui/issues/4649) [#4651](https://github.com/IBM/kui/issues/4651)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** refine Loading component ([7a07ad3](https://github.com/IBM/kui/commit/7a07ad3)), closes [#4702](https://github.com/IBM/kui/issues/4702)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** reverse the dependency of Card and DropDown ([00b8ecf](https://github.com/IBM/kui/commit/00b8ecf)), closes [#4641](https://github.com/IBM/kui/issues/4641)
- **plugins/plugin-client-common:** session init done message messes up Terminal scrolling ([7e80ac1](https://github.com/IBM/kui/commit/7e80ac1)), closes [#4683](https://github.com/IBM/kui/issues/4683)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** sidecar toolbar text incorrectly aligned ([ddd7460](https://github.com/IBM/kui/commit/ddd7460)), closes [#4659](https://github.com/IBM/kui/issues/4659)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** Terminal screenshot odd w.r.t. auto-focus ([4b1c7d8](https://github.com/IBM/kui/commit/4b1c7d8)), closes [#4739](https://github.com/IBM/kui/issues/4739)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** TopNavSidecar tabs easily overflow with narrower windows ([a555cd4](https://github.com/IBM/kui/commit/a555cd4)), closes [#4735](https://github.com/IBM/kui/issues/4735)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- sidecar container selection kebab has different color with its menu ([639617a](https://github.com/IBM/kui/commit/639617a)), closes [#4676](https://github.com/IBM/kui/issues/4676)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane has non-zero height even when empty ([67a7070](https://github.com/IBM/kui/commit/67a7070)), closes [#4629](https://github.com/IBM/kui/issues/4629)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- <Kui> should allow for custom Input elements ([193a108](https://github.com/IBM/kui/commit/193a108)), closes [#4672](https://github.com/IBM/kui/issues/4672)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for <Kui noPromptContext/> and <Kui prompt=">"/> ([a92063d](https://github.com/IBM/kui/commit/a92063d)), closes [#4653](https://github.com/IBM/kui/issues/4653)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow <Kui/> users to provide custom views for session init ([1f35894](https://github.com/IBM/kui/commit/1f35894)), closes [#4596](https://github.com/IBM/kui/issues/4596)
- allow subclasses of InputProvider to specify their own State ([c3fc88e](https://github.com/IBM/kui/commit/c3fc88e)), closes [#4756](https://github.com/IBM/kui/issues/4756)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- Dropdown spi and use in Terminal Block ([327917b](https://github.com/IBM/kui/commit/327917b)), closes [#4589](https://github.com/IBM/kui/issues/4589) [#4556](https://github.com/IBM/kui/issues/4556)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- RadioTable and port of the themes table to use it ([79a3e8e](https://github.com/IBM/kui/commit/79a3e8e)), closes [#4507](https://github.com/IBM/kui/issues/4507)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [8.7.0](https://github.com/IBM/kui/compare/v4.5.0...v8.7.0) (2020-05-08)

### Bug Fixes

- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

## [8.6.1](https://github.com/IBM/kui/compare/v4.5.0...v8.6.1) (2020-04-25)

### Bug Fixes

- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [8.6.0](https://github.com/IBM/kui/compare/v4.5.0...v8.6.0) (2020-04-23)

### Bug Fixes

- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [8.5.0](https://github.com/IBM/kui/compare/v4.5.0...v8.5.0) (2020-04-19)

### Bug Fixes

- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

## [8.4.2](https://github.com/IBM/kui/compare/v4.5.0...v8.4.2) (2020-04-10)

### Bug Fixes

- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)

### chore

- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

## [8.4.1](https://github.com/IBM/kui/compare/v4.5.0...v8.4.1) (2020-04-10)

### Bug Fixes

- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)

### chore

- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [8.4.0](https://github.com/IBM/kui/compare/v4.5.0...v8.4.0) (2020-04-10)

### Bug Fixes

- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)

### chore

- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [8.1.0](https://github.com/IBM/kui/compare/v4.5.0...v8.1.0) (2020-04-04)

### Bug Fixes

- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)

### chore

- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [8.0.0](https://github.com/IBM/kui/compare/v4.5.0...v8.0.0) (2020-03-20)

### Bug Fixes

- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)

### chore

- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

## [6.0.12](https://github.com/IBM/kui/compare/v6.0.11...v6.0.12) (2020-02-03)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [6.0.11](https://github.com/IBM/kui/compare/v6.0.10...v6.0.11) (2020-02-03)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [6.0.10](https://github.com/IBM/kui/compare/v6.0.9...v6.0.10) (2020-02-01)

### Bug Fixes

- **plugins/plugin-client-default:** improve table layout for radio tables ([308d7bc](https://github.com/IBM/kui/commit/308d7bc)), closes [#3596](https://github.com/IBM/kui/issues/3596)

## [6.0.9](https://github.com/IBM/kui/compare/v6.0.8...v6.0.9) (2020-01-31)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [6.0.8](https://github.com/IBM/kui/compare/v4.5.0...v6.0.8) (2020-01-30)

### Bug Fixes

- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)

## [6.0.7](https://github.com/IBM/kui/compare/v4.5.0...v6.0.7) (2020-01-30)

### Bug Fixes

- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)

## [6.0.6](https://github.com/IBM/kui/compare/v4.5.0...v6.0.6) (2020-01-30)

### Bug Fixes

- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)

## [6.0.5](https://github.com/IBM/kui/compare/v4.5.0...v6.0.5) (2020-01-29)

### Bug Fixes

- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)

## [6.0.4](https://github.com/IBM/kui/compare/v6.0.3...v6.0.4) (2020-01-28)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [6.0.3](https://github.com/IBM/kui/compare/v4.5.0...v6.0.3) (2020-01-28)

### Bug Fixes

- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
