"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _2 = require("../..");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}; // FIXME:

/* eslint-disable react/prop-types */


class Popup extends React.PureComponent {
  constructor(props) {
    super(props);
    const tabModel = new _2.TabModel();

    _core.eventBus.onceWithTabId('/tab/close/request', tabModel.uuid, (_, tab) => __awaiter(this, void 0, void 0, function* () {
      // tab close is window close for the popup client
      tab.REPL.qexec('window close', undefined, undefined, {
        tab
      });
    }));

    _core.eventBus.onCommandComplete(tabModel.uuid, ({
      command,
      response
    }) => __awaiter(this, void 0, void 0, function* () {
      if (process.env.KUI_TEE_TO_FILE) {
        // tee the response to a file
        // maybe in the future we could do this better
        // e.g. hoistingit to Kui, making it driven off a property rather than env variable
        yield (0, _core.teeToFile)(response);
      }

      this.setState({
        promptPlaceholder: command
      });
    }));

    this.state = {
      model: tabModel,
      promptPlaceholder: ''
    };
  }

  onTabReady(tab) {
    tab.REPL.pexec(this.props.commandLine.join(' '), {
      tab
    });
  }

  render() {
    return React.createElement("div", {
      className: "kui--full-height"
    }, React.createElement(_2.TabContent, {
      noActiveInput: true,
      uuid: this.state.model.uuid,
      active: true,
      state: this.state.model.state,
      onTabReady: this.onTabReady.bind(this)
    }, React.createElement(_2.ComboSidecar, {
      defaultWidth: "75%"
      /* Split75 */

    })), React.createElement(_2.StatusStripe, null, React.createElement(_2.ContextWidgets, {
      className: "kui--input-stripe-in-status-stripe"
    }, React.createElement(_2.InputStripe, {
      promptPlaceholder: this.state.promptPlaceholder,
      uuid: this.state.model.uuid
    })), this.props.children));
  }

}

exports.default = Popup;