"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _ = require("../../..");

var _TopNavSidecar = require("./TopNavSidecar");

var _BaseSidecar = require("./BaseSidecar");

var _Navigation = _interopRequireDefault(require("../../spi/Navigation"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable @typescript-eslint/no-empty-function */

/** Lazily load KuiContent; see https://github.com/IBM/kui/issues/3746 */
const KuiContent = React.lazy(() => Promise.resolve().then(() => require('../../Content/KuiContent')));
/**
 *
 * LeftNavSidecar
 * -------------------------
 * | <TitleBar/>           |
 * -------------------------
 * | A1   |                |
 * |  a1  | <Content>      |
 * |  a2  |  <KuiContent/> |
 * | B1   | </Content>     |
 * |  b1  |                |
 * |  b2  |                |
 * -------------------------
 *  ^^^^^ <SideNav/>
 *   A1, B1: <SideNavMenu/>
 *   a1, b1: <SideNavMenuItem/>
 *
 */

class LeftNavSidecar extends _BaseSidecar.BaseSidecar {
  constructor(props) {
    super(props);
    const onResponse = this.onResponse.bind(this);

    _core.eventBus.onNavResponse(this.props.uuid, onResponse);

    this.cleaners.push(() => _core.eventBus.offNavResponse(this.props.uuid, onResponse));
    this.state = {
      repl: undefined,
      tab: undefined,
      dom: undefined,
      history: undefined,
      current: undefined
    };
  }
  /** Is getState() idempotent? i.e. Will two command executions that satisfy `sameCommand` always produce the same response? */


  idempotent() {
    return true;
  }
  /** Should we display Back/Forward arrows for history navigation? */


  useArrowNavigation() {
    return false;
  }
  /** 30/70 split between the Terminal and the LeftNavSidecar */


  defaultWidth() {
    return "70%"
    /* Split70 */
    ;
  }
  /** @return a `HistoryEntry` for the given `Response` */


  getState(tab, response, execUUID, argvNoOptions, parsedOptions) {
    const navigations = []; // get state from each of the left navigation

    response.menus.forEach(menu => {
      const state = (0, _TopNavSidecar.getStateFromMMR)(tab, {
        modes: menu.items
      }, execUUID, argvNoOptions, parsedOptions);
      navigations.push(Object.assign({
        title: menu.label
      }, state));
    });
    return {
      cwd: (0, _BaseSidecar.cwd)(),
      execUUID,
      argvNoOptions,
      parsedOptions,
      allNavs: navigations,
      allLinks: response.links || [],
      current: {
        menuIdx: 0,
        tabIdx: navigations[0].currentTabIndex
      },
      response
    };
  }

  isFixedWidth() {
    return true;
  }

  changeCurrent(menuIdx, tabIdx) {
    this.setState(({
      current,
      history
    }) => {
      const newCurrent = Object.assign({}, current, {
        current: {
          menuIdx,
          tabIdx
        }
      });
      history.updateActive(newCurrent);
      return {
        current: newCurrent
      };
    });
  }
  /** render the leftnav part */


  nav() {
    return React.createElement(_Navigation.default, {
      tab: this.state.tab,
      current: this.current,
      changeCurrent: this.changeCurrent.bind(this)
    });
  }

  bodyContent(tabIdx, menuIdx = 0) {
    return React.createElement(React.Suspense, {
      fallback: React.createElement("div", null)
    }, React.createElement(KuiContent, {
      key: `${this.current.execUUID}-${menuIdx}-${tabIdx}`,
      tab: this.state.tab,
      mode: this.current.allNavs[menuIdx].tabs[tabIdx],
      isActive: true,
      args: {
        argvNoOptions: this.state.current.argvNoOptions,
        parsedOptions: this.state.current.parsedOptions
      },
      response: {
        modes: this.current.response.menus[menuIdx].items
      }
    }));
  }

  bodyContainer(tabIdx, menuIdx) {
    return React.createElement("div", {
      className: "kui--sidecar-content"
    }, this.bodyContent(tabIdx, menuIdx));
  }

  render() {
    if (!this.current || !this.current.response) {
      return React.createElement(_.Loading, null);
    }

    return React.createElement("div", {
      className: 'kui--sidecar kui--inverted-color-context kui--nav-view ' + this.width(),
      ref: dom => this.setState({
        dom
      }),
      "data-view": "leftnav"
    }, ' ', this.title({
      breadcrumbs: this.current.response.breadcrumbs
    }), React.createElement("div", {
      className: "kui--sidecar-header-and-body zoomable"
    }, this.nav(), this.bodyContainer(this.current.current.tabIdx, this.current.current.menuIdx)));
  }

}

exports.default = LeftNavSidecar;