import * as React from 'react';
import TabModel from '../TabModel';
import { TabConfiguration } from './Tab';
import '../../../../web/css/static/TopTabStripe.scss';
/**
 *
 * TabContainer
 * ----------------
 * | TopTabStripe | <--- you are here
 * |--------------|
 * |              |
 * | TabContent[] |
 * |              |
 * ----------------
 *
 */
/**
 *
 * TopTabStripe
 * ----------------------------
 * | Tab | Tab | NewTabButton |
 * |--------------------------|
 *   /\
 *   | activeIdx
 */
export declare type TopTabStripeConfiguration = TabConfiguration;
declare type Props = TopTabStripeConfiguration & {
    tabs: TabModel[];
    activeIdx: number;
    onNewTab: () => void;
    onCloseTab: (idx: number) => void;
    onSwitchTab: (idx: number) => void;
};
export default class TopTabStripe extends React.PureComponent<Props> {
    componentDidMount(): void;
    /**
     * Register any keyboard event listeners
     *
     */
    private addKeyboardListeners;
    /** Render tabs */
    private tabs;
    private headerMenu;
    private headerName;
    /** Buttons that appear in the top right */
    private buttons;
    /**
     * React render handler
     *
     */
    render(): JSX.Element;
}
export {};
