import * as React from 'react';
import { Tab as KuiTab } from '@kui-shell/core';
import { TabCompletionState } from './TabCompletion';
import ActiveISearch from './ActiveISearch';
import { BlockModel } from './BlockModel';
import { BlockViewTraits } from './';
export interface InputOptions {
    /** Optional: placeholder value for prompt */
    promptPlaceholder?: string;
    /** Optional: do not display prompt context, e.g. current working directory */
    noPromptContext?: boolean;
    /** Optional: onChange handler */
    onInputChange?: (event: React.ChangeEvent<HTMLInputElement>) => void;
    /** Optional: onClick handler */
    onInputClick?: (event: React.MouseEvent<HTMLInputElement>) => void;
    /** Optional: onKeyDown handler */
    onInputKeyDown?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Optional: onKeyPress handler */
    onInputKeyPress?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Optional: onKeyUp handler */
    onInputKeyUp?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Optional: onMouseDown handler */
    onInputMouseDown?: (event: React.MouseEvent<HTMLInputElement>) => void;
    /** Optional: onMouseMove handler */
    onInputMouseMove?: (event: React.MouseEvent<HTMLInputElement>) => void;
    /** Optional: onBlur handler */
    onInputBlur?: (event: React.FocusEvent<HTMLInputElement>) => void;
    /** Optional: onFocus handler */
    onInputFocus?: (event: React.FocusEvent<HTMLInputElement>) => void;
    /** Remove the enclosing block */
    willRemove?: () => void;
    /** Capture a screenshot of the enclosing block */
    willScreenshot?: () => void;
    /** Block is about to lose focus */
    willLoseFocus?: () => void;
    unPin?: () => void;
}
declare type InputProps = {
    /** number of commands issued; a strictly increasing natural number */
    idx?: number;
    /** needed temporarily to make pty/client happy */
    _block?: HTMLElement;
    /** tab UUID */
    uuid?: string;
    /** for key handlers, which may go away soon */
    tab?: KuiTab;
    /** state of the Block, e.g. Processing? Active/accepting input? */
    model?: BlockModel;
};
export declare type Props = InputOptions & InputProps & BlockViewTraits;
export interface State {
    /** the execution ID for this prompt, if any */
    execUUID?: string;
    /** DOM element for prompt; set via `ref` in render() below */
    prompt?: HTMLInputElement;
    /** state of active reverse-i-search */
    isearch?: ActiveISearch;
    /** state of tab completion */
    tabCompletion?: TabCompletionState;
    /** spinner? */
    spinner?: ReturnType<typeof setInterval>;
    spinnerDom?: HTMLSpanElement;
}
export declare abstract class InputProvider<S extends State = State> extends React.PureComponent<Props, S> {
    /** this is what the InputProvider needs to provide, minimially */
    protected abstract input(): any;
    /** rendered to the left of the input element */
    protected status(): void;
    /** the "xxx" part of "xxx >" of the prompt */
    protected promptLeft(): JSX.Element;
    /** the ">" part of "xxx >" of the prompt */
    protected promptRight(): JSX.Element;
    protected isearchPrompt(): JSX.Element;
    protected normalPrompt(): JSX.Element;
    /** the "xxx >" prompt part of the input section */
    protected prompt(): JSX.Element;
    render(): JSX.Element;
}
export default class Input extends InputProvider {
    constructor(props: Props);
    /** @return the value of the prompt */
    value(): string;
    /** Owner wants us to focus on the current prompt */
    doFocus(): void;
    private static newSpinner;
    private static updateSpinner;
    static getDerivedStateFromProps(props: Props, state: State): State;
    /** the element that represents the command being/having been/going to be executed */
    protected input(): JSX.Element;
    /** render the time the block started processing */
    private timestamp;
    /** spinner for processing blocks */
    private spinner;
    /** error icon for error blocks */
    private errorIcon;
    private removeAction;
    private screenshotAction;
    private unPinnedAction;
    /** DropDown menu for completed blocks */
    private dropdown;
    /** Close button. Only for pinned blocks for now. */
    private close;
    /**
     * Status elements associated with the block; even though these
     * pertain to the Output part of a Block, these are currently placed
     * in the Input area.
     *
     */
    protected status(): JSX.Element;
}
export {};
