/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { Tag } from 'carbon-components-react';
import '../../../../../web/scss/components/Tag/Carbon.scss';
export default function CarbonTag(props) {
    return (React.createElement("span", { title: props.title },
        React.createElement(Tag, Object.assign({}, props, { type: props.type === 'error' ? 'red' : 'blue' }))));
}
//# sourceMappingURL=Carbon.js.map