/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { eventBus } from '@kui-shell/core';
import TopNavSidecar from './TopNavSidecar';
import LeftNavSidecar from './LeftNavSidecar';
export default class ComboSidecar extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            tab: undefined,
            responseType: undefined
        };
        const onResponse = this.onResponse.bind(this);
        eventBus.onMultiModalResponse(props.uuid, onResponse);
        eventBus.onNavResponse(props.uuid, onResponse);
        // this.cleaners.push(() => eventChannelUnsafe.off(channel1, onResponse))
    }
    componentDidCatch(error, errorInfo) {
        console.error(error, errorInfo);
    }
    onResponse(event) {
        this.setState({
            tab: event.tab,
            responseType: event.responseType
        });
    }
    onClose() {
        // when closing, tell our owner that they can have focus back
        if (this.props.willLoseFocus) {
            this.props.willLoseFocus();
        }
    }
    render() {
        const isLeftNav = this.state.responseType && this.state.responseType === 'NavResponse';
        return (React.createElement("div", { className: "kui--full-height" },
            React.createElement("div", { className: 'kui--full-height' + (isLeftNav || this.state.responseType === undefined ? ' hide' : '') },
                React.createElement(TopNavSidecar, Object.assign({}, this.props, { onClose: this.onClose.bind(this) }))),
            React.createElement("div", { className: 'kui--full-height' + (!isLeftNav ? ' hide' : '') },
                React.createElement(LeftNavSidecar, Object.assign({}, this.props, { onClose: this.onClose.bind(this) })))));
    }
}
//# sourceMappingURL=ComboSidecar.js.map