/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { isUsage, doHelp } from '@kui-shell/plugin-kubectl';
import doExecWithStdout from './exec';
import commandPrefix from '../command-prefix';
const name = /^NAME:\s+([\w-]+)/;
function doInstall(args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (isUsage(args)) {
            return doHelp('helm', args);
        }
        const response = yield doExecWithStdout(args);
        const releaseName = response.match(name)[1];
        return args.REPL.qexec(`helm get ${args.REPL.encodeComponent(releaseName)}`).catch(err => {
            // oops, we tried to be clever and failed; return the original response
            console.error('error in helm get for helm install', err);
            return response;
        });
    });
}
export default (registrar) => {
    registrar.listen(`/${commandPrefix}/helm/install`, doInstall);
};
//# sourceMappingURL=install.js.map