/// <reference types="node" />
import { EventEmitter } from 'events';
import { ScalarResponse } from '../models/entity';
import MultiModalResponse from '../models/mmr/types';
import NavResponse from '../models/NavResponse';
import Tab from '../webapp/tab';
import { CommandStartEvent, CommandCompleteEvent, CommandStartHandler, CommandCompleteHandler } from '../repl/events';
declare const eventChannelUnsafe: EventEmitter;
export default eventChannelUnsafe;
declare class EventBusBase {
    protected readonly eventBus: EventEmitter;
    constructor();
}
declare class WriteEventBus extends EventBusBase {
    emit(channel: '/tab/new' | '/tab/close' | '/tab/offline', tab: Tab): void;
    emit(channel: '/tab/new/request'): void;
    emit(channel: '/tab/switch/request', idx: number): void;
    private emitCommandEvent;
    emitCommandStart(event: CommandStartEvent): void;
    emitCommandComplete(event: CommandCompleteEvent): void;
    emitWithTabId(channel: '/tab/offline' | '/tab/close/request', tabId: string, tab?: Tab): void;
}
declare class ReadEventBus extends WriteEventBus {
    on(channel: '/tab/new' | '/tab/close/request' | '/tab/close' | '/tab/offline', listener: (tab: Tab) => void): void;
    on(channel: '/tab/new/request', listener: () => void): void;
    on(channel: '/tab/switch/request', listener: (tabId: number) => void): void;
    private onCommand;
    private offCommand;
    onAnyCommandStart(handler: CommandStartHandler): void;
    offAnyCommandStart(handler: CommandStartHandler): void;
    onAnyCommandComplete(handler: CommandStartHandler): void;
    offAnyCommandComplete(handler: CommandStartHandler): void;
    onCommandStart(splitId: string, splitHandler: CommandStartHandler, tabId?: string, tabHandler?: CommandStartHandler): void;
    onceCommandStarts(tabId: string, handler: CommandStartHandler): void;
    private onResponseType;
    private offResponseType;
    onScalarResponse(splitId: string, splitHandler: CommandCompleteHandler<ScalarResponse>, tabId?: string, tabHandler?: CommandCompleteHandler<ScalarResponse<import("..").Row>, "NavResponse" | "MultiModalResponse" | "ScalarResponse" | "Incomplete" | "Error">): void;
    offScalarResponse(splitId: string, splitHandler: CommandCompleteHandler<ScalarResponse>, tabId?: string, tabHandler?: CommandCompleteHandler<ScalarResponse<import("..").Row>, "NavResponse" | "MultiModalResponse" | "ScalarResponse" | "Incomplete" | "Error">): void;
    onMultiModalResponse(tabId: string, handler: CommandCompleteHandler<MultiModalResponse, 'MultiModalResponse'>): void;
    offMultiModalResponse(tabId: string, handler: CommandCompleteHandler<MultiModalResponse, 'MultiModalResponse'>): void;
    onNavResponse(tabId: string, handler: CommandCompleteHandler<NavResponse, 'NavResponse'>): void;
    offNavResponse(tabId: string, handler: CommandCompleteHandler<NavResponse, 'NavResponse'>): void;
    onCommandComplete(splitId: string, splitHandler: CommandCompleteHandler, tabId?: string, tabHandler?: CommandCompleteHandler<import("../models/entity").Entity<any, import("..").Row, import("../models/entity").MetadataBearing<any>>, "NavResponse" | "MultiModalResponse" | "ScalarResponse" | "Incomplete" | "Error">): void;
    offCommandStart(splitId: string, splitHandler: CommandStartHandler, tabId?: string, tabHandler?: CommandStartHandler): void;
    offCommandComplete(splitId: string, splitHandler: CommandCompleteHandler, tabId?: string, tabHandler?: CommandCompleteHandler<import("../models/entity").Entity<any, import("..").Row, import("../models/entity").MetadataBearing<any>>, "NavResponse" | "MultiModalResponse" | "ScalarResponse" | "Incomplete" | "Error">): void;
    onWithTabId(channel: '/tab/offline' | '/tab/close/request', tabId: string, listener: (tabId: string, tab: Tab) => void): void;
    offWithTabId(channel: '/tab/offline' | '/tab/close/request', tabId: string, listener: (tabId: string, tab: Tab) => void): void;
    onceWithTabId(channel: '/tab/offline' | '/tab/close/request', tabId: string, listener: (tabId: string, tab: Tab) => void): void;
    once(channel: '/tab/new', listener: (tab: Tab) => void): void;
}
declare class EventBus extends ReadEventBus {
}
export declare const eventBus: EventBus;
/**
 * Hook an event listener up to tab events.
 *
 */
export declare function wireToTabEvents(listener: (tab?: Tab | number) => void): void;
/**
 * Hook an event listener up to the family of standard user
 * interaction events.
 *
 */
export declare function wireToStandardEvents(listener: (tab?: Tab | number) => void): void;
