// Type definitions for @carbon/icons-react 10.11
// Project: https://github.com/carbon-design-system/carbon/tree/master/packages/icons-react
// Definitions by: Eric Liu <https://github.com/metonym>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 3.8

export interface CarbonIconProps extends Omit<React.SVGProps<SVGElement>, 'tabIndex' | 'aria-hidden'> {
    'aria-hidden'?: string;
    'aria-label'?: string;
    'aria-labelledby'?: string;
    height?: number;
    preserveAspectRatio?: string;
    tabIndex?: string;
    title?: string;
    viewBox?: string;
    width?: number;
    xmlns?: string;
}

export type CarbonIconType = (props: CarbonIconProps) => React.FunctionComponentElement<CarbonIconProps>;

export const Accessibility16: CarbonIconType;
export const Accessibility20: CarbonIconType;
export const Accessibility24: CarbonIconType;
export const Accessibility32: CarbonIconType;
export const AccessibilityAlt16: CarbonIconType;
export const AccessibilityAlt20: CarbonIconType;
export const AccessibilityAlt24: CarbonIconType;
export const AccessibilityAlt32: CarbonIconType;
export const AccessibilityColor16: CarbonIconType;
export const AccessibilityColor20: CarbonIconType;
export const AccessibilityColor24: CarbonIconType;
export const AccessibilityColor32: CarbonIconType;
export const AccessibilityColorFilled16: CarbonIconType;
export const AccessibilityColorFilled20: CarbonIconType;
export const AccessibilityColorFilled24: CarbonIconType;
export const AccessibilityColorFilled32: CarbonIconType;
export const Account16: CarbonIconType;
export const Account20: CarbonIconType;
export const Account24: CarbonIconType;
export const Account32: CarbonIconType;
export const Activity16: CarbonIconType;
export const Activity20: CarbonIconType;
export const Activity24: CarbonIconType;
export const Activity32: CarbonIconType;
export const Add16: CarbonIconType;
export const Add20: CarbonIconType;
export const Add24: CarbonIconType;
export const Add32: CarbonIconType;
export const AddAlt16: CarbonIconType;
export const AddAlt20: CarbonIconType;
export const AddAlt24: CarbonIconType;
export const AddAlt32: CarbonIconType;
export const AddComment16: CarbonIconType;
export const AddComment20: CarbonIconType;
export const AddComment24: CarbonIconType;
export const AddComment32: CarbonIconType;
export const AddFilled16: CarbonIconType;
export const AddFilled20: CarbonIconType;
export const AddFilled24: CarbonIconType;
export const AddFilled32: CarbonIconType;
export const Alarm16: CarbonIconType;
export const Alarm20: CarbonIconType;
export const Alarm24: CarbonIconType;
export const Alarm32: CarbonIconType;
export const AlarmAdd16: CarbonIconType;
export const AlarmAdd20: CarbonIconType;
export const AlarmAdd24: CarbonIconType;
export const AlarmAdd32: CarbonIconType;
export const AlarmSubtract16: CarbonIconType;
export const AlarmSubtract20: CarbonIconType;
export const AlarmSubtract24: CarbonIconType;
export const AlarmSubtract32: CarbonIconType;
export const AlignHorizontalCenter16: CarbonIconType;
export const AlignHorizontalCenter20: CarbonIconType;
export const AlignHorizontalCenter24: CarbonIconType;
export const AlignHorizontalCenter32: CarbonIconType;
export const AlignHorizontalLeft16: CarbonIconType;
export const AlignHorizontalLeft20: CarbonIconType;
export const AlignHorizontalLeft24: CarbonIconType;
export const AlignHorizontalLeft32: CarbonIconType;
export const AlignHorizontalRight16: CarbonIconType;
export const AlignHorizontalRight20: CarbonIconType;
export const AlignHorizontalRight24: CarbonIconType;
export const AlignHorizontalRight32: CarbonIconType;
export const AlignVerticalBottom16: CarbonIconType;
export const AlignVerticalBottom20: CarbonIconType;
export const AlignVerticalBottom24: CarbonIconType;
export const AlignVerticalBottom32: CarbonIconType;
export const AlignVerticalCenter16: CarbonIconType;
export const AlignVerticalCenter20: CarbonIconType;
export const AlignVerticalCenter24: CarbonIconType;
export const AlignVerticalCenter32: CarbonIconType;
export const AlignVerticalTop16: CarbonIconType;
export const AlignVerticalTop20: CarbonIconType;
export const AlignVerticalTop24: CarbonIconType;
export const AlignVerticalTop32: CarbonIconType;
export const Analytics16: CarbonIconType;
export const Analytics20: CarbonIconType;
export const Analytics24: CarbonIconType;
export const Analytics32: CarbonIconType;
export const Aperture16: CarbonIconType;
export const Aperture20: CarbonIconType;
export const Aperture24: CarbonIconType;
export const Aperture32: CarbonIconType;
export const Api16: CarbonIconType;
export const Api20: CarbonIconType;
export const Api24: CarbonIconType;
export const Api32: CarbonIconType;
export const Api_116: CarbonIconType;
export const Api_120: CarbonIconType;
export const Api_124: CarbonIconType;
export const Api_132: CarbonIconType;
export const App16: CarbonIconType;
export const App20: CarbonIconType;
export const App24: CarbonIconType;
export const App32: CarbonIconType;
export const AppConnectivity16: CarbonIconType;
export const AppConnectivity20: CarbonIconType;
export const AppConnectivity24: CarbonIconType;
export const AppConnectivity32: CarbonIconType;
export const AppSwitcher16: CarbonIconType;
export const AppSwitcher20: CarbonIconType;
export const AppSwitcher24: CarbonIconType;
export const AppSwitcher32: CarbonIconType;
export const Apple16: CarbonIconType;
export const Apple20: CarbonIconType;
export const Apple24: CarbonIconType;
export const Apple32: CarbonIconType;
export const Application16: CarbonIconType;
export const Application20: CarbonIconType;
export const Application24: CarbonIconType;
export const Application32: CarbonIconType;
export const Apps16: CarbonIconType;
export const Apps20: CarbonIconType;
export const Apps24: CarbonIconType;
export const Apps32: CarbonIconType;
export const Archive16: CarbonIconType;
export const Archive20: CarbonIconType;
export const Archive24: CarbonIconType;
export const Archive32: CarbonIconType;
export const Arrival16: CarbonIconType;
export const Arrival20: CarbonIconType;
export const Arrival24: CarbonIconType;
export const Arrival32: CarbonIconType;
export const ArrowDown16: CarbonIconType;
export const ArrowDown20: CarbonIconType;
export const ArrowDown24: CarbonIconType;
export const ArrowDown32: CarbonIconType;
export const ArrowDownLeft16: CarbonIconType;
export const ArrowDownLeft20: CarbonIconType;
export const ArrowDownLeft24: CarbonIconType;
export const ArrowDownLeft32: CarbonIconType;
export const ArrowDownRight16: CarbonIconType;
export const ArrowDownRight20: CarbonIconType;
export const ArrowDownRight24: CarbonIconType;
export const ArrowDownRight32: CarbonIconType;
export const ArrowLeft16: CarbonIconType;
export const ArrowLeft20: CarbonIconType;
export const ArrowLeft24: CarbonIconType;
export const ArrowLeft32: CarbonIconType;
export const ArrowRight16: CarbonIconType;
export const ArrowRight20: CarbonIconType;
export const ArrowRight24: CarbonIconType;
export const ArrowRight32: CarbonIconType;
export const ArrowShiftDown16: CarbonIconType;
export const ArrowShiftDown20: CarbonIconType;
export const ArrowShiftDown24: CarbonIconType;
export const ArrowShiftDown32: CarbonIconType;
export const ArrowUp16: CarbonIconType;
export const ArrowUp20: CarbonIconType;
export const ArrowUp24: CarbonIconType;
export const ArrowUp32: CarbonIconType;
export const ArrowUpLeft16: CarbonIconType;
export const ArrowUpLeft20: CarbonIconType;
export const ArrowUpLeft24: CarbonIconType;
export const ArrowUpLeft32: CarbonIconType;
export const ArrowUpRight16: CarbonIconType;
export const ArrowUpRight20: CarbonIconType;
export const ArrowUpRight24: CarbonIconType;
export const ArrowUpRight32: CarbonIconType;
export const Arrows16: CarbonIconType;
export const Arrows20: CarbonIconType;
export const Arrows24: CarbonIconType;
export const Arrows32: CarbonIconType;
export const ArrowsHorizontal16: CarbonIconType;
export const ArrowsHorizontal20: CarbonIconType;
export const ArrowsHorizontal24: CarbonIconType;
export const ArrowsHorizontal32: CarbonIconType;
export const ArrowsVertical16: CarbonIconType;
export const ArrowsVertical20: CarbonIconType;
export const ArrowsVertical24: CarbonIconType;
export const ArrowsVertical32: CarbonIconType;
export const Asleep16: CarbonIconType;
export const Asleep20: CarbonIconType;
export const Asleep24: CarbonIconType;
export const Asleep32: CarbonIconType;
export const AsleepFilled16: CarbonIconType;
export const AsleepFilled20: CarbonIconType;
export const AsleepFilled24: CarbonIconType;
export const AsleepFilled32: CarbonIconType;
export const Asset16: CarbonIconType;
export const Asset20: CarbonIconType;
export const Asset24: CarbonIconType;
export const Asset32: CarbonIconType;
export const At16: CarbonIconType;
export const At20: CarbonIconType;
export const At24: CarbonIconType;
export const At32: CarbonIconType;
export const Attachment16: CarbonIconType;
export const Attachment20: CarbonIconType;
export const Attachment24: CarbonIconType;
export const Attachment32: CarbonIconType;
export const AudioConsole16: CarbonIconType;
export const AudioConsole20: CarbonIconType;
export const AudioConsole24: CarbonIconType;
export const AudioConsole32: CarbonIconType;
export const AugmentedReality16: CarbonIconType;
export const AugmentedReality20: CarbonIconType;
export const AugmentedReality24: CarbonIconType;
export const AugmentedReality32: CarbonIconType;
export const Awake16: CarbonIconType;
export const Awake20: CarbonIconType;
export const Awake24: CarbonIconType;
export const Awake32: CarbonIconType;
export const BackToTop16: CarbonIconType;
export const BackToTop20: CarbonIconType;
export const BackToTop24: CarbonIconType;
export const BackToTop32: CarbonIconType;
export const Badge16: CarbonIconType;
export const Badge20: CarbonIconType;
export const Badge24: CarbonIconType;
export const Badge32: CarbonIconType;
export const Bar16: CarbonIconType;
export const Bar20: CarbonIconType;
export const Bar24: CarbonIconType;
export const Bar32: CarbonIconType;
export const Basketball16: CarbonIconType;
export const Basketball20: CarbonIconType;
export const Basketball24: CarbonIconType;
export const Basketball32: CarbonIconType;
export const BatteryCharging16: CarbonIconType;
export const BatteryCharging20: CarbonIconType;
export const BatteryCharging24: CarbonIconType;
export const BatteryCharging32: CarbonIconType;
export const BatteryEmpty16: CarbonIconType;
export const BatteryEmpty20: CarbonIconType;
export const BatteryEmpty24: CarbonIconType;
export const BatteryEmpty32: CarbonIconType;
export const BatteryFull16: CarbonIconType;
export const BatteryFull20: CarbonIconType;
export const BatteryFull24: CarbonIconType;
export const BatteryFull32: CarbonIconType;
export const BatteryHalf16: CarbonIconType;
export const BatteryHalf20: CarbonIconType;
export const BatteryHalf24: CarbonIconType;
export const BatteryHalf32: CarbonIconType;
export const BatteryLow16: CarbonIconType;
export const BatteryLow20: CarbonIconType;
export const BatteryLow24: CarbonIconType;
export const BatteryLow32: CarbonIconType;
export const BatteryQuarter16: CarbonIconType;
export const BatteryQuarter20: CarbonIconType;
export const BatteryQuarter24: CarbonIconType;
export const BatteryQuarter32: CarbonIconType;
export const Bee16: CarbonIconType;
export const Bee20: CarbonIconType;
export const Bee24: CarbonIconType;
export const Bee32: CarbonIconType;
export const Bicycle16: CarbonIconType;
export const Bicycle20: CarbonIconType;
export const Bicycle24: CarbonIconType;
export const Bicycle32: CarbonIconType;
export const Binoculars16: CarbonIconType;
export const Binoculars20: CarbonIconType;
export const Binoculars24: CarbonIconType;
export const Binoculars32: CarbonIconType;
export const Blockchain16: CarbonIconType;
export const Blockchain20: CarbonIconType;
export const Blockchain24: CarbonIconType;
export const Blockchain32: CarbonIconType;
export const Blog16: CarbonIconType;
export const Blog20: CarbonIconType;
export const Blog24: CarbonIconType;
export const Blog32: CarbonIconType;
export const Bluetooth16: CarbonIconType;
export const Bluetooth20: CarbonIconType;
export const Bluetooth24: CarbonIconType;
export const Bluetooth32: CarbonIconType;
export const BluetoothOff16: CarbonIconType;
export const BluetoothOff20: CarbonIconType;
export const BluetoothOff24: CarbonIconType;
export const BluetoothOff32: CarbonIconType;
export const Bookmark16: CarbonIconType;
export const Bookmark20: CarbonIconType;
export const Bookmark24: CarbonIconType;
export const Bookmark32: CarbonIconType;
export const Bot16: CarbonIconType;
export const Bot20: CarbonIconType;
export const Bot24: CarbonIconType;
export const Bot32: CarbonIconType;
export const Box16: CarbonIconType;
export const Box20: CarbonIconType;
export const Box24: CarbonIconType;
export const Box32: CarbonIconType;
export const BoxPlot16: CarbonIconType;
export const BoxPlot20: CarbonIconType;
export const BoxPlot24: CarbonIconType;
export const BoxPlot32: CarbonIconType;
export const Branch16: CarbonIconType;
export const Branch20: CarbonIconType;
export const Branch24: CarbonIconType;
export const Branch32: CarbonIconType;
export const BrightnessContrast16: CarbonIconType;
export const BrightnessContrast20: CarbonIconType;
export const BrightnessContrast24: CarbonIconType;
export const BrightnessContrast32: CarbonIconType;
export const Building16: CarbonIconType;
export const Building20: CarbonIconType;
export const Building24: CarbonIconType;
export const Building32: CarbonIconType;
export const BuildingInsights_116: CarbonIconType;
export const BuildingInsights_120: CarbonIconType;
export const BuildingInsights_124: CarbonIconType;
export const BuildingInsights_132: CarbonIconType;
export const BuildingInsights_216: CarbonIconType;
export const BuildingInsights_220: CarbonIconType;
export const BuildingInsights_224: CarbonIconType;
export const BuildingInsights_232: CarbonIconType;
export const BuildingInsights_316: CarbonIconType;
export const BuildingInsights_320: CarbonIconType;
export const BuildingInsights_324: CarbonIconType;
export const BuildingInsights_332: CarbonIconType;
export const Bullhorn16: CarbonIconType;
export const Bullhorn20: CarbonIconType;
export const Bullhorn24: CarbonIconType;
export const Bullhorn32: CarbonIconType;
export const Bus16: CarbonIconType;
export const Bus20: CarbonIconType;
export const Bus24: CarbonIconType;
export const Bus32: CarbonIconType;
export const Cad16: CarbonIconType;
export const Cad20: CarbonIconType;
export const Cad24: CarbonIconType;
export const Cad32: CarbonIconType;
export const Cafe16: CarbonIconType;
export const Cafe20: CarbonIconType;
export const Cafe24: CarbonIconType;
export const Cafe32: CarbonIconType;
export const Calculator16: CarbonIconType;
export const Calculator20: CarbonIconType;
export const Calculator24: CarbonIconType;
export const Calculator32: CarbonIconType;
export const CalculatorCheck16: CarbonIconType;
export const CalculatorCheck20: CarbonIconType;
export const CalculatorCheck24: CarbonIconType;
export const CalculatorCheck32: CarbonIconType;
export const Calendar16: CarbonIconType;
export const Calendar20: CarbonIconType;
export const Calendar24: CarbonIconType;
export const Calendar32: CarbonIconType;
export const CalendarSettings16: CarbonIconType;
export const CalendarSettings20: CarbonIconType;
export const CalendarSettings24: CarbonIconType;
export const CalendarSettings32: CarbonIconType;
export const Calibrate16: CarbonIconType;
export const Calibrate20: CarbonIconType;
export const Calibrate24: CarbonIconType;
export const Calibrate32: CarbonIconType;
export const Camera16: CarbonIconType;
export const Camera20: CarbonIconType;
export const Camera24: CarbonIconType;
export const Camera32: CarbonIconType;
export const CameraAction16: CarbonIconType;
export const CameraAction20: CarbonIconType;
export const CameraAction24: CarbonIconType;
export const CameraAction32: CarbonIconType;
export const Campsite16: CarbonIconType;
export const Campsite20: CarbonIconType;
export const Campsite24: CarbonIconType;
export const Campsite32: CarbonIconType;
export const Car16: CarbonIconType;
export const Car20: CarbonIconType;
export const Car24: CarbonIconType;
export const Car32: CarbonIconType;
export const CarFront16: CarbonIconType;
export const CarFront20: CarbonIconType;
export const CarFront24: CarbonIconType;
export const CarFront32: CarbonIconType;
export const Carbon16: CarbonIconType;
export const Carbon20: CarbonIconType;
export const Carbon24: CarbonIconType;
export const Carbon32: CarbonIconType;
export const CaretDown16: CarbonIconType;
export const CaretDown20: CarbonIconType;
export const CaretDown24: CarbonIconType;
export const CaretDown32: CarbonIconType;
export const CaretDownGlyph: CarbonIconType;
export const CaretLeft16: CarbonIconType;
export const CaretLeft20: CarbonIconType;
export const CaretLeft24: CarbonIconType;
export const CaretLeft32: CarbonIconType;
export const CaretLeftGlyph: CarbonIconType;
export const CaretRight16: CarbonIconType;
export const CaretRight20: CarbonIconType;
export const CaretRight24: CarbonIconType;
export const CaretRight32: CarbonIconType;
export const CaretRightGlyph: CarbonIconType;
export const CaretSort16: CarbonIconType;
export const CaretSort20: CarbonIconType;
export const CaretSort24: CarbonIconType;
export const CaretSort32: CarbonIconType;
export const CaretSortDown16: CarbonIconType;
export const CaretSortDown20: CarbonIconType;
export const CaretSortDown24: CarbonIconType;
export const CaretSortDown32: CarbonIconType;
export const CaretSortUp16: CarbonIconType;
export const CaretSortUp20: CarbonIconType;
export const CaretSortUp24: CarbonIconType;
export const CaretSortUp32: CarbonIconType;
export const CaretUp16: CarbonIconType;
export const CaretUp20: CarbonIconType;
export const CaretUp24: CarbonIconType;
export const CaretUp32: CarbonIconType;
export const CaretUpGlyph: CarbonIconType;
export const CarouselHorizontal16: CarbonIconType;
export const CarouselHorizontal20: CarbonIconType;
export const CarouselHorizontal24: CarbonIconType;
export const CarouselHorizontal32: CarbonIconType;
export const CarouselVertical16: CarbonIconType;
export const CarouselVertical20: CarbonIconType;
export const CarouselVertical24: CarbonIconType;
export const CarouselVertical32: CarbonIconType;
export const Catalog16: CarbonIconType;
export const Catalog20: CarbonIconType;
export const Catalog24: CarbonIconType;
export const Catalog32: CarbonIconType;
export const Categories16: CarbonIconType;
export const Categories20: CarbonIconType;
export const Categories24: CarbonIconType;
export const Categories32: CarbonIconType;
export const Category16: CarbonIconType;
export const Category20: CarbonIconType;
export const Category24: CarbonIconType;
export const Category32: CarbonIconType;
export const CategoryAdd16: CarbonIconType;
export const CategoryAdd20: CarbonIconType;
export const CategoryAdd24: CarbonIconType;
export const CategoryAdd32: CarbonIconType;
export const CategoryAnd16: CarbonIconType;
export const CategoryAnd20: CarbonIconType;
export const CategoryAnd24: CarbonIconType;
export const CategoryAnd32: CarbonIconType;
export const CategoryNew16: CarbonIconType;
export const CategoryNew20: CarbonIconType;
export const CategoryNew24: CarbonIconType;
export const CategoryNew32: CarbonIconType;
export const CategoryNewEach16: CarbonIconType;
export const CategoryNewEach20: CarbonIconType;
export const CategoryNewEach24: CarbonIconType;
export const CategoryNewEach32: CarbonIconType;
export const Cda16: CarbonIconType;
export const Cda20: CarbonIconType;
export const Cda24: CarbonIconType;
export const Cda32: CarbonIconType;
export const CenterCircle16: CarbonIconType;
export const CenterCircle20: CarbonIconType;
export const CenterCircle24: CarbonIconType;
export const CenterCircle32: CarbonIconType;
export const CenterSquare16: CarbonIconType;
export const CenterSquare20: CarbonIconType;
export const CenterSquare24: CarbonIconType;
export const CenterSquare32: CarbonIconType;
export const Certificate16: CarbonIconType;
export const Certificate20: CarbonIconType;
export const Certificate24: CarbonIconType;
export const Certificate32: CarbonIconType;
export const CertificateCheck16: CarbonIconType;
export const CertificateCheck20: CarbonIconType;
export const CertificateCheck24: CarbonIconType;
export const CertificateCheck32: CarbonIconType;
export const ChangeCatalog16: CarbonIconType;
export const ChangeCatalog20: CarbonIconType;
export const ChangeCatalog24: CarbonIconType;
export const ChangeCatalog32: CarbonIconType;
export const CharacterPatterns16: CarbonIconType;
export const CharacterPatterns20: CarbonIconType;
export const CharacterPatterns24: CarbonIconType;
export const CharacterPatterns32: CarbonIconType;
export const ChargingStation16: CarbonIconType;
export const ChargingStation20: CarbonIconType;
export const ChargingStation24: CarbonIconType;
export const ChargingStation32: CarbonIconType;
export const ChargingStationFilled16: CarbonIconType;
export const ChargingStationFilled20: CarbonIconType;
export const ChargingStationFilled24: CarbonIconType;
export const ChargingStationFilled32: CarbonIconType;
export const ChartArea16: CarbonIconType;
export const ChartArea20: CarbonIconType;
export const ChartArea24: CarbonIconType;
export const ChartArea32: CarbonIconType;
export const ChartBar16: CarbonIconType;
export const ChartBar20: CarbonIconType;
export const ChartBar24: CarbonIconType;
export const ChartBar32: CarbonIconType;
export const ChartBubble16: CarbonIconType;
export const ChartBubble20: CarbonIconType;
export const ChartBubble24: CarbonIconType;
export const ChartBubble32: CarbonIconType;
export const ChartCandlestick16: CarbonIconType;
export const ChartCandlestick20: CarbonIconType;
export const ChartCandlestick24: CarbonIconType;
export const ChartCandlestick32: CarbonIconType;
export const ChartClusterBar16: CarbonIconType;
export const ChartClusterBar20: CarbonIconType;
export const ChartClusterBar24: CarbonIconType;
export const ChartClusterBar32: CarbonIconType;
export const ChartCustom16: CarbonIconType;
export const ChartCustom20: CarbonIconType;
export const ChartCustom24: CarbonIconType;
export const ChartCustom32: CarbonIconType;
export const ChartErrorBar16: CarbonIconType;
export const ChartErrorBar20: CarbonIconType;
export const ChartErrorBar24: CarbonIconType;
export const ChartErrorBar32: CarbonIconType;
export const ChartErrorBarAlt16: CarbonIconType;
export const ChartErrorBarAlt20: CarbonIconType;
export const ChartErrorBarAlt24: CarbonIconType;
export const ChartErrorBarAlt32: CarbonIconType;
export const ChartEvaluation16: CarbonIconType;
export const ChartEvaluation20: CarbonIconType;
export const ChartEvaluation24: CarbonIconType;
export const ChartEvaluation32: CarbonIconType;
export const ChartHighLow16: CarbonIconType;
export const ChartHighLow20: CarbonIconType;
export const ChartHighLow24: CarbonIconType;
export const ChartHighLow32: CarbonIconType;
export const ChartHistogram16: CarbonIconType;
export const ChartHistogram20: CarbonIconType;
export const ChartHistogram24: CarbonIconType;
export const ChartHistogram32: CarbonIconType;
export const ChartLine16: CarbonIconType;
export const ChartLine20: CarbonIconType;
export const ChartLine24: CarbonIconType;
export const ChartLine32: CarbonIconType;
export const ChartLineData16: CarbonIconType;
export const ChartLineData20: CarbonIconType;
export const ChartLineData24: CarbonIconType;
export const ChartLineData32: CarbonIconType;
export const ChartMultiLine16: CarbonIconType;
export const ChartMultiLine20: CarbonIconType;
export const ChartMultiLine24: CarbonIconType;
export const ChartMultiLine32: CarbonIconType;
export const ChartNetwork16: CarbonIconType;
export const ChartNetwork20: CarbonIconType;
export const ChartNetwork24: CarbonIconType;
export const ChartNetwork32: CarbonIconType;
export const ChartParallel16: CarbonIconType;
export const ChartParallel20: CarbonIconType;
export const ChartParallel24: CarbonIconType;
export const ChartParallel32: CarbonIconType;
export const ChartPie16: CarbonIconType;
export const ChartPie20: CarbonIconType;
export const ChartPie24: CarbonIconType;
export const ChartPie32: CarbonIconType;
export const ChartPopulation16: CarbonIconType;
export const ChartPopulation20: CarbonIconType;
export const ChartPopulation24: CarbonIconType;
export const ChartPopulation32: CarbonIconType;
export const ChartRadar16: CarbonIconType;
export const ChartRadar20: CarbonIconType;
export const ChartRadar24: CarbonIconType;
export const ChartRadar32: CarbonIconType;
export const ChartRelationship16: CarbonIconType;
export const ChartRelationship20: CarbonIconType;
export const ChartRelationship24: CarbonIconType;
export const ChartRelationship32: CarbonIconType;
export const ChartRing16: CarbonIconType;
export const ChartRing20: CarbonIconType;
export const ChartRing24: CarbonIconType;
export const ChartRing32: CarbonIconType;
export const ChartRiver16: CarbonIconType;
export const ChartRiver20: CarbonIconType;
export const ChartRiver24: CarbonIconType;
export const ChartRiver32: CarbonIconType;
export const ChartRose16: CarbonIconType;
export const ChartRose20: CarbonIconType;
export const ChartRose24: CarbonIconType;
export const ChartRose32: CarbonIconType;
export const ChartScatter16: CarbonIconType;
export const ChartScatter20: CarbonIconType;
export const ChartScatter24: CarbonIconType;
export const ChartScatter32: CarbonIconType;
export const ChartStacked16: CarbonIconType;
export const ChartStacked20: CarbonIconType;
export const ChartStacked24: CarbonIconType;
export const ChartStacked32: CarbonIconType;
export const ChartTSne16: CarbonIconType;
export const ChartTSne20: CarbonIconType;
export const ChartTSne24: CarbonIconType;
export const ChartTSne32: CarbonIconType;
export const ChartTreemap16: CarbonIconType;
export const ChartTreemap20: CarbonIconType;
export const ChartTreemap24: CarbonIconType;
export const ChartTreemap32: CarbonIconType;
export const ChartVennDiagram16: CarbonIconType;
export const ChartVennDiagram20: CarbonIconType;
export const ChartVennDiagram24: CarbonIconType;
export const ChartVennDiagram32: CarbonIconType;
export const Chart_3D16: CarbonIconType;
export const Chart_3D20: CarbonIconType;
export const Chart_3D24: CarbonIconType;
export const Chart_3D32: CarbonIconType;
export const Chat16: CarbonIconType;
export const Chat20: CarbonIconType;
export const Chat24: CarbonIconType;
export const Chat32: CarbonIconType;
export const ChatBot16: CarbonIconType;
export const ChatBot20: CarbonIconType;
export const ChatBot24: CarbonIconType;
export const ChatBot32: CarbonIconType;
export const Checkbox16: CarbonIconType;
export const Checkbox20: CarbonIconType;
export const Checkbox24: CarbonIconType;
export const Checkbox32: CarbonIconType;
export const CheckboxChecked16: CarbonIconType;
export const CheckboxChecked20: CarbonIconType;
export const CheckboxChecked24: CarbonIconType;
export const CheckboxChecked32: CarbonIconType;
export const CheckboxCheckedFilled16: CarbonIconType;
export const CheckboxCheckedFilled20: CarbonIconType;
export const CheckboxCheckedFilled24: CarbonIconType;
export const CheckboxCheckedFilled32: CarbonIconType;
export const CheckboxIndeterminate16: CarbonIconType;
export const CheckboxIndeterminate20: CarbonIconType;
export const CheckboxIndeterminate24: CarbonIconType;
export const CheckboxIndeterminate32: CarbonIconType;
export const CheckboxIndeterminateFilled16: CarbonIconType;
export const CheckboxIndeterminateFilled20: CarbonIconType;
export const CheckboxIndeterminateFilled24: CarbonIconType;
export const CheckboxIndeterminateFilled32: CarbonIconType;
export const CheckboxUndeterminate16: CarbonIconType;
export const CheckboxUndeterminate20: CarbonIconType;
export const CheckboxUndeterminate24: CarbonIconType;
export const CheckboxUndeterminate32: CarbonIconType;
export const CheckboxUndeterminateFilled16: CarbonIconType;
export const CheckboxUndeterminateFilled20: CarbonIconType;
export const CheckboxUndeterminateFilled24: CarbonIconType;
export const CheckboxUndeterminateFilled32: CarbonIconType;
export const Checkmark16: CarbonIconType;
export const Checkmark20: CarbonIconType;
export const Checkmark24: CarbonIconType;
export const Checkmark32: CarbonIconType;
export const CheckmarkFilled16: CarbonIconType;
export const CheckmarkFilled20: CarbonIconType;
export const CheckmarkFilled24: CarbonIconType;
export const CheckmarkFilled32: CarbonIconType;
export const CheckmarkOutline16: CarbonIconType;
export const CheckmarkOutline20: CarbonIconType;
export const CheckmarkOutline24: CarbonIconType;
export const CheckmarkOutline32: CarbonIconType;
export const Chemistry16: CarbonIconType;
export const Chemistry20: CarbonIconType;
export const Chemistry24: CarbonIconType;
export const Chemistry32: CarbonIconType;
export const ChevronDown16: CarbonIconType;
export const ChevronDown20: CarbonIconType;
export const ChevronDown24: CarbonIconType;
export const ChevronDown32: CarbonIconType;
export const ChevronDownGlyph: CarbonIconType;
export const ChevronLeft16: CarbonIconType;
export const ChevronLeft20: CarbonIconType;
export const ChevronLeft24: CarbonIconType;
export const ChevronLeft32: CarbonIconType;
export const ChevronLeftGlyph: CarbonIconType;
export const ChevronMini16: CarbonIconType;
export const ChevronMini20: CarbonIconType;
export const ChevronMini24: CarbonIconType;
export const ChevronMini32: CarbonIconType;
export const ChevronRight16: CarbonIconType;
export const ChevronRight20: CarbonIconType;
export const ChevronRight24: CarbonIconType;
export const ChevronRight32: CarbonIconType;
export const ChevronRightGlyph: CarbonIconType;
export const ChevronSort16: CarbonIconType;
export const ChevronSort20: CarbonIconType;
export const ChevronSort24: CarbonIconType;
export const ChevronSort32: CarbonIconType;
export const ChevronSortDown16: CarbonIconType;
export const ChevronSortDown20: CarbonIconType;
export const ChevronSortDown24: CarbonIconType;
export const ChevronSortDown32: CarbonIconType;
export const ChevronSortUp16: CarbonIconType;
export const ChevronSortUp20: CarbonIconType;
export const ChevronSortUp24: CarbonIconType;
export const ChevronSortUp32: CarbonIconType;
export const ChevronUp16: CarbonIconType;
export const ChevronUp20: CarbonIconType;
export const ChevronUp24: CarbonIconType;
export const ChevronUp32: CarbonIconType;
export const ChevronUpGlyph: CarbonIconType;
export const Chip16: CarbonIconType;
export const Chip20: CarbonIconType;
export const Chip24: CarbonIconType;
export const Chip32: CarbonIconType;
export const Choices16: CarbonIconType;
export const Choices20: CarbonIconType;
export const Choices24: CarbonIconType;
export const Choices32: CarbonIconType;
export const CircleDash16: CarbonIconType;
export const CircleDash20: CarbonIconType;
export const CircleDash24: CarbonIconType;
export const CircleDash32: CarbonIconType;
export const CircleFilled16: CarbonIconType;
export const CircleFilled20: CarbonIconType;
export const CircleFilled24: CarbonIconType;
export const CircleFilled32: CarbonIconType;
export const CirclePacking16: CarbonIconType;
export const CirclePacking20: CarbonIconType;
export const CirclePacking24: CarbonIconType;
export const CirclePacking32: CarbonIconType;
export const Classification16: CarbonIconType;
export const Classification20: CarbonIconType;
export const Classification24: CarbonIconType;
export const Classification32: CarbonIconType;
export const ClassifierLanguage16: CarbonIconType;
export const ClassifierLanguage20: CarbonIconType;
export const ClassifierLanguage24: CarbonIconType;
export const ClassifierLanguage32: CarbonIconType;
export const Clean16: CarbonIconType;
export const Clean20: CarbonIconType;
export const Clean24: CarbonIconType;
export const Clean32: CarbonIconType;
export const Close16: CarbonIconType;
export const Close20: CarbonIconType;
export const Close24: CarbonIconType;
export const Close32: CarbonIconType;
export const CloseFilled16: CarbonIconType;
export const CloseFilled20: CarbonIconType;
export const CloseFilled24: CarbonIconType;
export const CloseFilled32: CarbonIconType;
export const CloseOutline16: CarbonIconType;
export const CloseOutline20: CarbonIconType;
export const CloseOutline24: CarbonIconType;
export const CloseOutline32: CarbonIconType;
export const ClosedCaption16: CarbonIconType;
export const ClosedCaption20: CarbonIconType;
export const ClosedCaption24: CarbonIconType;
export const ClosedCaption32: CarbonIconType;
export const ClosedCaptionAlt16: CarbonIconType;
export const ClosedCaptionAlt20: CarbonIconType;
export const ClosedCaptionAlt24: CarbonIconType;
export const ClosedCaptionAlt32: CarbonIconType;
export const ClosedCaptionFilled16: CarbonIconType;
export const ClosedCaptionFilled20: CarbonIconType;
export const ClosedCaptionFilled24: CarbonIconType;
export const ClosedCaptionFilled32: CarbonIconType;
export const Cloud16: CarbonIconType;
export const Cloud20: CarbonIconType;
export const Cloud24: CarbonIconType;
export const Cloud32: CarbonIconType;
export const CloudApp16: CarbonIconType;
export const CloudApp20: CarbonIconType;
export const CloudApp24: CarbonIconType;
export const CloudApp32: CarbonIconType;
export const CloudDownload16: CarbonIconType;
export const CloudDownload20: CarbonIconType;
export const CloudDownload24: CarbonIconType;
export const CloudDownload32: CarbonIconType;
export const CloudFoundry_116: CarbonIconType;
export const CloudFoundry_120: CarbonIconType;
export const CloudFoundry_124: CarbonIconType;
export const CloudFoundry_132: CarbonIconType;
export const CloudFoundry_216: CarbonIconType;
export const CloudFoundry_220: CarbonIconType;
export const CloudFoundry_224: CarbonIconType;
export const CloudFoundry_232: CarbonIconType;
export const CloudLightning16: CarbonIconType;
export const CloudLightning20: CarbonIconType;
export const CloudLightning24: CarbonIconType;
export const CloudLightning32: CarbonIconType;
export const CloudRain16: CarbonIconType;
export const CloudRain20: CarbonIconType;
export const CloudRain24: CarbonIconType;
export const CloudRain32: CarbonIconType;
export const CloudSnow16: CarbonIconType;
export const CloudSnow20: CarbonIconType;
export const CloudSnow24: CarbonIconType;
export const CloudSnow32: CarbonIconType;
export const CloudUpload16: CarbonIconType;
export const CloudUpload20: CarbonIconType;
export const CloudUpload24: CarbonIconType;
export const CloudUpload32: CarbonIconType;
export const Cloudy16: CarbonIconType;
export const Cloudy20: CarbonIconType;
export const Cloudy24: CarbonIconType;
export const Cloudy32: CarbonIconType;
export const Code16: CarbonIconType;
export const Code20: CarbonIconType;
export const Code24: CarbonIconType;
export const Code32: CarbonIconType;
export const Cognitive16: CarbonIconType;
export const Cognitive20: CarbonIconType;
export const Cognitive24: CarbonIconType;
export const Cognitive32: CarbonIconType;
export const Collaborate16: CarbonIconType;
export const Collaborate20: CarbonIconType;
export const Collaborate24: CarbonIconType;
export const Collaborate32: CarbonIconType;
export const CollapseAll16: CarbonIconType;
export const CollapseAll20: CarbonIconType;
export const CollapseAll24: CarbonIconType;
export const CollapseAll32: CarbonIconType;
export const CollapseCategories16: CarbonIconType;
export const CollapseCategories20: CarbonIconType;
export const CollapseCategories24: CarbonIconType;
export const CollapseCategories32: CarbonIconType;
export const ColorPalette16: CarbonIconType;
export const ColorPalette20: CarbonIconType;
export const ColorPalette24: CarbonIconType;
export const ColorPalette32: CarbonIconType;
export const ColorSwitch16: CarbonIconType;
export const ColorSwitch20: CarbonIconType;
export const ColorSwitch24: CarbonIconType;
export const ColorSwitch32: CarbonIconType;
export const Column16: CarbonIconType;
export const Column20: CarbonIconType;
export const Column24: CarbonIconType;
export const Column32: CarbonIconType;
export const Compare16: CarbonIconType;
export const Compare20: CarbonIconType;
export const Compare24: CarbonIconType;
export const Compare32: CarbonIconType;
export const Compass16: CarbonIconType;
export const Compass20: CarbonIconType;
export const Compass24: CarbonIconType;
export const Compass32: CarbonIconType;
export const Concept16: CarbonIconType;
export const Concept20: CarbonIconType;
export const Concept24: CarbonIconType;
export const Concept32: CarbonIconType;
export const Connect16: CarbonIconType;
export const Connect20: CarbonIconType;
export const Connect24: CarbonIconType;
export const Connect32: CarbonIconType;
export const ConnectionSignal16: CarbonIconType;
export const ConnectionSignal20: CarbonIconType;
export const ConnectionSignal24: CarbonIconType;
export const ConnectionSignal32: CarbonIconType;
export const ContainerSoftware16: CarbonIconType;
export const ContainerSoftware20: CarbonIconType;
export const ContainerSoftware24: CarbonIconType;
export const ContainerSoftware32: CarbonIconType;
export const Contrast16: CarbonIconType;
export const Contrast20: CarbonIconType;
export const Contrast24: CarbonIconType;
export const Contrast32: CarbonIconType;
export const Copy16: CarbonIconType;
export const Copy20: CarbonIconType;
export const Copy24: CarbonIconType;
export const Copy32: CarbonIconType;
export const CopyFile16: CarbonIconType;
export const CopyFile20: CarbonIconType;
export const CopyFile24: CarbonIconType;
export const CopyFile32: CarbonIconType;
export const Corn16: CarbonIconType;
export const Corn20: CarbonIconType;
export const Corn24: CarbonIconType;
export const Corn32: CarbonIconType;
export const Corner16: CarbonIconType;
export const Corner20: CarbonIconType;
export const Corner24: CarbonIconType;
export const Corner32: CarbonIconType;
export const Course16: CarbonIconType;
export const Course20: CarbonIconType;
export const Course24: CarbonIconType;
export const Course32: CarbonIconType;
export const Covariate16: CarbonIconType;
export const Covariate20: CarbonIconType;
export const Covariate24: CarbonIconType;
export const Covariate32: CarbonIconType;
export const Credentials16: CarbonIconType;
export const Credentials20: CarbonIconType;
export const Credentials24: CarbonIconType;
export const Credentials32: CarbonIconType;
export const Crop16: CarbonIconType;
export const Crop20: CarbonIconType;
export const Crop24: CarbonIconType;
export const Crop32: CarbonIconType;
export const Csv16: CarbonIconType;
export const Csv20: CarbonIconType;
export const Csv24: CarbonIconType;
export const Csv32: CarbonIconType;
export const Cursor_116: CarbonIconType;
export const Cursor_120: CarbonIconType;
export const Cursor_124: CarbonIconType;
export const Cursor_132: CarbonIconType;
export const Cursor_216: CarbonIconType;
export const Cursor_220: CarbonIconType;
export const Cursor_224: CarbonIconType;
export const Cursor_232: CarbonIconType;
export const Cut16: CarbonIconType;
export const Cut20: CarbonIconType;
export const Cut24: CarbonIconType;
export const Cut32: CarbonIconType;
export const Cyclist16: CarbonIconType;
export const Cyclist20: CarbonIconType;
export const Cyclist24: CarbonIconType;
export const Cyclist32: CarbonIconType;
export const Dashboard16: CarbonIconType;
export const Dashboard20: CarbonIconType;
export const Dashboard24: CarbonIconType;
export const Dashboard32: CarbonIconType;
export const DataBase16: CarbonIconType;
export const DataBase20: CarbonIconType;
export const DataBase24: CarbonIconType;
export const DataBase32: CarbonIconType;
export const DataBaseAlt16: CarbonIconType;
export const DataBaseAlt20: CarbonIconType;
export const DataBaseAlt24: CarbonIconType;
export const DataBaseAlt32: CarbonIconType;
export const DataCheck16: CarbonIconType;
export const DataCheck20: CarbonIconType;
export const DataCheck24: CarbonIconType;
export const DataCheck32: CarbonIconType;
export const DataClass16: CarbonIconType;
export const DataClass20: CarbonIconType;
export const DataClass24: CarbonIconType;
export const DataClass32: CarbonIconType;
export const DataConnected16: CarbonIconType;
export const DataConnected20: CarbonIconType;
export const DataConnected24: CarbonIconType;
export const DataConnected32: CarbonIconType;
export const DataError16: CarbonIconType;
export const DataError20: CarbonIconType;
export const DataError24: CarbonIconType;
export const DataError32: CarbonIconType;
export const DataReference16: CarbonIconType;
export const DataReference20: CarbonIconType;
export const DataReference24: CarbonIconType;
export const DataReference32: CarbonIconType;
export const DataRefinery16: CarbonIconType;
export const DataRefinery20: CarbonIconType;
export const DataRefinery24: CarbonIconType;
export const DataRefinery32: CarbonIconType;
export const DataSet16: CarbonIconType;
export const DataSet20: CarbonIconType;
export const DataSet24: CarbonIconType;
export const DataSet32: CarbonIconType;
export const DataShare16: CarbonIconType;
export const DataShare20: CarbonIconType;
export const DataShare24: CarbonIconType;
export const DataShare32: CarbonIconType;
export const DataStructured16: CarbonIconType;
export const DataStructured20: CarbonIconType;
export const DataStructured24: CarbonIconType;
export const DataStructured32: CarbonIconType;
export const DataTable16: CarbonIconType;
export const DataTable20: CarbonIconType;
export const DataTable24: CarbonIconType;
export const DataTable32: CarbonIconType;
export const DataUnstructured16: CarbonIconType;
export const DataUnstructured20: CarbonIconType;
export const DataUnstructured24: CarbonIconType;
export const DataUnstructured32: CarbonIconType;
export const DataVis_116: CarbonIconType;
export const DataVis_120: CarbonIconType;
export const DataVis_124: CarbonIconType;
export const DataVis_132: CarbonIconType;
export const DataVis_216: CarbonIconType;
export const DataVis_220: CarbonIconType;
export const DataVis_224: CarbonIconType;
export const DataVis_232: CarbonIconType;
export const DataVis_316: CarbonIconType;
export const DataVis_320: CarbonIconType;
export const DataVis_324: CarbonIconType;
export const DataVis_332: CarbonIconType;
export const DataVis_416: CarbonIconType;
export const DataVis_420: CarbonIconType;
export const DataVis_424: CarbonIconType;
export const DataVis_432: CarbonIconType;
export const Data_116: CarbonIconType;
export const Data_120: CarbonIconType;
export const Data_124: CarbonIconType;
export const Data_132: CarbonIconType;
export const Data_216: CarbonIconType;
export const Data_220: CarbonIconType;
export const Data_224: CarbonIconType;
export const Data_232: CarbonIconType;
export const Datastore16: CarbonIconType;
export const Datastore20: CarbonIconType;
export const Datastore24: CarbonIconType;
export const Datastore32: CarbonIconType;
export const Debug16: CarbonIconType;
export const Debug20: CarbonIconType;
export const Debug24: CarbonIconType;
export const Debug32: CarbonIconType;
export const Delete16: CarbonIconType;
export const Delete20: CarbonIconType;
export const Delete24: CarbonIconType;
export const Delete32: CarbonIconType;
export const DeliveryTruck16: CarbonIconType;
export const DeliveryTruck20: CarbonIconType;
export const DeliveryTruck24: CarbonIconType;
export const DeliveryTruck32: CarbonIconType;
export const Departure16: CarbonIconType;
export const Departure20: CarbonIconType;
export const Departure24: CarbonIconType;
export const Departure32: CarbonIconType;
export const Deploy16: CarbonIconType;
export const Deploy20: CarbonIconType;
export const Deploy24: CarbonIconType;
export const Deploy32: CarbonIconType;
export const DeployRules16: CarbonIconType;
export const DeployRules20: CarbonIconType;
export const DeployRules24: CarbonIconType;
export const DeployRules32: CarbonIconType;
export const Development16: CarbonIconType;
export const Development20: CarbonIconType;
export const Development24: CarbonIconType;
export const Development32: CarbonIconType;
export const Devices16: CarbonIconType;
export const Devices20: CarbonIconType;
export const Devices24: CarbonIconType;
export const Devices32: CarbonIconType;
export const DewPoint16: CarbonIconType;
export const DewPoint20: CarbonIconType;
export const DewPoint24: CarbonIconType;
export const DewPoint32: CarbonIconType;
export const DewPointFilled16: CarbonIconType;
export const DewPointFilled20: CarbonIconType;
export const DewPointFilled24: CarbonIconType;
export const DewPointFilled32: CarbonIconType;
export const Diagram16: CarbonIconType;
export const Diagram20: CarbonIconType;
export const Diagram24: CarbonIconType;
export const Diagram32: CarbonIconType;
export const DirectionBearRight_0116: CarbonIconType;
export const DirectionBearRight_0120: CarbonIconType;
export const DirectionBearRight_0124: CarbonIconType;
export const DirectionBearRight_0132: CarbonIconType;
export const DirectionBearRight_01Filled16: CarbonIconType;
export const DirectionBearRight_01Filled20: CarbonIconType;
export const DirectionBearRight_01Filled24: CarbonIconType;
export const DirectionBearRight_01Filled32: CarbonIconType;
export const DirectionBearRight_0216: CarbonIconType;
export const DirectionBearRight_0220: CarbonIconType;
export const DirectionBearRight_0224: CarbonIconType;
export const DirectionBearRight_0232: CarbonIconType;
export const DirectionBearRight_02Filled16: CarbonIconType;
export const DirectionBearRight_02Filled20: CarbonIconType;
export const DirectionBearRight_02Filled24: CarbonIconType;
export const DirectionBearRight_02Filled32: CarbonIconType;
export const DirectionCurve16: CarbonIconType;
export const DirectionCurve20: CarbonIconType;
export const DirectionCurve24: CarbonIconType;
export const DirectionCurve32: CarbonIconType;
export const DirectionCurveFilled16: CarbonIconType;
export const DirectionCurveFilled20: CarbonIconType;
export const DirectionCurveFilled24: CarbonIconType;
export const DirectionCurveFilled32: CarbonIconType;
export const DirectionMerge16: CarbonIconType;
export const DirectionMerge20: CarbonIconType;
export const DirectionMerge24: CarbonIconType;
export const DirectionMerge32: CarbonIconType;
export const DirectionMergeFilled16: CarbonIconType;
export const DirectionMergeFilled20: CarbonIconType;
export const DirectionMergeFilled24: CarbonIconType;
export const DirectionMergeFilled32: CarbonIconType;
export const DirectionRight_0116: CarbonIconType;
export const DirectionRight_0120: CarbonIconType;
export const DirectionRight_0124: CarbonIconType;
export const DirectionRight_0132: CarbonIconType;
export const DirectionRight_01Filled16: CarbonIconType;
export const DirectionRight_01Filled20: CarbonIconType;
export const DirectionRight_01Filled24: CarbonIconType;
export const DirectionRight_01Filled32: CarbonIconType;
export const DirectionRight_0216: CarbonIconType;
export const DirectionRight_0220: CarbonIconType;
export const DirectionRight_0224: CarbonIconType;
export const DirectionRight_0232: CarbonIconType;
export const DirectionRight_02Filled16: CarbonIconType;
export const DirectionRight_02Filled20: CarbonIconType;
export const DirectionRight_02Filled24: CarbonIconType;
export const DirectionRight_02Filled32: CarbonIconType;
export const DirectionRotaryFirstRight16: CarbonIconType;
export const DirectionRotaryFirstRight20: CarbonIconType;
export const DirectionRotaryFirstRight24: CarbonIconType;
export const DirectionRotaryFirstRight32: CarbonIconType;
export const DirectionRotaryFirstRightFilled16: CarbonIconType;
export const DirectionRotaryFirstRightFilled20: CarbonIconType;
export const DirectionRotaryFirstRightFilled24: CarbonIconType;
export const DirectionRotaryFirstRightFilled32: CarbonIconType;
export const DirectionRotaryRight16: CarbonIconType;
export const DirectionRotaryRight20: CarbonIconType;
export const DirectionRotaryRight24: CarbonIconType;
export const DirectionRotaryRight32: CarbonIconType;
export const DirectionRotaryRightFilled16: CarbonIconType;
export const DirectionRotaryRightFilled20: CarbonIconType;
export const DirectionRotaryRightFilled24: CarbonIconType;
export const DirectionRotaryRightFilled32: CarbonIconType;
export const DirectionRotaryStraight16: CarbonIconType;
export const DirectionRotaryStraight20: CarbonIconType;
export const DirectionRotaryStraight24: CarbonIconType;
export const DirectionRotaryStraight32: CarbonIconType;
export const DirectionRotaryStraightFilled16: CarbonIconType;
export const DirectionRotaryStraightFilled20: CarbonIconType;
export const DirectionRotaryStraightFilled24: CarbonIconType;
export const DirectionRotaryStraightFilled32: CarbonIconType;
export const DirectionSharpTurn16: CarbonIconType;
export const DirectionSharpTurn20: CarbonIconType;
export const DirectionSharpTurn24: CarbonIconType;
export const DirectionSharpTurn32: CarbonIconType;
export const DirectionSharpTurnFilled16: CarbonIconType;
export const DirectionSharpTurnFilled20: CarbonIconType;
export const DirectionSharpTurnFilled24: CarbonIconType;
export const DirectionSharpTurnFilled32: CarbonIconType;
export const DirectionStraight16: CarbonIconType;
export const DirectionStraight20: CarbonIconType;
export const DirectionStraight24: CarbonIconType;
export const DirectionStraight32: CarbonIconType;
export const DirectionStraightFilled16: CarbonIconType;
export const DirectionStraightFilled20: CarbonIconType;
export const DirectionStraightFilled24: CarbonIconType;
export const DirectionStraightFilled32: CarbonIconType;
export const DirectionStraightRight16: CarbonIconType;
export const DirectionStraightRight20: CarbonIconType;
export const DirectionStraightRight24: CarbonIconType;
export const DirectionStraightRight32: CarbonIconType;
export const DirectionStraightRightFilled16: CarbonIconType;
export const DirectionStraightRightFilled20: CarbonIconType;
export const DirectionStraightRightFilled24: CarbonIconType;
export const DirectionStraightRightFilled32: CarbonIconType;
export const DirectionUTurn16: CarbonIconType;
export const DirectionUTurn20: CarbonIconType;
export const DirectionUTurn24: CarbonIconType;
export const DirectionUTurn32: CarbonIconType;
export const DirectionUTurnFilled16: CarbonIconType;
export const DirectionUTurnFilled20: CarbonIconType;
export const DirectionUTurnFilled24: CarbonIconType;
export const DirectionUTurnFilled32: CarbonIconType;
export const DistributeHorizontalCenter16: CarbonIconType;
export const DistributeHorizontalCenter20: CarbonIconType;
export const DistributeHorizontalCenter24: CarbonIconType;
export const DistributeHorizontalCenter32: CarbonIconType;
export const DistributeHorizontalLeft16: CarbonIconType;
export const DistributeHorizontalLeft20: CarbonIconType;
export const DistributeHorizontalLeft24: CarbonIconType;
export const DistributeHorizontalLeft32: CarbonIconType;
export const DistributeHorizontalRight16: CarbonIconType;
export const DistributeHorizontalRight20: CarbonIconType;
export const DistributeHorizontalRight24: CarbonIconType;
export const DistributeHorizontalRight32: CarbonIconType;
export const DistributeVerticalBottom16: CarbonIconType;
export const DistributeVerticalBottom20: CarbonIconType;
export const DistributeVerticalBottom24: CarbonIconType;
export const DistributeVerticalBottom32: CarbonIconType;
export const DistributeVerticalCenter16: CarbonIconType;
export const DistributeVerticalCenter20: CarbonIconType;
export const DistributeVerticalCenter24: CarbonIconType;
export const DistributeVerticalCenter32: CarbonIconType;
export const DistributeVerticalTop16: CarbonIconType;
export const DistributeVerticalTop20: CarbonIconType;
export const DistributeVerticalTop24: CarbonIconType;
export const DistributeVerticalTop32: CarbonIconType;
export const Doc16: CarbonIconType;
export const Doc20: CarbonIconType;
export const Doc24: CarbonIconType;
export const Doc32: CarbonIconType;
export const Document16: CarbonIconType;
export const Document20: CarbonIconType;
export const Document24: CarbonIconType;
export const Document32: CarbonIconType;
export const DocumentAdd16: CarbonIconType;
export const DocumentAdd20: CarbonIconType;
export const DocumentAdd24: CarbonIconType;
export const DocumentAdd32: CarbonIconType;
export const DocumentBlank16: CarbonIconType;
export const DocumentBlank20: CarbonIconType;
export const DocumentBlank24: CarbonIconType;
export const DocumentBlank32: CarbonIconType;
export const DocumentDownload16: CarbonIconType;
export const DocumentDownload20: CarbonIconType;
export const DocumentDownload24: CarbonIconType;
export const DocumentDownload32: CarbonIconType;
export const DocumentExport16: CarbonIconType;
export const DocumentExport20: CarbonIconType;
export const DocumentExport24: CarbonIconType;
export const DocumentExport32: CarbonIconType;
export const DocumentImport16: CarbonIconType;
export const DocumentImport20: CarbonIconType;
export const DocumentImport24: CarbonIconType;
export const DocumentImport32: CarbonIconType;
export const DocumentPdf16: CarbonIconType;
export const DocumentPdf20: CarbonIconType;
export const DocumentPdf24: CarbonIconType;
export const DocumentPdf32: CarbonIconType;
export const DocumentSentiment16: CarbonIconType;
export const DocumentSentiment20: CarbonIconType;
export const DocumentSentiment24: CarbonIconType;
export const DocumentSentiment32: CarbonIconType;
export const DocumentSubtract16: CarbonIconType;
export const DocumentSubtract20: CarbonIconType;
export const DocumentSubtract24: CarbonIconType;
export const DocumentSubtract32: CarbonIconType;
export const DocumentTasks16: CarbonIconType;
export const DocumentTasks20: CarbonIconType;
export const DocumentTasks24: CarbonIconType;
export const DocumentTasks32: CarbonIconType;
export const DocumentView16: CarbonIconType;
export const DocumentView20: CarbonIconType;
export const DocumentView24: CarbonIconType;
export const DocumentView32: CarbonIconType;
export const DotMark16: CarbonIconType;
export const DotMark20: CarbonIconType;
export const DotMark24: CarbonIconType;
export const DotMark32: CarbonIconType;
export const DoubleInteger16: CarbonIconType;
export const DoubleInteger20: CarbonIconType;
export const DoubleInteger24: CarbonIconType;
export const DoubleInteger32: CarbonIconType;
export const DownToBottom16: CarbonIconType;
export const DownToBottom20: CarbonIconType;
export const DownToBottom24: CarbonIconType;
export const DownToBottom32: CarbonIconType;
export const Download16: CarbonIconType;
export const Download20: CarbonIconType;
export const Download24: CarbonIconType;
export const Download32: CarbonIconType;
export const DragHorizontal16: CarbonIconType;
export const DragHorizontal20: CarbonIconType;
export const DragHorizontal24: CarbonIconType;
export const DragHorizontal32: CarbonIconType;
export const DragVertical16: CarbonIconType;
export const DragVertical20: CarbonIconType;
export const DragVertical24: CarbonIconType;
export const DragVertical32: CarbonIconType;
export const Draggable16: CarbonIconType;
export const Draggable20: CarbonIconType;
export const Draggable24: CarbonIconType;
export const Draggable32: CarbonIconType;
export const Draw16: CarbonIconType;
export const Draw20: CarbonIconType;
export const Draw24: CarbonIconType;
export const Draw32: CarbonIconType;
export const DropPhoto16: CarbonIconType;
export const DropPhoto20: CarbonIconType;
export const DropPhoto24: CarbonIconType;
export const DropPhoto32: CarbonIconType;
export const DropPhotoFilled16: CarbonIconType;
export const DropPhotoFilled20: CarbonIconType;
export const DropPhotoFilled24: CarbonIconType;
export const DropPhotoFilled32: CarbonIconType;
export const Dvr16: CarbonIconType;
export const Dvr20: CarbonIconType;
export const Dvr24: CarbonIconType;
export const Dvr32: CarbonIconType;
export const Earth16: CarbonIconType;
export const Earth20: CarbonIconType;
export const Earth24: CarbonIconType;
export const Earth32: CarbonIconType;
export const EarthAmericas16: CarbonIconType;
export const EarthAmericas20: CarbonIconType;
export const EarthAmericas24: CarbonIconType;
export const EarthAmericas32: CarbonIconType;
export const EarthAmericasFilled16: CarbonIconType;
export const EarthAmericasFilled20: CarbonIconType;
export const EarthAmericasFilled24: CarbonIconType;
export const EarthAmericasFilled32: CarbonIconType;
export const EarthEuropeAfrica16: CarbonIconType;
export const EarthEuropeAfrica20: CarbonIconType;
export const EarthEuropeAfrica24: CarbonIconType;
export const EarthEuropeAfrica32: CarbonIconType;
export const EarthEuropeAfricaFilled16: CarbonIconType;
export const EarthEuropeAfricaFilled20: CarbonIconType;
export const EarthEuropeAfricaFilled24: CarbonIconType;
export const EarthEuropeAfricaFilled32: CarbonIconType;
export const EarthFilled16: CarbonIconType;
export const EarthFilled20: CarbonIconType;
export const EarthFilled24: CarbonIconType;
export const EarthFilled32: CarbonIconType;
export const EarthSoutheastAsia16: CarbonIconType;
export const EarthSoutheastAsia20: CarbonIconType;
export const EarthSoutheastAsia24: CarbonIconType;
export const EarthSoutheastAsia32: CarbonIconType;
export const EarthSoutheastAsiaFilled16: CarbonIconType;
export const EarthSoutheastAsiaFilled20: CarbonIconType;
export const EarthSoutheastAsiaFilled24: CarbonIconType;
export const EarthSoutheastAsiaFilled32: CarbonIconType;
export const Edit16: CarbonIconType;
export const Edit20: CarbonIconType;
export const Edit24: CarbonIconType;
export const Edit32: CarbonIconType;
export const EditOff16: CarbonIconType;
export const EditOff20: CarbonIconType;
export const EditOff24: CarbonIconType;
export const EditOff32: CarbonIconType;
export const EdtLoop16: CarbonIconType;
export const EdtLoop20: CarbonIconType;
export const EdtLoop24: CarbonIconType;
export const EdtLoop32: CarbonIconType;
export const Education16: CarbonIconType;
export const Education20: CarbonIconType;
export const Education24: CarbonIconType;
export const Education32: CarbonIconType;
export const Email16: CarbonIconType;
export const Email20: CarbonIconType;
export const Email24: CarbonIconType;
export const Email32: CarbonIconType;
export const EmailNew16: CarbonIconType;
export const EmailNew20: CarbonIconType;
export const EmailNew24: CarbonIconType;
export const EmailNew32: CarbonIconType;
export const Enterprise16: CarbonIconType;
export const Enterprise20: CarbonIconType;
export const Enterprise24: CarbonIconType;
export const Enterprise32: CarbonIconType;
export const Erase16: CarbonIconType;
export const Erase20: CarbonIconType;
export const Erase24: CarbonIconType;
export const Erase32: CarbonIconType;
export const Error16: CarbonIconType;
export const Error20: CarbonIconType;
export const Error24: CarbonIconType;
export const Error32: CarbonIconType;
export const ErrorFilled16: CarbonIconType;
export const ErrorFilled20: CarbonIconType;
export const ErrorFilled24: CarbonIconType;
export const ErrorFilled32: CarbonIconType;
export const ErrorOutline16: CarbonIconType;
export const ErrorOutline20: CarbonIconType;
export const ErrorOutline24: CarbonIconType;
export const ErrorOutline32: CarbonIconType;
export const Event16: CarbonIconType;
export const Event20: CarbonIconType;
export const Event24: CarbonIconType;
export const Event32: CarbonIconType;
export const EventSchedule16: CarbonIconType;
export const EventSchedule20: CarbonIconType;
export const EventSchedule24: CarbonIconType;
export const EventSchedule32: CarbonIconType;
export const Events16: CarbonIconType;
export const Events20: CarbonIconType;
export const Events24: CarbonIconType;
export const Events32: CarbonIconType;
export const EventsAlt16: CarbonIconType;
export const EventsAlt20: CarbonIconType;
export const EventsAlt24: CarbonIconType;
export const EventsAlt32: CarbonIconType;
export const ExamMode16: CarbonIconType;
export const ExamMode20: CarbonIconType;
export const ExamMode24: CarbonIconType;
export const ExamMode32: CarbonIconType;
export const Exit16: CarbonIconType;
export const Exit20: CarbonIconType;
export const Exit24: CarbonIconType;
export const Exit32: CarbonIconType;
export const ExpandAll16: CarbonIconType;
export const ExpandAll20: CarbonIconType;
export const ExpandAll24: CarbonIconType;
export const ExpandAll32: CarbonIconType;
export const ExpandCategories16: CarbonIconType;
export const ExpandCategories20: CarbonIconType;
export const ExpandCategories24: CarbonIconType;
export const ExpandCategories32: CarbonIconType;
export const Export16: CarbonIconType;
export const Export20: CarbonIconType;
export const Export24: CarbonIconType;
export const Export32: CarbonIconType;
export const Eyedropper16: CarbonIconType;
export const Eyedropper20: CarbonIconType;
export const Eyedropper24: CarbonIconType;
export const Eyedropper32: CarbonIconType;
export const FaceActivated16: CarbonIconType;
export const FaceActivated20: CarbonIconType;
export const FaceActivated24: CarbonIconType;
export const FaceActivated32: CarbonIconType;
export const FaceActivatedAdd16: CarbonIconType;
export const FaceActivatedAdd20: CarbonIconType;
export const FaceActivatedAdd24: CarbonIconType;
export const FaceActivatedAdd32: CarbonIconType;
export const FaceActivatedFilled16: CarbonIconType;
export const FaceActivatedFilled20: CarbonIconType;
export const FaceActivatedFilled24: CarbonIconType;
export const FaceActivatedFilled32: CarbonIconType;
export const FaceAdd16: CarbonIconType;
export const FaceAdd20: CarbonIconType;
export const FaceAdd24: CarbonIconType;
export const FaceAdd32: CarbonIconType;
export const FaceCool16: CarbonIconType;
export const FaceCool20: CarbonIconType;
export const FaceCool24: CarbonIconType;
export const FaceCool32: CarbonIconType;
export const FaceDissatisfied16: CarbonIconType;
export const FaceDissatisfied20: CarbonIconType;
export const FaceDissatisfied24: CarbonIconType;
export const FaceDissatisfied32: CarbonIconType;
export const FaceDissatisfiedFilled16: CarbonIconType;
export const FaceDissatisfiedFilled20: CarbonIconType;
export const FaceDissatisfiedFilled24: CarbonIconType;
export const FaceDissatisfiedFilled32: CarbonIconType;
export const FaceDizzy16: CarbonIconType;
export const FaceDizzy20: CarbonIconType;
export const FaceDizzy24: CarbonIconType;
export const FaceDizzy32: CarbonIconType;
export const FaceDizzyFilled16: CarbonIconType;
export const FaceDizzyFilled20: CarbonIconType;
export const FaceDizzyFilled24: CarbonIconType;
export const FaceDizzyFilled32: CarbonIconType;
export const FaceNeutral16: CarbonIconType;
export const FaceNeutral20: CarbonIconType;
export const FaceNeutral24: CarbonIconType;
export const FaceNeutral32: CarbonIconType;
export const FaceNeutralFilled16: CarbonIconType;
export const FaceNeutralFilled20: CarbonIconType;
export const FaceNeutralFilled24: CarbonIconType;
export const FaceNeutralFilled32: CarbonIconType;
export const FacePending16: CarbonIconType;
export const FacePending20: CarbonIconType;
export const FacePending24: CarbonIconType;
export const FacePending32: CarbonIconType;
export const FacePendingFilled16: CarbonIconType;
export const FacePendingFilled20: CarbonIconType;
export const FacePendingFilled24: CarbonIconType;
export const FacePendingFilled32: CarbonIconType;
export const FaceSatisfied16: CarbonIconType;
export const FaceSatisfied20: CarbonIconType;
export const FaceSatisfied24: CarbonIconType;
export const FaceSatisfied32: CarbonIconType;
export const FaceSatisfiedFilled16: CarbonIconType;
export const FaceSatisfiedFilled20: CarbonIconType;
export const FaceSatisfiedFilled24: CarbonIconType;
export const FaceSatisfiedFilled32: CarbonIconType;
export const FaceWink16: CarbonIconType;
export const FaceWink20: CarbonIconType;
export const FaceWink24: CarbonIconType;
export const FaceWink32: CarbonIconType;
export const FaceWinkFilled16: CarbonIconType;
export const FaceWinkFilled20: CarbonIconType;
export const FaceWinkFilled24: CarbonIconType;
export const FaceWinkFilled32: CarbonIconType;
export const Factor16: CarbonIconType;
export const Factor20: CarbonIconType;
export const Factor24: CarbonIconType;
export const Factor32: CarbonIconType;
export const Fade16: CarbonIconType;
export const Fade20: CarbonIconType;
export const Fade24: CarbonIconType;
export const Fade32: CarbonIconType;
export const Favorite16: CarbonIconType;
export const Favorite20: CarbonIconType;
export const Favorite24: CarbonIconType;
export const Favorite32: CarbonIconType;
export const FavoriteFilled16: CarbonIconType;
export const FavoriteFilled20: CarbonIconType;
export const FavoriteFilled24: CarbonIconType;
export const FavoriteFilled32: CarbonIconType;
export const FetchUpload16: CarbonIconType;
export const FetchUpload20: CarbonIconType;
export const FetchUpload24: CarbonIconType;
export const FetchUpload32: CarbonIconType;
export const FetchUploadCloud16: CarbonIconType;
export const FetchUploadCloud20: CarbonIconType;
export const FetchUploadCloud24: CarbonIconType;
export const FetchUploadCloud32: CarbonIconType;
export const Filter16: CarbonIconType;
export const Filter20: CarbonIconType;
export const Filter24: CarbonIconType;
export const Filter32: CarbonIconType;
export const FilterEdit16: CarbonIconType;
export const FilterEdit20: CarbonIconType;
export const FilterEdit24: CarbonIconType;
export const FilterEdit32: CarbonIconType;
export const Finance16: CarbonIconType;
export const Finance20: CarbonIconType;
export const Finance24: CarbonIconType;
export const Finance32: CarbonIconType;
export const FingerprintRecognition16: CarbonIconType;
export const FingerprintRecognition20: CarbonIconType;
export const FingerprintRecognition24: CarbonIconType;
export const FingerprintRecognition32: CarbonIconType;
export const Fire16: CarbonIconType;
export const Fire20: CarbonIconType;
export const Fire24: CarbonIconType;
export const Fire32: CarbonIconType;
export const Fish16: CarbonIconType;
export const Fish20: CarbonIconType;
export const Fish24: CarbonIconType;
export const Fish32: CarbonIconType;
export const FishMultiple16: CarbonIconType;
export const FishMultiple20: CarbonIconType;
export const FishMultiple24: CarbonIconType;
export const FishMultiple32: CarbonIconType;
export const FitToScreen16: CarbonIconType;
export const FitToScreen20: CarbonIconType;
export const FitToScreen24: CarbonIconType;
export const FitToScreen32: CarbonIconType;
export const Flag16: CarbonIconType;
export const Flag20: CarbonIconType;
export const Flag24: CarbonIconType;
export const Flag32: CarbonIconType;
export const FlaggingTaxi16: CarbonIconType;
export const FlaggingTaxi20: CarbonIconType;
export const FlaggingTaxi24: CarbonIconType;
export const FlaggingTaxi32: CarbonIconType;
export const Flash16: CarbonIconType;
export const Flash20: CarbonIconType;
export const Flash24: CarbonIconType;
export const Flash32: CarbonIconType;
export const FlashFilled16: CarbonIconType;
export const FlashFilled20: CarbonIconType;
export const FlashFilled24: CarbonIconType;
export const FlashFilled32: CarbonIconType;
export const FlashOff16: CarbonIconType;
export const FlashOff20: CarbonIconType;
export const FlashOff24: CarbonIconType;
export const FlashOff32: CarbonIconType;
export const FlashOffFilled16: CarbonIconType;
export const FlashOffFilled20: CarbonIconType;
export const FlashOffFilled24: CarbonIconType;
export const FlashOffFilled32: CarbonIconType;
export const Flow16: CarbonIconType;
export const Flow20: CarbonIconType;
export const Flow24: CarbonIconType;
export const Flow32: CarbonIconType;
export const FlowConnection16: CarbonIconType;
export const FlowConnection20: CarbonIconType;
export const FlowConnection24: CarbonIconType;
export const FlowConnection32: CarbonIconType;
export const FlowData16: CarbonIconType;
export const FlowData20: CarbonIconType;
export const FlowData24: CarbonIconType;
export const FlowData32: CarbonIconType;
export const FlowStream16: CarbonIconType;
export const FlowStream20: CarbonIconType;
export const FlowStream24: CarbonIconType;
export const FlowStream32: CarbonIconType;
export const Fog16: CarbonIconType;
export const Fog20: CarbonIconType;
export const Fog24: CarbonIconType;
export const Fog32: CarbonIconType;
export const Folder16: CarbonIconType;
export const Folder20: CarbonIconType;
export const Folder24: CarbonIconType;
export const Folder32: CarbonIconType;
export const FolderAdd16: CarbonIconType;
export const FolderAdd20: CarbonIconType;
export const FolderAdd24: CarbonIconType;
export const FolderAdd32: CarbonIconType;
export const FolderDetails16: CarbonIconType;
export const FolderDetails20: CarbonIconType;
export const FolderDetails24: CarbonIconType;
export const FolderDetails32: CarbonIconType;
export const FolderOff16: CarbonIconType;
export const FolderOff20: CarbonIconType;
export const FolderOff24: CarbonIconType;
export const FolderOff32: CarbonIconType;
export const FolderShared16: CarbonIconType;
export const FolderShared20: CarbonIconType;
export const FolderShared24: CarbonIconType;
export const FolderShared32: CarbonIconType;
export const Folders16: CarbonIconType;
export const Folders20: CarbonIconType;
export const Folders24: CarbonIconType;
export const Folders32: CarbonIconType;
export const Fork16: CarbonIconType;
export const Fork20: CarbonIconType;
export const Fork24: CarbonIconType;
export const Fork32: CarbonIconType;
export const Forum16: CarbonIconType;
export const Forum20: CarbonIconType;
export const Forum24: CarbonIconType;
export const Forum32: CarbonIconType;
export const Forward_1016: CarbonIconType;
export const Forward_1020: CarbonIconType;
export const Forward_1024: CarbonIconType;
export const Forward_1032: CarbonIconType;
export const Forward_3016: CarbonIconType;
export const Forward_3020: CarbonIconType;
export const Forward_3024: CarbonIconType;
export const Forward_3032: CarbonIconType;
export const Forward_516: CarbonIconType;
export const Forward_520: CarbonIconType;
export const Forward_524: CarbonIconType;
export const Forward_532: CarbonIconType;
export const FruitBowl16: CarbonIconType;
export const FruitBowl20: CarbonIconType;
export const FruitBowl24: CarbonIconType;
export const FruitBowl32: CarbonIconType;
export const Function16: CarbonIconType;
export const Function20: CarbonIconType;
export const Function24: CarbonIconType;
export const Function32: CarbonIconType;
export const GameConsole16: CarbonIconType;
export const GameConsole20: CarbonIconType;
export const GameConsole24: CarbonIconType;
export const GameConsole32: CarbonIconType;
export const GameWireless16: CarbonIconType;
export const GameWireless20: CarbonIconType;
export const GameWireless24: CarbonIconType;
export const GameWireless32: CarbonIconType;
export const Gamification16: CarbonIconType;
export const Gamification20: CarbonIconType;
export const Gamification24: CarbonIconType;
export const Gamification32: CarbonIconType;
export const GasStation16: CarbonIconType;
export const GasStation20: CarbonIconType;
export const GasStation24: CarbonIconType;
export const GasStation32: CarbonIconType;
export const GeneratePdf16: CarbonIconType;
export const GeneratePdf20: CarbonIconType;
export const GeneratePdf24: CarbonIconType;
export const GeneratePdf32: CarbonIconType;
export const Gif16: CarbonIconType;
export const Gif20: CarbonIconType;
export const Gif24: CarbonIconType;
export const Gif32: CarbonIconType;
export const Gift16: CarbonIconType;
export const Gift20: CarbonIconType;
export const Gift24: CarbonIconType;
export const Gift32: CarbonIconType;
export const Globe16: CarbonIconType;
export const Globe20: CarbonIconType;
export const Globe24: CarbonIconType;
export const Globe32: CarbonIconType;
export const Gradient16: CarbonIconType;
export const Gradient20: CarbonIconType;
export const Gradient24: CarbonIconType;
export const Gradient32: CarbonIconType;
export const GraphicalDataFlow16: CarbonIconType;
export const GraphicalDataFlow20: CarbonIconType;
export const GraphicalDataFlow24: CarbonIconType;
export const GraphicalDataFlow32: CarbonIconType;
export const Grid16: CarbonIconType;
export const Grid20: CarbonIconType;
export const Grid24: CarbonIconType;
export const Grid32: CarbonIconType;
export const Group16: CarbonIconType;
export const Group20: CarbonIconType;
export const Group24: CarbonIconType;
export const Group32: CarbonIconType;
export const Hail16: CarbonIconType;
export const Hail20: CarbonIconType;
export const Hail24: CarbonIconType;
export const Hail32: CarbonIconType;
export const Harbor16: CarbonIconType;
export const Harbor20: CarbonIconType;
export const Harbor24: CarbonIconType;
export const Harbor32: CarbonIconType;
export const Hashtag16: CarbonIconType;
export const Hashtag20: CarbonIconType;
export const Hashtag24: CarbonIconType;
export const Hashtag32: CarbonIconType;
export const Haze16: CarbonIconType;
export const Haze20: CarbonIconType;
export const Haze24: CarbonIconType;
export const Haze32: CarbonIconType;
export const HazeNight16: CarbonIconType;
export const HazeNight20: CarbonIconType;
export const HazeNight24: CarbonIconType;
export const HazeNight32: CarbonIconType;
export const Hd16: CarbonIconType;
export const Hd20: CarbonIconType;
export const Hd24: CarbonIconType;
export const Hd32: CarbonIconType;
export const HdFilled16: CarbonIconType;
export const HdFilled20: CarbonIconType;
export const HdFilled24: CarbonIconType;
export const HdFilled32: CarbonIconType;
export const Hdr16: CarbonIconType;
export const Hdr20: CarbonIconType;
export const Hdr24: CarbonIconType;
export const Hdr32: CarbonIconType;
export const Headphones16: CarbonIconType;
export const Headphones20: CarbonIconType;
export const Headphones24: CarbonIconType;
export const Headphones32: CarbonIconType;
export const Headset16: CarbonIconType;
export const Headset20: CarbonIconType;
export const Headset24: CarbonIconType;
export const Headset32: CarbonIconType;
export const HealthCross16: CarbonIconType;
export const HealthCross20: CarbonIconType;
export const HealthCross24: CarbonIconType;
export const HealthCross32: CarbonIconType;
export const Hearing16: CarbonIconType;
export const Hearing20: CarbonIconType;
export const Hearing24: CarbonIconType;
export const Hearing32: CarbonIconType;
export const HeatMap16: CarbonIconType;
export const HeatMap20: CarbonIconType;
export const HeatMap24: CarbonIconType;
export const HeatMap32: CarbonIconType;
export const HeatMap_0216: CarbonIconType;
export const HeatMap_0220: CarbonIconType;
export const HeatMap_0224: CarbonIconType;
export const HeatMap_0232: CarbonIconType;
export const HeatMap_0316: CarbonIconType;
export const HeatMap_0320: CarbonIconType;
export const HeatMap_0324: CarbonIconType;
export const HeatMap_0332: CarbonIconType;
export const Helicopter16: CarbonIconType;
export const Helicopter20: CarbonIconType;
export const Helicopter24: CarbonIconType;
export const Helicopter32: CarbonIconType;
export const Help16: CarbonIconType;
export const Help20: CarbonIconType;
export const Help24: CarbonIconType;
export const Help32: CarbonIconType;
export const HelpDesk16: CarbonIconType;
export const HelpDesk20: CarbonIconType;
export const HelpDesk24: CarbonIconType;
export const HelpDesk32: CarbonIconType;
export const HelpFilled16: CarbonIconType;
export const HelpFilled20: CarbonIconType;
export const HelpFilled24: CarbonIconType;
export const HelpFilled32: CarbonIconType;
export const Home16: CarbonIconType;
export const Home20: CarbonIconType;
export const Home24: CarbonIconType;
export const Home32: CarbonIconType;
export const Hospital16: CarbonIconType;
export const Hospital20: CarbonIconType;
export const Hospital24: CarbonIconType;
export const Hospital32: CarbonIconType;
export const HospitalBed16: CarbonIconType;
export const HospitalBed20: CarbonIconType;
export const HospitalBed24: CarbonIconType;
export const HospitalBed32: CarbonIconType;
export const Hotel16: CarbonIconType;
export const Hotel20: CarbonIconType;
export const Hotel24: CarbonIconType;
export const Hotel32: CarbonIconType;
export const Hourglass16: CarbonIconType;
export const Hourglass20: CarbonIconType;
export const Hourglass24: CarbonIconType;
export const Hourglass32: CarbonIconType;
export const Http16: CarbonIconType;
export const Http20: CarbonIconType;
export const Http24: CarbonIconType;
export const Http32: CarbonIconType;
export const Humidity16: CarbonIconType;
export const Humidity20: CarbonIconType;
export const Humidity24: CarbonIconType;
export const Humidity32: CarbonIconType;
export const HumidityAlt16: CarbonIconType;
export const HumidityAlt20: CarbonIconType;
export const HumidityAlt24: CarbonIconType;
export const HumidityAlt32: CarbonIconType;
export const Hurricane16: CarbonIconType;
export const Hurricane20: CarbonIconType;
export const Hurricane24: CarbonIconType;
export const Hurricane32: CarbonIconType;
export const HybridNetworking16: CarbonIconType;
export const HybridNetworking20: CarbonIconType;
export const HybridNetworking24: CarbonIconType;
export const HybridNetworking32: CarbonIconType;
export const IbmCloud16: CarbonIconType;
export const IbmCloud20: CarbonIconType;
export const IbmCloud24: CarbonIconType;
export const IbmCloud32: CarbonIconType;
export const IbmSecurity16: CarbonIconType;
export const IbmSecurity20: CarbonIconType;
export const IbmSecurity24: CarbonIconType;
export const IbmSecurity32: CarbonIconType;
export const Icon: CarbonIconType;
export const Idea16: CarbonIconType;
export const Idea20: CarbonIconType;
export const Idea24: CarbonIconType;
export const Idea32: CarbonIconType;
export const Identification16: CarbonIconType;
export const Identification20: CarbonIconType;
export const Identification24: CarbonIconType;
export const Identification32: CarbonIconType;
export const Image16: CarbonIconType;
export const Image20: CarbonIconType;
export const Image24: CarbonIconType;
export const Image32: CarbonIconType;
export const ImageMedical16: CarbonIconType;
export const ImageMedical20: CarbonIconType;
export const ImageMedical24: CarbonIconType;
export const ImageMedical32: CarbonIconType;
export const ImageSearch16: CarbonIconType;
export const ImageSearch20: CarbonIconType;
export const ImageSearch24: CarbonIconType;
export const ImageSearch32: CarbonIconType;
export const ImproveRelevance16: CarbonIconType;
export const ImproveRelevance20: CarbonIconType;
export const ImproveRelevance24: CarbonIconType;
export const ImproveRelevance32: CarbonIconType;
export const InProgress16: CarbonIconType;
export const InProgress20: CarbonIconType;
export const InProgress24: CarbonIconType;
export const InProgress32: CarbonIconType;
export const IncreaseLevel16: CarbonIconType;
export const IncreaseLevel20: CarbonIconType;
export const IncreaseLevel24: CarbonIconType;
export const IncreaseLevel32: CarbonIconType;
export const Industry16: CarbonIconType;
export const Industry20: CarbonIconType;
export const Industry24: CarbonIconType;
export const Industry32: CarbonIconType;
export const Information16: CarbonIconType;
export const Information20: CarbonIconType;
export const Information24: CarbonIconType;
export const Information32: CarbonIconType;
export const InformationFilled16: CarbonIconType;
export const InformationFilled20: CarbonIconType;
export const InformationFilled24: CarbonIconType;
export const InformationFilled32: CarbonIconType;
export const InformationSquare16: CarbonIconType;
export const InformationSquare20: CarbonIconType;
export const InformationSquare24: CarbonIconType;
export const InformationSquare32: CarbonIconType;
export const InformationSquareFilled16: CarbonIconType;
export const InformationSquareFilled20: CarbonIconType;
export const InformationSquareFilled24: CarbonIconType;
export const InformationSquareFilled32: CarbonIconType;
export const Insert16: CarbonIconType;
export const Insert20: CarbonIconType;
export const Insert24: CarbonIconType;
export const Insert32: CarbonIconType;
export const InsertPage16: CarbonIconType;
export const InsertPage20: CarbonIconType;
export const InsertPage24: CarbonIconType;
export const InsertPage32: CarbonIconType;
export const Integration16: CarbonIconType;
export const Integration20: CarbonIconType;
export const Integration24: CarbonIconType;
export const Integration32: CarbonIconType;
export const Interactions16: CarbonIconType;
export const Interactions20: CarbonIconType;
export const Interactions24: CarbonIconType;
export const Interactions32: CarbonIconType;
export const InventoryManagement16: CarbonIconType;
export const InventoryManagement20: CarbonIconType;
export const InventoryManagement24: CarbonIconType;
export const InventoryManagement32: CarbonIconType;
export const IotConnect16: CarbonIconType;
export const IotConnect20: CarbonIconType;
export const IotConnect24: CarbonIconType;
export const IotConnect32: CarbonIconType;
export const IotPlatform16: CarbonIconType;
export const IotPlatform20: CarbonIconType;
export const IotPlatform24: CarbonIconType;
export const IotPlatform32: CarbonIconType;
export const Iso16: CarbonIconType;
export const Iso20: CarbonIconType;
export const Iso24: CarbonIconType;
export const Iso32: CarbonIconType;
export const IsoFilled16: CarbonIconType;
export const IsoFilled20: CarbonIconType;
export const IsoFilled24: CarbonIconType;
export const IsoFilled32: CarbonIconType;
export const IsoOutline16: CarbonIconType;
export const IsoOutline20: CarbonIconType;
export const IsoOutline24: CarbonIconType;
export const IsoOutline32: CarbonIconType;
export const JoinInner16: CarbonIconType;
export const JoinInner20: CarbonIconType;
export const JoinInner24: CarbonIconType;
export const JoinInner32: CarbonIconType;
export const JoinLeft16: CarbonIconType;
export const JoinLeft20: CarbonIconType;
export const JoinLeft24: CarbonIconType;
export const JoinLeft32: CarbonIconType;
export const JoinOuter16: CarbonIconType;
export const JoinOuter20: CarbonIconType;
export const JoinOuter24: CarbonIconType;
export const JoinOuter32: CarbonIconType;
export const JoinRight16: CarbonIconType;
export const JoinRight20: CarbonIconType;
export const JoinRight24: CarbonIconType;
export const JoinRight32: CarbonIconType;
export const Jpg16: CarbonIconType;
export const Jpg20: CarbonIconType;
export const Jpg24: CarbonIconType;
export const Jpg32: CarbonIconType;
export const Json16: CarbonIconType;
export const Json20: CarbonIconType;
export const Json24: CarbonIconType;
export const Json32: CarbonIconType;
export const JumpLink16: CarbonIconType;
export const JumpLink20: CarbonIconType;
export const JumpLink24: CarbonIconType;
export const JumpLink32: CarbonIconType;
export const Keyboard16: CarbonIconType;
export const Keyboard20: CarbonIconType;
export const Keyboard24: CarbonIconType;
export const Keyboard32: CarbonIconType;
export const Language16: CarbonIconType;
export const Language20: CarbonIconType;
export const Language24: CarbonIconType;
export const Language32: CarbonIconType;
export const Laptop16: CarbonIconType;
export const Laptop20: CarbonIconType;
export const Laptop24: CarbonIconType;
export const Laptop32: CarbonIconType;
export const Launch16: CarbonIconType;
export const Launch20: CarbonIconType;
export const Launch24: CarbonIconType;
export const Launch32: CarbonIconType;
export const Legend16: CarbonIconType;
export const Legend20: CarbonIconType;
export const Legend24: CarbonIconType;
export const Legend32: CarbonIconType;
export const LetterAa16: CarbonIconType;
export const LetterAa20: CarbonIconType;
export const LetterAa24: CarbonIconType;
export const LetterAa32: CarbonIconType;
export const LetterBb16: CarbonIconType;
export const LetterBb20: CarbonIconType;
export const LetterBb24: CarbonIconType;
export const LetterBb32: CarbonIconType;
export const LetterCc16: CarbonIconType;
export const LetterCc20: CarbonIconType;
export const LetterCc24: CarbonIconType;
export const LetterCc32: CarbonIconType;
export const LetterDd16: CarbonIconType;
export const LetterDd20: CarbonIconType;
export const LetterDd24: CarbonIconType;
export const LetterDd32: CarbonIconType;
export const LetterEe16: CarbonIconType;
export const LetterEe20: CarbonIconType;
export const LetterEe24: CarbonIconType;
export const LetterEe32: CarbonIconType;
export const LetterFf16: CarbonIconType;
export const LetterFf20: CarbonIconType;
export const LetterFf24: CarbonIconType;
export const LetterFf32: CarbonIconType;
export const LetterGg16: CarbonIconType;
export const LetterGg20: CarbonIconType;
export const LetterGg24: CarbonIconType;
export const LetterGg32: CarbonIconType;
export const LetterHh16: CarbonIconType;
export const LetterHh20: CarbonIconType;
export const LetterHh24: CarbonIconType;
export const LetterHh32: CarbonIconType;
export const LetterIi16: CarbonIconType;
export const LetterIi20: CarbonIconType;
export const LetterIi24: CarbonIconType;
export const LetterIi32: CarbonIconType;
export const LetterJj16: CarbonIconType;
export const LetterJj20: CarbonIconType;
export const LetterJj24: CarbonIconType;
export const LetterJj32: CarbonIconType;
export const LetterKk16: CarbonIconType;
export const LetterKk20: CarbonIconType;
export const LetterKk24: CarbonIconType;
export const LetterKk32: CarbonIconType;
export const LetterLl16: CarbonIconType;
export const LetterLl20: CarbonIconType;
export const LetterLl24: CarbonIconType;
export const LetterLl32: CarbonIconType;
export const LetterMm16: CarbonIconType;
export const LetterMm20: CarbonIconType;
export const LetterMm24: CarbonIconType;
export const LetterMm32: CarbonIconType;
export const LetterNn16: CarbonIconType;
export const LetterNn20: CarbonIconType;
export const LetterNn24: CarbonIconType;
export const LetterNn32: CarbonIconType;
export const LetterOo16: CarbonIconType;
export const LetterOo20: CarbonIconType;
export const LetterOo24: CarbonIconType;
export const LetterOo32: CarbonIconType;
export const LetterPp16: CarbonIconType;
export const LetterPp20: CarbonIconType;
export const LetterPp24: CarbonIconType;
export const LetterPp32: CarbonIconType;
export const LetterQq16: CarbonIconType;
export const LetterQq20: CarbonIconType;
export const LetterQq24: CarbonIconType;
export const LetterQq32: CarbonIconType;
export const LetterRr16: CarbonIconType;
export const LetterRr20: CarbonIconType;
export const LetterRr24: CarbonIconType;
export const LetterRr32: CarbonIconType;
export const LetterSs16: CarbonIconType;
export const LetterSs20: CarbonIconType;
export const LetterSs24: CarbonIconType;
export const LetterSs32: CarbonIconType;
export const LetterTt16: CarbonIconType;
export const LetterTt20: CarbonIconType;
export const LetterTt24: CarbonIconType;
export const LetterTt32: CarbonIconType;
export const LetterUu16: CarbonIconType;
export const LetterUu20: CarbonIconType;
export const LetterUu24: CarbonIconType;
export const LetterUu32: CarbonIconType;
export const LetterVv16: CarbonIconType;
export const LetterVv20: CarbonIconType;
export const LetterVv24: CarbonIconType;
export const LetterVv32: CarbonIconType;
export const LetterWw16: CarbonIconType;
export const LetterWw20: CarbonIconType;
export const LetterWw24: CarbonIconType;
export const LetterWw32: CarbonIconType;
export const LetterXx16: CarbonIconType;
export const LetterXx20: CarbonIconType;
export const LetterXx24: CarbonIconType;
export const LetterXx32: CarbonIconType;
export const LetterYy16: CarbonIconType;
export const LetterYy20: CarbonIconType;
export const LetterYy24: CarbonIconType;
export const LetterYy32: CarbonIconType;
export const LetterZz16: CarbonIconType;
export const LetterZz20: CarbonIconType;
export const LetterZz24: CarbonIconType;
export const LetterZz32: CarbonIconType;
export const Light16: CarbonIconType;
export const Light20: CarbonIconType;
export const Light24: CarbonIconType;
export const Light32: CarbonIconType;
export const LightFilled16: CarbonIconType;
export const LightFilled20: CarbonIconType;
export const LightFilled24: CarbonIconType;
export const LightFilled32: CarbonIconType;
export const Lightning16: CarbonIconType;
export const Lightning20: CarbonIconType;
export const Lightning24: CarbonIconType;
export const Lightning32: CarbonIconType;
export const Link16: CarbonIconType;
export const Link20: CarbonIconType;
export const Link24: CarbonIconType;
export const Link32: CarbonIconType;
export const List16: CarbonIconType;
export const List20: CarbonIconType;
export const List24: CarbonIconType;
export const List32: CarbonIconType;
export const ListBoxes16: CarbonIconType;
export const ListBoxes20: CarbonIconType;
export const ListBoxes24: CarbonIconType;
export const ListBoxes32: CarbonIconType;
export const ListBulleted16: CarbonIconType;
export const ListBulleted20: CarbonIconType;
export const ListBulleted24: CarbonIconType;
export const ListBulleted32: CarbonIconType;
export const ListChecked16: CarbonIconType;
export const ListChecked20: CarbonIconType;
export const ListChecked24: CarbonIconType;
export const ListChecked32: CarbonIconType;
export const ListDropdown16: CarbonIconType;
export const ListDropdown20: CarbonIconType;
export const ListDropdown24: CarbonIconType;
export const ListDropdown32: CarbonIconType;
export const ListNumbered16: CarbonIconType;
export const ListNumbered20: CarbonIconType;
export const ListNumbered24: CarbonIconType;
export const ListNumbered32: CarbonIconType;
export const Location16: CarbonIconType;
export const Location20: CarbonIconType;
export const Location24: CarbonIconType;
export const Location32: CarbonIconType;
export const Locked16: CarbonIconType;
export const Locked20: CarbonIconType;
export const Locked24: CarbonIconType;
export const Locked32: CarbonIconType;
export const Login16: CarbonIconType;
export const Login20: CarbonIconType;
export const Login24: CarbonIconType;
export const Login32: CarbonIconType;
export const LogoDigg16: CarbonIconType;
export const LogoDigg20: CarbonIconType;
export const LogoDigg24: CarbonIconType;
export const LogoDigg32: CarbonIconType;
export const LogoFacebook16: CarbonIconType;
export const LogoFacebook20: CarbonIconType;
export const LogoFacebook24: CarbonIconType;
export const LogoFacebook32: CarbonIconType;
export const LogoFlickr16: CarbonIconType;
export const LogoFlickr20: CarbonIconType;
export const LogoFlickr24: CarbonIconType;
export const LogoFlickr32: CarbonIconType;
export const LogoGithub16: CarbonIconType;
export const LogoGithub20: CarbonIconType;
export const LogoGithub24: CarbonIconType;
export const LogoGithub32: CarbonIconType;
export const LogoGlassdoor16: CarbonIconType;
export const LogoGlassdoor20: CarbonIconType;
export const LogoGlassdoor24: CarbonIconType;
export const LogoGlassdoor32: CarbonIconType;
export const LogoInstagram16: CarbonIconType;
export const LogoInstagram20: CarbonIconType;
export const LogoInstagram24: CarbonIconType;
export const LogoInstagram32: CarbonIconType;
export const LogoJupyter16: CarbonIconType;
export const LogoJupyter20: CarbonIconType;
export const LogoJupyter24: CarbonIconType;
export const LogoJupyter32: CarbonIconType;
export const LogoLinkedin16: CarbonIconType;
export const LogoLinkedin20: CarbonIconType;
export const LogoLinkedin24: CarbonIconType;
export const LogoLinkedin32: CarbonIconType;
export const LogoLivestream16: CarbonIconType;
export const LogoLivestream20: CarbonIconType;
export const LogoLivestream24: CarbonIconType;
export const LogoLivestream32: CarbonIconType;
export const LogoMedium16: CarbonIconType;
export const LogoMedium20: CarbonIconType;
export const LogoMedium24: CarbonIconType;
export const LogoMedium32: CarbonIconType;
export const LogoOpenshift16: CarbonIconType;
export const LogoOpenshift20: CarbonIconType;
export const LogoOpenshift24: CarbonIconType;
export const LogoOpenshift32: CarbonIconType;
export const LogoPinterest16: CarbonIconType;
export const LogoPinterest20: CarbonIconType;
export const LogoPinterest24: CarbonIconType;
export const LogoPinterest32: CarbonIconType;
export const LogoPython16: CarbonIconType;
export const LogoPython20: CarbonIconType;
export const LogoPython24: CarbonIconType;
export const LogoPython32: CarbonIconType;
export const LogoQuora16: CarbonIconType;
export const LogoQuora20: CarbonIconType;
export const LogoQuora24: CarbonIconType;
export const LogoQuora32: CarbonIconType;
export const LogoRScript16: CarbonIconType;
export const LogoRScript20: CarbonIconType;
export const LogoRScript24: CarbonIconType;
export const LogoRScript32: CarbonIconType;
export const LogoSkype16: CarbonIconType;
export const LogoSkype20: CarbonIconType;
export const LogoSkype24: CarbonIconType;
export const LogoSkype32: CarbonIconType;
export const LogoSlack16: CarbonIconType;
export const LogoSlack20: CarbonIconType;
export const LogoSlack24: CarbonIconType;
export const LogoSlack32: CarbonIconType;
export const LogoSnapchat16: CarbonIconType;
export const LogoSnapchat20: CarbonIconType;
export const LogoSnapchat24: CarbonIconType;
export const LogoSnapchat32: CarbonIconType;
export const LogoTumblr16: CarbonIconType;
export const LogoTumblr20: CarbonIconType;
export const LogoTumblr24: CarbonIconType;
export const LogoTumblr32: CarbonIconType;
export const LogoTwitter16: CarbonIconType;
export const LogoTwitter20: CarbonIconType;
export const LogoTwitter24: CarbonIconType;
export const LogoTwitter32: CarbonIconType;
export const LogoVmware16: CarbonIconType;
export const LogoVmware20: CarbonIconType;
export const LogoVmware24: CarbonIconType;
export const LogoVmware32: CarbonIconType;
export const LogoXing16: CarbonIconType;
export const LogoXing20: CarbonIconType;
export const LogoXing24: CarbonIconType;
export const LogoXing32: CarbonIconType;
export const LogoYelp16: CarbonIconType;
export const LogoYelp20: CarbonIconType;
export const LogoYelp24: CarbonIconType;
export const LogoYelp32: CarbonIconType;
export const LogoYoutube16: CarbonIconType;
export const LogoYoutube20: CarbonIconType;
export const LogoYoutube24: CarbonIconType;
export const LogoYoutube32: CarbonIconType;
export const Logout16: CarbonIconType;
export const Logout20: CarbonIconType;
export const Logout24: CarbonIconType;
export const Logout32: CarbonIconType;
export const Loop16: CarbonIconType;
export const Loop20: CarbonIconType;
export const Loop24: CarbonIconType;
export const Loop32: CarbonIconType;
export const MacCommand16: CarbonIconType;
export const MacCommand20: CarbonIconType;
export const MacCommand24: CarbonIconType;
export const MacCommand32: CarbonIconType;
export const MacOption16: CarbonIconType;
export const MacOption20: CarbonIconType;
export const MacOption24: CarbonIconType;
export const MacOption32: CarbonIconType;
export const MacShift16: CarbonIconType;
export const MacShift20: CarbonIconType;
export const MacShift24: CarbonIconType;
export const MacShift32: CarbonIconType;
export const MachineLearning16: CarbonIconType;
export const MachineLearning20: CarbonIconType;
export const MachineLearning24: CarbonIconType;
export const MachineLearning32: CarbonIconType;
export const MagicWand16: CarbonIconType;
export const MagicWand20: CarbonIconType;
export const MagicWand24: CarbonIconType;
export const MagicWand32: CarbonIconType;
export const MagicWandFilled16: CarbonIconType;
export const MagicWandFilled20: CarbonIconType;
export const MagicWandFilled24: CarbonIconType;
export const MagicWandFilled32: CarbonIconType;
export const MailAll16: CarbonIconType;
export const MailAll20: CarbonIconType;
export const MailAll24: CarbonIconType;
export const MailAll32: CarbonIconType;
export const MailReply16: CarbonIconType;
export const MailReply20: CarbonIconType;
export const MailReply24: CarbonIconType;
export const MailReply32: CarbonIconType;
export const ManageProtection16: CarbonIconType;
export const ManageProtection20: CarbonIconType;
export const ManageProtection24: CarbonIconType;
export const ManageProtection32: CarbonIconType;
export const ManagedSolutions16: CarbonIconType;
export const ManagedSolutions20: CarbonIconType;
export const ManagedSolutions24: CarbonIconType;
export const ManagedSolutions32: CarbonIconType;
export const Map16: CarbonIconType;
export const Map20: CarbonIconType;
export const Map24: CarbonIconType;
export const Map32: CarbonIconType;
export const MathCurve16: CarbonIconType;
export const MathCurve20: CarbonIconType;
export const MathCurve24: CarbonIconType;
export const MathCurve32: CarbonIconType;
export const Maximize16: CarbonIconType;
export const Maximize20: CarbonIconType;
export const Maximize24: CarbonIconType;
export const Maximize32: CarbonIconType;
export const Medication16: CarbonIconType;
export const Medication20: CarbonIconType;
export const Medication24: CarbonIconType;
export const Medication32: CarbonIconType;
export const MedicationAlert16: CarbonIconType;
export const MedicationAlert20: CarbonIconType;
export const MedicationAlert24: CarbonIconType;
export const MedicationAlert32: CarbonIconType;
export const MedicationReminder16: CarbonIconType;
export const MedicationReminder20: CarbonIconType;
export const MedicationReminder24: CarbonIconType;
export const MedicationReminder32: CarbonIconType;
export const Menu16: CarbonIconType;
export const Menu20: CarbonIconType;
export const Menu24: CarbonIconType;
export const Menu32: CarbonIconType;
export const Meter16: CarbonIconType;
export const Meter20: CarbonIconType;
export const Meter24: CarbonIconType;
export const Meter32: CarbonIconType;
export const MeterAlt16: CarbonIconType;
export const MeterAlt20: CarbonIconType;
export const MeterAlt24: CarbonIconType;
export const MeterAlt32: CarbonIconType;
export const Microphone16: CarbonIconType;
export const Microphone20: CarbonIconType;
export const Microphone24: CarbonIconType;
export const Microphone32: CarbonIconType;
export const MicrophoneFilled16: CarbonIconType;
export const MicrophoneFilled20: CarbonIconType;
export const MicrophoneFilled24: CarbonIconType;
export const MicrophoneFilled32: CarbonIconType;
export const MicrophoneOff16: CarbonIconType;
export const MicrophoneOff20: CarbonIconType;
export const MicrophoneOff24: CarbonIconType;
export const MicrophoneOff32: CarbonIconType;
export const MicrophoneOffFilled16: CarbonIconType;
export const MicrophoneOffFilled20: CarbonIconType;
export const MicrophoneOffFilled24: CarbonIconType;
export const MicrophoneOffFilled32: CarbonIconType;
export const Microscope16: CarbonIconType;
export const Microscope20: CarbonIconType;
export const Microscope24: CarbonIconType;
export const Microscope32: CarbonIconType;
export const Migrate16: CarbonIconType;
export const Migrate20: CarbonIconType;
export const Migrate24: CarbonIconType;
export const Migrate32: CarbonIconType;
export const MigrateAlt16: CarbonIconType;
export const MigrateAlt20: CarbonIconType;
export const MigrateAlt24: CarbonIconType;
export const MigrateAlt32: CarbonIconType;
export const Milestone16: CarbonIconType;
export const Milestone20: CarbonIconType;
export const Milestone24: CarbonIconType;
export const Milestone32: CarbonIconType;
export const Minimize16: CarbonIconType;
export const Minimize20: CarbonIconType;
export const Minimize24: CarbonIconType;
export const Minimize32: CarbonIconType;
export const Misuse16: CarbonIconType;
export const Misuse20: CarbonIconType;
export const Misuse24: CarbonIconType;
export const Misuse32: CarbonIconType;
export const MisuseAlt16: CarbonIconType;
export const MisuseAlt20: CarbonIconType;
export const MisuseAlt24: CarbonIconType;
export const MisuseAlt32: CarbonIconType;
export const MisuseOutline16: CarbonIconType;
export const MisuseOutline20: CarbonIconType;
export const MisuseOutline24: CarbonIconType;
export const MisuseOutline32: CarbonIconType;
export const MixedRainHail16: CarbonIconType;
export const MixedRainHail20: CarbonIconType;
export const MixedRainHail24: CarbonIconType;
export const MixedRainHail32: CarbonIconType;
export const Mobile16: CarbonIconType;
export const Mobile20: CarbonIconType;
export const Mobile24: CarbonIconType;
export const Mobile32: CarbonIconType;
export const MobileAdd16: CarbonIconType;
export const MobileAdd20: CarbonIconType;
export const MobileAdd24: CarbonIconType;
export const MobileAdd32: CarbonIconType;
export const MobileAudio16: CarbonIconType;
export const MobileAudio20: CarbonIconType;
export const MobileAudio24: CarbonIconType;
export const MobileAudio32: CarbonIconType;
export const MobileCheck16: CarbonIconType;
export const MobileCheck20: CarbonIconType;
export const MobileCheck24: CarbonIconType;
export const MobileCheck32: CarbonIconType;
export const MobileDownload16: CarbonIconType;
export const MobileDownload20: CarbonIconType;
export const MobileDownload24: CarbonIconType;
export const MobileDownload32: CarbonIconType;
export const MobileLandscape16: CarbonIconType;
export const MobileLandscape20: CarbonIconType;
export const MobileLandscape24: CarbonIconType;
export const MobileLandscape32: CarbonIconType;
export const Model16: CarbonIconType;
export const Model20: CarbonIconType;
export const Model24: CarbonIconType;
export const Model32: CarbonIconType;
export const ModelBuilder16: CarbonIconType;
export const ModelBuilder20: CarbonIconType;
export const ModelBuilder24: CarbonIconType;
export const ModelBuilder32: CarbonIconType;
export const ModelReference16: CarbonIconType;
export const ModelReference20: CarbonIconType;
export const ModelReference24: CarbonIconType;
export const ModelReference32: CarbonIconType;
export const Money16: CarbonIconType;
export const Money20: CarbonIconType;
export const Money24: CarbonIconType;
export const Money32: CarbonIconType;
export const Monument16: CarbonIconType;
export const Monument20: CarbonIconType;
export const Monument24: CarbonIconType;
export const Monument32: CarbonIconType;
export const Moon16: CarbonIconType;
export const Moon20: CarbonIconType;
export const Moon24: CarbonIconType;
export const Moon32: CarbonIconType;
export const MostlyCloudy16: CarbonIconType;
export const MostlyCloudy20: CarbonIconType;
export const MostlyCloudy24: CarbonIconType;
export const MostlyCloudy32: CarbonIconType;
export const MostlyCloudyNight16: CarbonIconType;
export const MostlyCloudyNight20: CarbonIconType;
export const MostlyCloudyNight24: CarbonIconType;
export const MostlyCloudyNight32: CarbonIconType;
export const Mountain16: CarbonIconType;
export const Mountain20: CarbonIconType;
export const Mountain24: CarbonIconType;
export const Mountain32: CarbonIconType;
export const Mov16: CarbonIconType;
export const Mov20: CarbonIconType;
export const Mov24: CarbonIconType;
export const Mov32: CarbonIconType;
export const Move16: CarbonIconType;
export const Move20: CarbonIconType;
export const Move24: CarbonIconType;
export const Move32: CarbonIconType;
export const Movement16: CarbonIconType;
export const Movement20: CarbonIconType;
export const Movement24: CarbonIconType;
export const Movement32: CarbonIconType;
export const Mp316: CarbonIconType;
export const Mp320: CarbonIconType;
export const Mp324: CarbonIconType;
export const Mp332: CarbonIconType;
export const Mp416: CarbonIconType;
export const Mp420: CarbonIconType;
export const Mp424: CarbonIconType;
export const Mp432: CarbonIconType;
export const Mpeg16: CarbonIconType;
export const Mpeg20: CarbonIconType;
export const Mpeg24: CarbonIconType;
export const Mpeg32: CarbonIconType;
export const Mpg216: CarbonIconType;
export const Mpg220: CarbonIconType;
export const Mpg224: CarbonIconType;
export const Mpg232: CarbonIconType;
export const Music16: CarbonIconType;
export const Music20: CarbonIconType;
export const Music24: CarbonIconType;
export const Music32: CarbonIconType;
export const Network_116: CarbonIconType;
export const Network_120: CarbonIconType;
export const Network_124: CarbonIconType;
export const Network_132: CarbonIconType;
export const Network_216: CarbonIconType;
export const Network_220: CarbonIconType;
export const Network_224: CarbonIconType;
export const Network_232: CarbonIconType;
export const Network_316: CarbonIconType;
export const Network_320: CarbonIconType;
export const Network_324: CarbonIconType;
export const Network_332: CarbonIconType;
export const Network_416: CarbonIconType;
export const Network_420: CarbonIconType;
export const Network_424: CarbonIconType;
export const Network_432: CarbonIconType;
export const NewTab16: CarbonIconType;
export const NewTab20: CarbonIconType;
export const NewTab24: CarbonIconType;
export const NewTab32: CarbonIconType;
export const NoImage16: CarbonIconType;
export const NoImage20: CarbonIconType;
export const NoImage24: CarbonIconType;
export const NoImage32: CarbonIconType;
export const NoTicket16: CarbonIconType;
export const NoTicket20: CarbonIconType;
export const NoTicket24: CarbonIconType;
export const NoTicket32: CarbonIconType;
export const Nominal16: CarbonIconType;
export const Nominal20: CarbonIconType;
export const Nominal24: CarbonIconType;
export const Nominal32: CarbonIconType;
export const NoodleBowl16: CarbonIconType;
export const NoodleBowl20: CarbonIconType;
export const NoodleBowl24: CarbonIconType;
export const NoodleBowl32: CarbonIconType;
export const NotAvailable16: CarbonIconType;
export const NotAvailable20: CarbonIconType;
export const NotAvailable24: CarbonIconType;
export const NotAvailable32: CarbonIconType;
export const NotSent16: CarbonIconType;
export const NotSent20: CarbonIconType;
export const NotSent24: CarbonIconType;
export const NotSent32: CarbonIconType;
export const NotSentFilled16: CarbonIconType;
export const NotSentFilled20: CarbonIconType;
export const NotSentFilled24: CarbonIconType;
export const NotSentFilled32: CarbonIconType;
export const Notebook16: CarbonIconType;
export const Notebook20: CarbonIconType;
export const Notebook24: CarbonIconType;
export const Notebook32: CarbonIconType;
export const NotebookReference16: CarbonIconType;
export const NotebookReference20: CarbonIconType;
export const NotebookReference24: CarbonIconType;
export const NotebookReference32: CarbonIconType;
export const Notification16: CarbonIconType;
export const Notification20: CarbonIconType;
export const Notification24: CarbonIconType;
export const Notification32: CarbonIconType;
export const NotificationFilled16: CarbonIconType;
export const NotificationFilled20: CarbonIconType;
export const NotificationFilled24: CarbonIconType;
export const NotificationFilled32: CarbonIconType;
export const NotificationNew16: CarbonIconType;
export const NotificationNew20: CarbonIconType;
export const NotificationNew24: CarbonIconType;
export const NotificationNew32: CarbonIconType;
export const NotificationOff16: CarbonIconType;
export const NotificationOff20: CarbonIconType;
export const NotificationOff24: CarbonIconType;
export const NotificationOff32: CarbonIconType;
export const NotificationOffFilled16: CarbonIconType;
export const NotificationOffFilled20: CarbonIconType;
export const NotificationOffFilled24: CarbonIconType;
export const NotificationOffFilled32: CarbonIconType;
export const NumberSmall_016: CarbonIconType;
export const NumberSmall_020: CarbonIconType;
export const NumberSmall_024: CarbonIconType;
export const NumberSmall_032: CarbonIconType;
export const NumberSmall_116: CarbonIconType;
export const NumberSmall_120: CarbonIconType;
export const NumberSmall_124: CarbonIconType;
export const NumberSmall_132: CarbonIconType;
export const NumberSmall_216: CarbonIconType;
export const NumberSmall_220: CarbonIconType;
export const NumberSmall_224: CarbonIconType;
export const NumberSmall_232: CarbonIconType;
export const NumberSmall_316: CarbonIconType;
export const NumberSmall_320: CarbonIconType;
export const NumberSmall_324: CarbonIconType;
export const NumberSmall_332: CarbonIconType;
export const NumberSmall_416: CarbonIconType;
export const NumberSmall_420: CarbonIconType;
export const NumberSmall_424: CarbonIconType;
export const NumberSmall_432: CarbonIconType;
export const NumberSmall_516: CarbonIconType;
export const NumberSmall_520: CarbonIconType;
export const NumberSmall_524: CarbonIconType;
export const NumberSmall_532: CarbonIconType;
export const NumberSmall_616: CarbonIconType;
export const NumberSmall_620: CarbonIconType;
export const NumberSmall_624: CarbonIconType;
export const NumberSmall_632: CarbonIconType;
export const NumberSmall_716: CarbonIconType;
export const NumberSmall_720: CarbonIconType;
export const NumberSmall_724: CarbonIconType;
export const NumberSmall_732: CarbonIconType;
export const NumberSmall_816: CarbonIconType;
export const NumberSmall_820: CarbonIconType;
export const NumberSmall_824: CarbonIconType;
export const NumberSmall_832: CarbonIconType;
export const NumberSmall_916: CarbonIconType;
export const NumberSmall_920: CarbonIconType;
export const NumberSmall_924: CarbonIconType;
export const NumberSmall_932: CarbonIconType;
export const Number_016: CarbonIconType;
export const Number_020: CarbonIconType;
export const Number_024: CarbonIconType;
export const Number_032: CarbonIconType;
export const Number_116: CarbonIconType;
export const Number_120: CarbonIconType;
export const Number_124: CarbonIconType;
export const Number_132: CarbonIconType;
export const Number_216: CarbonIconType;
export const Number_220: CarbonIconType;
export const Number_224: CarbonIconType;
export const Number_232: CarbonIconType;
export const Number_316: CarbonIconType;
export const Number_320: CarbonIconType;
export const Number_324: CarbonIconType;
export const Number_332: CarbonIconType;
export const Number_416: CarbonIconType;
export const Number_420: CarbonIconType;
export const Number_424: CarbonIconType;
export const Number_432: CarbonIconType;
export const Number_516: CarbonIconType;
export const Number_520: CarbonIconType;
export const Number_524: CarbonIconType;
export const Number_532: CarbonIconType;
export const Number_616: CarbonIconType;
export const Number_620: CarbonIconType;
export const Number_624: CarbonIconType;
export const Number_632: CarbonIconType;
export const Number_716: CarbonIconType;
export const Number_720: CarbonIconType;
export const Number_724: CarbonIconType;
export const Number_732: CarbonIconType;
export const Number_816: CarbonIconType;
export const Number_820: CarbonIconType;
export const Number_824: CarbonIconType;
export const Number_832: CarbonIconType;
export const Number_916: CarbonIconType;
export const Number_920: CarbonIconType;
export const Number_924: CarbonIconType;
export const Number_932: CarbonIconType;
export const Omega16: CarbonIconType;
export const Omega20: CarbonIconType;
export const Omega24: CarbonIconType;
export const Omega32: CarbonIconType;
export const Opacity16: CarbonIconType;
export const Opacity20: CarbonIconType;
export const Opacity24: CarbonIconType;
export const Opacity32: CarbonIconType;
export const OpenPanelBottom16: CarbonIconType;
export const OpenPanelBottom20: CarbonIconType;
export const OpenPanelBottom24: CarbonIconType;
export const OpenPanelBottom32: CarbonIconType;
export const OpenPanelFilledBottom16: CarbonIconType;
export const OpenPanelFilledBottom20: CarbonIconType;
export const OpenPanelFilledBottom24: CarbonIconType;
export const OpenPanelFilledBottom32: CarbonIconType;
export const OpenPanelFilledLeft16: CarbonIconType;
export const OpenPanelFilledLeft20: CarbonIconType;
export const OpenPanelFilledLeft24: CarbonIconType;
export const OpenPanelFilledLeft32: CarbonIconType;
export const OpenPanelFilledRight16: CarbonIconType;
export const OpenPanelFilledRight20: CarbonIconType;
export const OpenPanelFilledRight24: CarbonIconType;
export const OpenPanelFilledRight32: CarbonIconType;
export const OpenPanelFilledTop16: CarbonIconType;
export const OpenPanelFilledTop20: CarbonIconType;
export const OpenPanelFilledTop24: CarbonIconType;
export const OpenPanelFilledTop32: CarbonIconType;
export const OpenPanelLeft16: CarbonIconType;
export const OpenPanelLeft20: CarbonIconType;
export const OpenPanelLeft24: CarbonIconType;
export const OpenPanelLeft32: CarbonIconType;
export const OpenPanelRight16: CarbonIconType;
export const OpenPanelRight20: CarbonIconType;
export const OpenPanelRight24: CarbonIconType;
export const OpenPanelRight32: CarbonIconType;
export const OpenPanelTop16: CarbonIconType;
export const OpenPanelTop20: CarbonIconType;
export const OpenPanelTop24: CarbonIconType;
export const OpenPanelTop32: CarbonIconType;
export const OperationsField16: CarbonIconType;
export const OperationsField20: CarbonIconType;
export const OperationsField24: CarbonIconType;
export const OperationsField32: CarbonIconType;
export const OperationsRecord16: CarbonIconType;
export const OperationsRecord20: CarbonIconType;
export const OperationsRecord24: CarbonIconType;
export const OperationsRecord32: CarbonIconType;
export const Ordinal16: CarbonIconType;
export const Ordinal20: CarbonIconType;
export const Ordinal24: CarbonIconType;
export const Ordinal32: CarbonIconType;
export const OverflowMenuHorizontal16: CarbonIconType;
export const OverflowMenuHorizontal20: CarbonIconType;
export const OverflowMenuHorizontal24: CarbonIconType;
export const OverflowMenuHorizontal32: CarbonIconType;
export const OverflowMenuVertical16: CarbonIconType;
export const OverflowMenuVertical20: CarbonIconType;
export const OverflowMenuVertical24: CarbonIconType;
export const OverflowMenuVertical32: CarbonIconType;
export const Package16: CarbonIconType;
export const Package20: CarbonIconType;
export const Package24: CarbonIconType;
export const Package32: CarbonIconType;
export const PageFirst16: CarbonIconType;
export const PageFirst20: CarbonIconType;
export const PageFirst24: CarbonIconType;
export const PageFirst32: CarbonIconType;
export const PageLast16: CarbonIconType;
export const PageLast20: CarbonIconType;
export const PageLast24: CarbonIconType;
export const PageLast32: CarbonIconType;
export const PaintBrush16: CarbonIconType;
export const PaintBrush20: CarbonIconType;
export const PaintBrush24: CarbonIconType;
export const PaintBrush32: CarbonIconType;
export const PaintBrushAlt16: CarbonIconType;
export const PaintBrushAlt20: CarbonIconType;
export const PaintBrushAlt24: CarbonIconType;
export const PaintBrushAlt32: CarbonIconType;
export const PanelExpansion16: CarbonIconType;
export const PanelExpansion20: CarbonIconType;
export const PanelExpansion24: CarbonIconType;
export const PanelExpansion32: CarbonIconType;
export const Paragraph16: CarbonIconType;
export const Paragraph20: CarbonIconType;
export const Paragraph24: CarbonIconType;
export const Paragraph32: CarbonIconType;
export const ParentChild16: CarbonIconType;
export const ParentChild20: CarbonIconType;
export const ParentChild24: CarbonIconType;
export const ParentChild32: CarbonIconType;
export const PartlyCloudy16: CarbonIconType;
export const PartlyCloudy20: CarbonIconType;
export const PartlyCloudy24: CarbonIconType;
export const PartlyCloudy32: CarbonIconType;
export const PartlyCloudyNight16: CarbonIconType;
export const PartlyCloudyNight20: CarbonIconType;
export const PartlyCloudyNight24: CarbonIconType;
export const PartlyCloudyNight32: CarbonIconType;
export const Partnership16: CarbonIconType;
export const Partnership20: CarbonIconType;
export const Partnership24: CarbonIconType;
export const Partnership32: CarbonIconType;
export const Password16: CarbonIconType;
export const Password20: CarbonIconType;
export const Password24: CarbonIconType;
export const Password32: CarbonIconType;
export const Paste16: CarbonIconType;
export const Paste20: CarbonIconType;
export const Paste24: CarbonIconType;
export const Paste32: CarbonIconType;
export const Pause16: CarbonIconType;
export const Pause20: CarbonIconType;
export const Pause24: CarbonIconType;
export const Pause32: CarbonIconType;
export const PauseFilled16: CarbonIconType;
export const PauseFilled20: CarbonIconType;
export const PauseFilled24: CarbonIconType;
export const PauseFilled32: CarbonIconType;
export const PauseOutline16: CarbonIconType;
export const PauseOutline20: CarbonIconType;
export const PauseOutline24: CarbonIconType;
export const PauseOutline32: CarbonIconType;
export const PauseOutlineFilled16: CarbonIconType;
export const PauseOutlineFilled20: CarbonIconType;
export const PauseOutlineFilled24: CarbonIconType;
export const PauseOutlineFilled32: CarbonIconType;
export const Pdf16: CarbonIconType;
export const Pdf20: CarbonIconType;
export const Pdf24: CarbonIconType;
export const Pdf32: CarbonIconType;
export const Pedestrian16: CarbonIconType;
export const Pedestrian20: CarbonIconType;
export const Pedestrian24: CarbonIconType;
export const Pedestrian32: CarbonIconType;
export const PedestrianChild16: CarbonIconType;
export const PedestrianChild20: CarbonIconType;
export const PedestrianChild24: CarbonIconType;
export const PedestrianChild32: CarbonIconType;
export const Percentage16: CarbonIconType;
export const Percentage20: CarbonIconType;
export const Percentage24: CarbonIconType;
export const Percentage32: CarbonIconType;
export const PercentageFilled16: CarbonIconType;
export const PercentageFilled20: CarbonIconType;
export const PercentageFilled24: CarbonIconType;
export const PercentageFilled32: CarbonIconType;
export const Person16: CarbonIconType;
export const Person20: CarbonIconType;
export const Person24: CarbonIconType;
export const Person32: CarbonIconType;
export const PersonFavorite16: CarbonIconType;
export const PersonFavorite20: CarbonIconType;
export const PersonFavorite24: CarbonIconType;
export const PersonFavorite32: CarbonIconType;
export const Phone16: CarbonIconType;
export const Phone20: CarbonIconType;
export const Phone24: CarbonIconType;
export const Phone32: CarbonIconType;
export const PhoneFilled16: CarbonIconType;
export const PhoneFilled20: CarbonIconType;
export const PhoneFilled24: CarbonIconType;
export const PhoneFilled32: CarbonIconType;
export const PhoneOff16: CarbonIconType;
export const PhoneOff20: CarbonIconType;
export const PhoneOff24: CarbonIconType;
export const PhoneOff32: CarbonIconType;
export const PhoneOffFilled16: CarbonIconType;
export const PhoneOffFilled20: CarbonIconType;
export const PhoneOffFilled24: CarbonIconType;
export const PhoneOffFilled32: CarbonIconType;
export const PhraseSentiment16: CarbonIconType;
export const PhraseSentiment20: CarbonIconType;
export const PhraseSentiment24: CarbonIconType;
export const PhraseSentiment32: CarbonIconType;
export const PicnicArea16: CarbonIconType;
export const PicnicArea20: CarbonIconType;
export const PicnicArea24: CarbonIconType;
export const PicnicArea32: CarbonIconType;
export const Pills16: CarbonIconType;
export const Pills20: CarbonIconType;
export const Pills24: CarbonIconType;
export const Pills32: CarbonIconType;
export const PillsAdd16: CarbonIconType;
export const PillsAdd20: CarbonIconType;
export const PillsAdd24: CarbonIconType;
export const PillsAdd32: CarbonIconType;
export const PillsSubtract16: CarbonIconType;
export const PillsSubtract20: CarbonIconType;
export const PillsSubtract24: CarbonIconType;
export const PillsSubtract32: CarbonIconType;
export const Pin16: CarbonIconType;
export const Pin20: CarbonIconType;
export const Pin24: CarbonIconType;
export const Pin32: CarbonIconType;
export const Plane16: CarbonIconType;
export const Plane20: CarbonIconType;
export const Plane24: CarbonIconType;
export const Plane32: CarbonIconType;
export const Play16: CarbonIconType;
export const Play20: CarbonIconType;
export const Play24: CarbonIconType;
export const Play32: CarbonIconType;
export const PlayFilled16: CarbonIconType;
export const PlayFilled20: CarbonIconType;
export const PlayFilled24: CarbonIconType;
export const PlayFilled32: CarbonIconType;
export const PlayFilledAlt16: CarbonIconType;
export const PlayFilledAlt20: CarbonIconType;
export const PlayFilledAlt24: CarbonIconType;
export const PlayFilledAlt32: CarbonIconType;
export const PlayOutline16: CarbonIconType;
export const PlayOutline20: CarbonIconType;
export const PlayOutline24: CarbonIconType;
export const PlayOutline32: CarbonIconType;
export const PlayOutlineFilled16: CarbonIconType;
export const PlayOutlineFilled20: CarbonIconType;
export const PlayOutlineFilled24: CarbonIconType;
export const PlayOutlineFilled32: CarbonIconType;
export const Playlist16: CarbonIconType;
export const Playlist20: CarbonIconType;
export const Playlist24: CarbonIconType;
export const Playlist32: CarbonIconType;
export const Plug16: CarbonIconType;
export const Plug20: CarbonIconType;
export const Plug24: CarbonIconType;
export const Plug32: CarbonIconType;
export const PlugFilled16: CarbonIconType;
export const PlugFilled20: CarbonIconType;
export const PlugFilled24: CarbonIconType;
export const PlugFilled32: CarbonIconType;
export const Png16: CarbonIconType;
export const Png20: CarbonIconType;
export const Png24: CarbonIconType;
export const Png32: CarbonIconType;
export const Police16: CarbonIconType;
export const Police20: CarbonIconType;
export const Police24: CarbonIconType;
export const Police32: CarbonIconType;
export const Policy16: CarbonIconType;
export const Policy20: CarbonIconType;
export const Policy24: CarbonIconType;
export const Policy32: CarbonIconType;
export const Popup16: CarbonIconType;
export const Popup20: CarbonIconType;
export const Popup24: CarbonIconType;
export const Popup32: CarbonIconType;
export const Portfolio16: CarbonIconType;
export const Portfolio20: CarbonIconType;
export const Portfolio24: CarbonIconType;
export const Portfolio32: CarbonIconType;
export const Power16: CarbonIconType;
export const Power20: CarbonIconType;
export const Power24: CarbonIconType;
export const Power32: CarbonIconType;
export const Ppt16: CarbonIconType;
export const Ppt20: CarbonIconType;
export const Ppt24: CarbonIconType;
export const Ppt32: CarbonIconType;
export const PresentationFile16: CarbonIconType;
export const PresentationFile20: CarbonIconType;
export const PresentationFile24: CarbonIconType;
export const PresentationFile32: CarbonIconType;
export const Pressure16: CarbonIconType;
export const Pressure20: CarbonIconType;
export const Pressure24: CarbonIconType;
export const Pressure32: CarbonIconType;
export const PressureFilled16: CarbonIconType;
export const PressureFilled20: CarbonIconType;
export const PressureFilled24: CarbonIconType;
export const PressureFilled32: CarbonIconType;
export const Printer16: CarbonIconType;
export const Printer20: CarbonIconType;
export const Printer24: CarbonIconType;
export const Printer32: CarbonIconType;
export const Product16: CarbonIconType;
export const Product20: CarbonIconType;
export const Product24: CarbonIconType;
export const Product32: CarbonIconType;
export const Purchase16: CarbonIconType;
export const Purchase20: CarbonIconType;
export const Purchase24: CarbonIconType;
export const Purchase32: CarbonIconType;
export const QBarrier16: CarbonIconType;
export const QBarrier20: CarbonIconType;
export const QBarrier24: CarbonIconType;
export const QBarrier32: CarbonIconType;
export const QBlochSphere16: CarbonIconType;
export const QBlochSphere20: CarbonIconType;
export const QBlochSphere24: CarbonIconType;
export const QBlochSphere32: CarbonIconType;
export const QCU116: CarbonIconType;
export const QCU120: CarbonIconType;
export const QCU124: CarbonIconType;
export const QCU132: CarbonIconType;
export const QCU316: CarbonIconType;
export const QCU320: CarbonIconType;
export const QCU324: CarbonIconType;
export const QCU332: CarbonIconType;
export const QCY16: CarbonIconType;
export const QCY20: CarbonIconType;
export const QCY24: CarbonIconType;
export const QCY32: CarbonIconType;
export const QCZ16: CarbonIconType;
export const QCZ20: CarbonIconType;
export const QCZ24: CarbonIconType;
export const QCZ32: CarbonIconType;
export const QCcX16: CarbonIconType;
export const QCcX20: CarbonIconType;
export const QCcX24: CarbonIconType;
export const QCcX32: CarbonIconType;
export const QCircuitComposer16: CarbonIconType;
export const QCircuitComposer20: CarbonIconType;
export const QCircuitComposer24: CarbonIconType;
export const QCircuitComposer32: CarbonIconType;
export const QComposerEdit16: CarbonIconType;
export const QComposerEdit20: CarbonIconType;
export const QComposerEdit24: CarbonIconType;
export const QComposerEdit32: CarbonIconType;
export const QH16: CarbonIconType;
export const QH20: CarbonIconType;
export const QH24: CarbonIconType;
export const QH32: CarbonIconType;
export const QHintonPlot16: CarbonIconType;
export const QHintonPlot20: CarbonIconType;
export const QHintonPlot24: CarbonIconType;
export const QHintonPlot32: CarbonIconType;
export const QID16: CarbonIconType;
export const QID20: CarbonIconType;
export const QID24: CarbonIconType;
export const QID32: CarbonIconType;
export const QMatrix16: CarbonIconType;
export const QMatrix20: CarbonIconType;
export const QMatrix24: CarbonIconType;
export const QMatrix32: CarbonIconType;
export const QOperation16: CarbonIconType;
export const QOperation20: CarbonIconType;
export const QOperation24: CarbonIconType;
export const QOperation32: CarbonIconType;
export const QOperationGauge16: CarbonIconType;
export const QOperationGauge20: CarbonIconType;
export const QOperationGauge24: CarbonIconType;
export const QOperationGauge32: CarbonIconType;
export const QOperationIf16: CarbonIconType;
export const QOperationIf20: CarbonIconType;
export const QOperationIf24: CarbonIconType;
export const QOperationIf32: CarbonIconType;
export const QS16: CarbonIconType;
export const QS20: CarbonIconType;
export const QS24: CarbonIconType;
export const QS32: CarbonIconType;
export const QSAlt16: CarbonIconType;
export const QSAlt20: CarbonIconType;
export const QSAlt24: CarbonIconType;
export const QSAlt32: CarbonIconType;
export const QT16: CarbonIconType;
export const QT20: CarbonIconType;
export const QT24: CarbonIconType;
export const QT32: CarbonIconType;
export const QTAlt16: CarbonIconType;
export const QTAlt20: CarbonIconType;
export const QTAlt24: CarbonIconType;
export const QTAlt32: CarbonIconType;
export const QU116: CarbonIconType;
export const QU120: CarbonIconType;
export const QU124: CarbonIconType;
export const QU132: CarbonIconType;
export const QU216: CarbonIconType;
export const QU220: CarbonIconType;
export const QU224: CarbonIconType;
export const QU232: CarbonIconType;
export const QU316: CarbonIconType;
export const QU320: CarbonIconType;
export const QU324: CarbonIconType;
export const QU332: CarbonIconType;
export const QX16: CarbonIconType;
export const QX20: CarbonIconType;
export const QX24: CarbonIconType;
export const QX32: CarbonIconType;
export const QY16: CarbonIconType;
export const QY20: CarbonIconType;
export const QY24: CarbonIconType;
export const QY32: CarbonIconType;
export const QZ16: CarbonIconType;
export const QZ20: CarbonIconType;
export const QZ24: CarbonIconType;
export const QZ32: CarbonIconType;
export const QqPlot16: CarbonIconType;
export const QqPlot20: CarbonIconType;
export const QqPlot24: CarbonIconType;
export const QqPlot32: CarbonIconType;
export const QrCode16: CarbonIconType;
export const QrCode20: CarbonIconType;
export const QrCode24: CarbonIconType;
export const QrCode32: CarbonIconType;
export const QueryQueue16: CarbonIconType;
export const QueryQueue20: CarbonIconType;
export const QueryQueue24: CarbonIconType;
export const QueryQueue32: CarbonIconType;
export const Quotes16: CarbonIconType;
export const Quotes20: CarbonIconType;
export const Quotes24: CarbonIconType;
export const Quotes32: CarbonIconType;
export const Radio16: CarbonIconType;
export const Radio20: CarbonIconType;
export const Radio24: CarbonIconType;
export const Radio32: CarbonIconType;
export const RadioButton16: CarbonIconType;
export const RadioButton20: CarbonIconType;
export const RadioButton24: CarbonIconType;
export const RadioButton32: CarbonIconType;
export const RadioButtonChecked16: CarbonIconType;
export const RadioButtonChecked20: CarbonIconType;
export const RadioButtonChecked24: CarbonIconType;
export const RadioButtonChecked32: CarbonIconType;
export const Rain16: CarbonIconType;
export const Rain20: CarbonIconType;
export const Rain24: CarbonIconType;
export const Rain32: CarbonIconType;
export const RainDrizzle16: CarbonIconType;
export const RainDrizzle20: CarbonIconType;
export const RainDrizzle24: CarbonIconType;
export const RainDrizzle32: CarbonIconType;
export const RainDrop16: CarbonIconType;
export const RainDrop20: CarbonIconType;
export const RainDrop24: CarbonIconType;
export const RainDrop32: CarbonIconType;
export const RainHeavy16: CarbonIconType;
export const RainHeavy20: CarbonIconType;
export const RainHeavy24: CarbonIconType;
export const RainHeavy32: CarbonIconType;
export const RainScattered16: CarbonIconType;
export const RainScattered20: CarbonIconType;
export const RainScattered24: CarbonIconType;
export const RainScattered32: CarbonIconType;
export const RainScatteredNight16: CarbonIconType;
export const RainScatteredNight20: CarbonIconType;
export const RainScatteredNight24: CarbonIconType;
export const RainScatteredNight32: CarbonIconType;
export const Raw16: CarbonIconType;
export const Raw20: CarbonIconType;
export const Raw24: CarbonIconType;
export const Raw32: CarbonIconType;
export const Receipt16: CarbonIconType;
export const Receipt20: CarbonIconType;
export const Receipt24: CarbonIconType;
export const Receipt32: CarbonIconType;
export const RecentlyViewed16: CarbonIconType;
export const RecentlyViewed20: CarbonIconType;
export const RecentlyViewed24: CarbonIconType;
export const RecentlyViewed32: CarbonIconType;
export const Recommend16: CarbonIconType;
export const Recommend20: CarbonIconType;
export const Recommend24: CarbonIconType;
export const Recommend32: CarbonIconType;
export const Recording16: CarbonIconType;
export const Recording20: CarbonIconType;
export const Recording24: CarbonIconType;
export const Recording32: CarbonIconType;
export const RecordingFilled16: CarbonIconType;
export const RecordingFilled20: CarbonIconType;
export const RecordingFilled24: CarbonIconType;
export const RecordingFilled32: CarbonIconType;
export const RecordingFilledAlt16: CarbonIconType;
export const RecordingFilledAlt20: CarbonIconType;
export const RecordingFilledAlt24: CarbonIconType;
export const RecordingFilledAlt32: CarbonIconType;
export const Redo16: CarbonIconType;
export const Redo20: CarbonIconType;
export const Redo24: CarbonIconType;
export const Redo32: CarbonIconType;
export const Reminder16: CarbonIconType;
export const Reminder20: CarbonIconType;
export const Reminder24: CarbonIconType;
export const Reminder32: CarbonIconType;
export const ReminderMedical16: CarbonIconType;
export const ReminderMedical20: CarbonIconType;
export const ReminderMedical24: CarbonIconType;
export const ReminderMedical32: CarbonIconType;
export const Renew16: CarbonIconType;
export const Renew20: CarbonIconType;
export const Renew24: CarbonIconType;
export const Renew32: CarbonIconType;
export const Repeat16: CarbonIconType;
export const Repeat20: CarbonIconType;
export const Repeat24: CarbonIconType;
export const Repeat32: CarbonIconType;
export const RepeatOne16: CarbonIconType;
export const RepeatOne20: CarbonIconType;
export const RepeatOne24: CarbonIconType;
export const RepeatOne32: CarbonIconType;
export const Reply16: CarbonIconType;
export const Reply20: CarbonIconType;
export const Reply24: CarbonIconType;
export const Reply32: CarbonIconType;
export const Report16: CarbonIconType;
export const Report20: CarbonIconType;
export const Report24: CarbonIconType;
export const Report32: CarbonIconType;
export const ReportData16: CarbonIconType;
export const ReportData20: CarbonIconType;
export const ReportData24: CarbonIconType;
export const ReportData32: CarbonIconType;
export const RequestQuote16: CarbonIconType;
export const RequestQuote20: CarbonIconType;
export const RequestQuote24: CarbonIconType;
export const RequestQuote32: CarbonIconType;
export const ResearchBlochSphere16: CarbonIconType;
export const ResearchBlochSphere20: CarbonIconType;
export const ResearchBlochSphere24: CarbonIconType;
export const ResearchBlochSphere32: CarbonIconType;
export const ResearchHintonPlot16: CarbonIconType;
export const ResearchHintonPlot20: CarbonIconType;
export const ResearchHintonPlot24: CarbonIconType;
export const ResearchHintonPlot32: CarbonIconType;
export const ResearchMatrix16: CarbonIconType;
export const ResearchMatrix20: CarbonIconType;
export const ResearchMatrix24: CarbonIconType;
export const ResearchMatrix32: CarbonIconType;
export const Reset16: CarbonIconType;
export const Reset20: CarbonIconType;
export const Reset24: CarbonIconType;
export const Reset32: CarbonIconType;
export const ResetAlt16: CarbonIconType;
export const ResetAlt20: CarbonIconType;
export const ResetAlt24: CarbonIconType;
export const ResetAlt32: CarbonIconType;
export const Restart16: CarbonIconType;
export const Restart20: CarbonIconType;
export const Restart24: CarbonIconType;
export const Restart32: CarbonIconType;
export const Restaurant16: CarbonIconType;
export const Restaurant20: CarbonIconType;
export const Restaurant24: CarbonIconType;
export const Restaurant32: CarbonIconType;
export const RestaurantFine16: CarbonIconType;
export const RestaurantFine20: CarbonIconType;
export const RestaurantFine24: CarbonIconType;
export const RestaurantFine32: CarbonIconType;
export const Rewind_1016: CarbonIconType;
export const Rewind_1020: CarbonIconType;
export const Rewind_1024: CarbonIconType;
export const Rewind_1032: CarbonIconType;
export const Rewind_3016: CarbonIconType;
export const Rewind_3020: CarbonIconType;
export const Rewind_3024: CarbonIconType;
export const Rewind_3032: CarbonIconType;
export const Rewind_516: CarbonIconType;
export const Rewind_520: CarbonIconType;
export const Rewind_524: CarbonIconType;
export const Rewind_532: CarbonIconType;
export const Roadmap16: CarbonIconType;
export const Roadmap20: CarbonIconType;
export const Roadmap24: CarbonIconType;
export const Roadmap32: CarbonIconType;
export const Rocket16: CarbonIconType;
export const Rocket20: CarbonIconType;
export const Rocket24: CarbonIconType;
export const Rocket32: CarbonIconType;
export const Rotate16: CarbonIconType;
export const Rotate20: CarbonIconType;
export const Rotate24: CarbonIconType;
export const Rotate32: CarbonIconType;
export const RotateClockwise16: CarbonIconType;
export const RotateClockwise20: CarbonIconType;
export const RotateClockwise24: CarbonIconType;
export const RotateClockwise32: CarbonIconType;
export const RotateClockwiseAlt16: CarbonIconType;
export const RotateClockwiseAlt20: CarbonIconType;
export const RotateClockwiseAlt24: CarbonIconType;
export const RotateClockwiseAlt32: CarbonIconType;
export const RotateClockwiseAltFilled16: CarbonIconType;
export const RotateClockwiseAltFilled20: CarbonIconType;
export const RotateClockwiseAltFilled24: CarbonIconType;
export const RotateClockwiseAltFilled32: CarbonIconType;
export const RotateClockwiseFilled16: CarbonIconType;
export const RotateClockwiseFilled20: CarbonIconType;
export const RotateClockwiseFilled24: CarbonIconType;
export const RotateClockwiseFilled32: CarbonIconType;
export const RotateCounterclockwise16: CarbonIconType;
export const RotateCounterclockwise20: CarbonIconType;
export const RotateCounterclockwise24: CarbonIconType;
export const RotateCounterclockwise32: CarbonIconType;
export const RotateCounterclockwiseAlt16: CarbonIconType;
export const RotateCounterclockwiseAlt20: CarbonIconType;
export const RotateCounterclockwiseAlt24: CarbonIconType;
export const RotateCounterclockwiseAlt32: CarbonIconType;
export const RotateCounterclockwiseAltFilled16: CarbonIconType;
export const RotateCounterclockwiseAltFilled20: CarbonIconType;
export const RotateCounterclockwiseAltFilled24: CarbonIconType;
export const RotateCounterclockwiseAltFilled32: CarbonIconType;
export const RotateCounterclockwiseFilled16: CarbonIconType;
export const RotateCounterclockwiseFilled20: CarbonIconType;
export const RotateCounterclockwiseFilled24: CarbonIconType;
export const RotateCounterclockwiseFilled32: CarbonIconType;
export const Row16: CarbonIconType;
export const Row20: CarbonIconType;
export const Row24: CarbonIconType;
export const Row32: CarbonIconType;
export const RowCollapse16: CarbonIconType;
export const RowCollapse20: CarbonIconType;
export const RowCollapse24: CarbonIconType;
export const RowCollapse32: CarbonIconType;
export const RowExpand16: CarbonIconType;
export const RowExpand20: CarbonIconType;
export const RowExpand24: CarbonIconType;
export const RowExpand32: CarbonIconType;
export const Rss16: CarbonIconType;
export const Rss20: CarbonIconType;
export const Rss24: CarbonIconType;
export const Rss32: CarbonIconType;
export const Rule16: CarbonIconType;
export const Rule20: CarbonIconType;
export const Rule24: CarbonIconType;
export const Rule32: CarbonIconType;
export const Ruler16: CarbonIconType;
export const Ruler20: CarbonIconType;
export const Ruler24: CarbonIconType;
export const Ruler32: CarbonIconType;
export const RulerAlt16: CarbonIconType;
export const RulerAlt20: CarbonIconType;
export const RulerAlt24: CarbonIconType;
export const RulerAlt32: CarbonIconType;
export const Run16: CarbonIconType;
export const Run20: CarbonIconType;
export const Run24: CarbonIconType;
export const Run32: CarbonIconType;
export const Save16: CarbonIconType;
export const Save20: CarbonIconType;
export const Save24: CarbonIconType;
export const Save32: CarbonIconType;
export const SaveModel16: CarbonIconType;
export const SaveModel20: CarbonIconType;
export const SaveModel24: CarbonIconType;
export const SaveModel32: CarbonIconType;
export const Scale16: CarbonIconType;
export const Scale20: CarbonIconType;
export const Scale24: CarbonIconType;
export const Scale32: CarbonIconType;
export const Scalpel16: CarbonIconType;
export const Scalpel20: CarbonIconType;
export const Scalpel24: CarbonIconType;
export const Scalpel32: CarbonIconType;
export const Scan16: CarbonIconType;
export const Scan20: CarbonIconType;
export const Scan24: CarbonIconType;
export const Scan32: CarbonIconType;
export const ScatterMatrix16: CarbonIconType;
export const ScatterMatrix20: CarbonIconType;
export const ScatterMatrix24: CarbonIconType;
export const ScatterMatrix32: CarbonIconType;
export const Schematics16: CarbonIconType;
export const Schematics20: CarbonIconType;
export const Schematics24: CarbonIconType;
export const Schematics32: CarbonIconType;
export const Scooter16: CarbonIconType;
export const Scooter20: CarbonIconType;
export const Scooter24: CarbonIconType;
export const Scooter32: CarbonIconType;
export const ScooterFront16: CarbonIconType;
export const ScooterFront20: CarbonIconType;
export const ScooterFront24: CarbonIconType;
export const ScooterFront32: CarbonIconType;
export const Screen16: CarbonIconType;
export const Screen20: CarbonIconType;
export const Screen24: CarbonIconType;
export const Screen32: CarbonIconType;
export const ScreenOff16: CarbonIconType;
export const ScreenOff20: CarbonIconType;
export const ScreenOff24: CarbonIconType;
export const ScreenOff32: CarbonIconType;
export const Script16: CarbonIconType;
export const Script20: CarbonIconType;
export const Script24: CarbonIconType;
export const Script32: CarbonIconType;
export const Sdk16: CarbonIconType;
export const Sdk20: CarbonIconType;
export const Sdk24: CarbonIconType;
export const Sdk32: CarbonIconType;
export const Search16: CarbonIconType;
export const Search20: CarbonIconType;
export const Search24: CarbonIconType;
export const Search32: CarbonIconType;
export const Send16: CarbonIconType;
export const Send20: CarbonIconType;
export const Send24: CarbonIconType;
export const Send32: CarbonIconType;
export const SendAlt16: CarbonIconType;
export const SendAlt20: CarbonIconType;
export const SendAlt24: CarbonIconType;
export const SendAlt32: CarbonIconType;
export const SendAltFilled16: CarbonIconType;
export const SendAltFilled20: CarbonIconType;
export const SendAltFilled24: CarbonIconType;
export const SendAltFilled32: CarbonIconType;
export const SendFilled16: CarbonIconType;
export const SendFilled20: CarbonIconType;
export const SendFilled24: CarbonIconType;
export const SendFilled32: CarbonIconType;
export const ServiceDesk16: CarbonIconType;
export const ServiceDesk20: CarbonIconType;
export const ServiceDesk24: CarbonIconType;
export const ServiceDesk32: CarbonIconType;
export const Settings16: CarbonIconType;
export const Settings20: CarbonIconType;
export const Settings24: CarbonIconType;
export const Settings32: CarbonIconType;
export const SettingsAdjust16: CarbonIconType;
export const SettingsAdjust20: CarbonIconType;
export const SettingsAdjust24: CarbonIconType;
export const SettingsAdjust32: CarbonIconType;
export const Share16: CarbonIconType;
export const Share20: CarbonIconType;
export const Share24: CarbonIconType;
export const Share32: CarbonIconType;
export const ShareKnowledge16: CarbonIconType;
export const ShareKnowledge20: CarbonIconType;
export const ShareKnowledge24: CarbonIconType;
export const ShareKnowledge32: CarbonIconType;
export const ShoppingBag16: CarbonIconType;
export const ShoppingBag20: CarbonIconType;
export const ShoppingBag24: CarbonIconType;
export const ShoppingBag32: CarbonIconType;
export const ShoppingCart16: CarbonIconType;
export const ShoppingCart20: CarbonIconType;
export const ShoppingCart24: CarbonIconType;
export const ShoppingCart32: CarbonIconType;
export const ShoppingCatalog16: CarbonIconType;
export const ShoppingCatalog20: CarbonIconType;
export const ShoppingCatalog24: CarbonIconType;
export const ShoppingCatalog32: CarbonIconType;
export const ShrinkScreen16: CarbonIconType;
export const ShrinkScreen20: CarbonIconType;
export const ShrinkScreen24: CarbonIconType;
export const ShrinkScreen32: CarbonIconType;
export const ShrinkScreenFilled16: CarbonIconType;
export const ShrinkScreenFilled20: CarbonIconType;
export const ShrinkScreenFilled24: CarbonIconType;
export const ShrinkScreenFilled32: CarbonIconType;
export const Shuffle16: CarbonIconType;
export const Shuffle20: CarbonIconType;
export const Shuffle24: CarbonIconType;
export const Shuffle32: CarbonIconType;
export const Shuttle16: CarbonIconType;
export const Shuttle20: CarbonIconType;
export const Shuttle24: CarbonIconType;
export const Shuttle32: CarbonIconType;
export const Sigma16: CarbonIconType;
export const Sigma20: CarbonIconType;
export const Sigma24: CarbonIconType;
export const Sigma32: CarbonIconType;
export const SkillLevel16: CarbonIconType;
export const SkillLevel20: CarbonIconType;
export const SkillLevel24: CarbonIconType;
export const SkillLevel32: CarbonIconType;
export const SkillLevelAdvanced16: CarbonIconType;
export const SkillLevelAdvanced20: CarbonIconType;
export const SkillLevelAdvanced24: CarbonIconType;
export const SkillLevelAdvanced32: CarbonIconType;
export const SkillLevelBasic16: CarbonIconType;
export const SkillLevelBasic20: CarbonIconType;
export const SkillLevelBasic24: CarbonIconType;
export const SkillLevelBasic32: CarbonIconType;
export const SkillLevelIntermediate16: CarbonIconType;
export const SkillLevelIntermediate20: CarbonIconType;
export const SkillLevelIntermediate24: CarbonIconType;
export const SkillLevelIntermediate32: CarbonIconType;
export const SkipBack16: CarbonIconType;
export const SkipBack20: CarbonIconType;
export const SkipBack24: CarbonIconType;
export const SkipBack32: CarbonIconType;
export const SkipBackFilled16: CarbonIconType;
export const SkipBackFilled20: CarbonIconType;
export const SkipBackFilled24: CarbonIconType;
export const SkipBackFilled32: CarbonIconType;
export const SkipForward16: CarbonIconType;
export const SkipForward20: CarbonIconType;
export const SkipForward24: CarbonIconType;
export const SkipForward32: CarbonIconType;
export const SkipForwardFilled16: CarbonIconType;
export const SkipForwardFilled20: CarbonIconType;
export const SkipForwardFilled24: CarbonIconType;
export const SkipForwardFilled32: CarbonIconType;
export const Sleet16: CarbonIconType;
export const Sleet20: CarbonIconType;
export const Sleet24: CarbonIconType;
export const Sleet32: CarbonIconType;
export const Smell16: CarbonIconType;
export const Smell20: CarbonIconType;
export const Smell24: CarbonIconType;
export const Smell32: CarbonIconType;
export const Smoke16: CarbonIconType;
export const Smoke20: CarbonIconType;
export const Smoke24: CarbonIconType;
export const Smoke32: CarbonIconType;
export const Snooze16: CarbonIconType;
export const Snooze20: CarbonIconType;
export const Snooze24: CarbonIconType;
export const Snooze32: CarbonIconType;
export const Snow16: CarbonIconType;
export const Snow20: CarbonIconType;
export const Snow24: CarbonIconType;
export const Snow32: CarbonIconType;
export const SnowBlizzard16: CarbonIconType;
export const SnowBlizzard20: CarbonIconType;
export const SnowBlizzard24: CarbonIconType;
export const SnowBlizzard32: CarbonIconType;
export const SnowHeavy16: CarbonIconType;
export const SnowHeavy20: CarbonIconType;
export const SnowHeavy24: CarbonIconType;
export const SnowHeavy32: CarbonIconType;
export const SnowScattered16: CarbonIconType;
export const SnowScattered20: CarbonIconType;
export const SnowScattered24: CarbonIconType;
export const SnowScattered32: CarbonIconType;
export const SnowScatteredNight16: CarbonIconType;
export const SnowScatteredNight20: CarbonIconType;
export const SnowScatteredNight24: CarbonIconType;
export const SnowScatteredNight32: CarbonIconType;
export const Snowflake16: CarbonIconType;
export const Snowflake20: CarbonIconType;
export const Snowflake24: CarbonIconType;
export const Snowflake32: CarbonIconType;
export const Soccer16: CarbonIconType;
export const Soccer20: CarbonIconType;
export const Soccer24: CarbonIconType;
export const Soccer32: CarbonIconType;
export const SpellCheck16: CarbonIconType;
export const SpellCheck20: CarbonIconType;
export const SpellCheck24: CarbonIconType;
export const SpellCheck32: CarbonIconType;
export const Split16: CarbonIconType;
export const Split20: CarbonIconType;
export const Split24: CarbonIconType;
export const Split32: CarbonIconType;
export const SplitScreen16: CarbonIconType;
export const SplitScreen20: CarbonIconType;
export const SplitScreen24: CarbonIconType;
export const SplitScreen32: CarbonIconType;
export const SprayPaint16: CarbonIconType;
export const SprayPaint20: CarbonIconType;
export const SprayPaint24: CarbonIconType;
export const SprayPaint32: CarbonIconType;
export const Sprout16: CarbonIconType;
export const Sprout20: CarbonIconType;
export const Sprout24: CarbonIconType;
export const Sprout32: CarbonIconType;
export const Sql16: CarbonIconType;
export const Sql20: CarbonIconType;
export const Sql24: CarbonIconType;
export const Sql32: CarbonIconType;
export const Stamp16: CarbonIconType;
export const Stamp20: CarbonIconType;
export const Stamp24: CarbonIconType;
export const Stamp32: CarbonIconType;
export const Star16: CarbonIconType;
export const Star20: CarbonIconType;
export const Star24: CarbonIconType;
export const Star32: CarbonIconType;
export const StarFilled16: CarbonIconType;
export const StarFilled20: CarbonIconType;
export const StarFilled24: CarbonIconType;
export const StarFilled32: CarbonIconType;
export const StarHalf16: CarbonIconType;
export const StarHalf20: CarbonIconType;
export const StarHalf24: CarbonIconType;
export const StarHalf32: CarbonIconType;
export const StarReview16: CarbonIconType;
export const StarReview20: CarbonIconType;
export const StarReview24: CarbonIconType;
export const StarReview32: CarbonIconType;
export const StemLeafPlot16: CarbonIconType;
export const StemLeafPlot20: CarbonIconType;
export const StemLeafPlot24: CarbonIconType;
export const StemLeafPlot32: CarbonIconType;
export const Stethoscope16: CarbonIconType;
export const Stethoscope20: CarbonIconType;
export const Stethoscope24: CarbonIconType;
export const Stethoscope32: CarbonIconType;
export const Stop16: CarbonIconType;
export const Stop20: CarbonIconType;
export const Stop24: CarbonIconType;
export const Stop32: CarbonIconType;
export const StopFilled16: CarbonIconType;
export const StopFilled20: CarbonIconType;
export const StopFilled24: CarbonIconType;
export const StopFilled32: CarbonIconType;
export const StopFilledAlt16: CarbonIconType;
export const StopFilledAlt20: CarbonIconType;
export const StopFilledAlt24: CarbonIconType;
export const StopFilledAlt32: CarbonIconType;
export const StopOutline16: CarbonIconType;
export const StopOutline20: CarbonIconType;
export const StopOutline24: CarbonIconType;
export const StopOutline32: CarbonIconType;
export const StopOutlineFilled16: CarbonIconType;
export const StopOutlineFilled20: CarbonIconType;
export const StopOutlineFilled24: CarbonIconType;
export const StopOutlineFilled32: CarbonIconType;
export const Store16: CarbonIconType;
export const Store20: CarbonIconType;
export const Store24: CarbonIconType;
export const Store32: CarbonIconType;
export const Strawberry16: CarbonIconType;
export const Strawberry20: CarbonIconType;
export const Strawberry24: CarbonIconType;
export const Strawberry32: CarbonIconType;
export const StringInteger16: CarbonIconType;
export const StringInteger20: CarbonIconType;
export const StringInteger24: CarbonIconType;
export const StringInteger32: CarbonIconType;
export const StringText16: CarbonIconType;
export const StringText20: CarbonIconType;
export const StringText24: CarbonIconType;
export const StringText32: CarbonIconType;
export const Subtract16: CarbonIconType;
export const Subtract20: CarbonIconType;
export const Subtract24: CarbonIconType;
export const Subtract32: CarbonIconType;
export const SubtractAlt16: CarbonIconType;
export const SubtractAlt20: CarbonIconType;
export const SubtractAlt24: CarbonIconType;
export const SubtractAlt32: CarbonIconType;
export const Sun16: CarbonIconType;
export const Sun20: CarbonIconType;
export const Sun24: CarbonIconType;
export const Sun32: CarbonIconType;
export const Sunny16: CarbonIconType;
export const Sunny20: CarbonIconType;
export const Sunny24: CarbonIconType;
export const Sunny32: CarbonIconType;
export const Sunrise16: CarbonIconType;
export const Sunrise20: CarbonIconType;
export const Sunrise24: CarbonIconType;
export const Sunrise32: CarbonIconType;
export const Sunset16: CarbonIconType;
export const Sunset20: CarbonIconType;
export const Sunset24: CarbonIconType;
export const Sunset32: CarbonIconType;
export const Svg16: CarbonIconType;
export const Svg20: CarbonIconType;
export const Svg24: CarbonIconType;
export const Svg32: CarbonIconType;
export const Swim16: CarbonIconType;
export const Swim20: CarbonIconType;
export const Swim24: CarbonIconType;
export const Swim32: CarbonIconType;
export const Switcher16: CarbonIconType;
export const Switcher20: CarbonIconType;
export const Switcher24: CarbonIconType;
export const Switcher32: CarbonIconType;
export const SysProvision16: CarbonIconType;
export const SysProvision20: CarbonIconType;
export const SysProvision24: CarbonIconType;
export const SysProvision32: CarbonIconType;
export const Table16: CarbonIconType;
export const Table20: CarbonIconType;
export const Table24: CarbonIconType;
export const Table32: CarbonIconType;
export const TableOfContents16: CarbonIconType;
export const TableOfContents20: CarbonIconType;
export const TableOfContents24: CarbonIconType;
export const TableOfContents32: CarbonIconType;
export const TableSplit16: CarbonIconType;
export const TableSplit20: CarbonIconType;
export const TableSplit24: CarbonIconType;
export const TableSplit32: CarbonIconType;
export const Tablet16: CarbonIconType;
export const Tablet20: CarbonIconType;
export const Tablet24: CarbonIconType;
export const Tablet32: CarbonIconType;
export const TabletLandscape16: CarbonIconType;
export const TabletLandscape20: CarbonIconType;
export const TabletLandscape24: CarbonIconType;
export const TabletLandscape32: CarbonIconType;
export const Tag16: CarbonIconType;
export const Tag20: CarbonIconType;
export const Tag24: CarbonIconType;
export const Tag32: CarbonIconType;
export const TagEdit16: CarbonIconType;
export const TagEdit20: CarbonIconType;
export const TagEdit24: CarbonIconType;
export const TagEdit32: CarbonIconType;
export const TagGroup16: CarbonIconType;
export const TagGroup20: CarbonIconType;
export const TagGroup24: CarbonIconType;
export const TagGroup32: CarbonIconType;
export const Task16: CarbonIconType;
export const Task20: CarbonIconType;
export const Task24: CarbonIconType;
export const Task32: CarbonIconType;
export const TaskView16: CarbonIconType;
export const TaskView20: CarbonIconType;
export const TaskView24: CarbonIconType;
export const TaskView32: CarbonIconType;
export const Taste16: CarbonIconType;
export const Taste20: CarbonIconType;
export const Taste24: CarbonIconType;
export const Taste32: CarbonIconType;
export const Taxi16: CarbonIconType;
export const Taxi20: CarbonIconType;
export const Taxi24: CarbonIconType;
export const Taxi32: CarbonIconType;
export const Temperature16: CarbonIconType;
export const Temperature20: CarbonIconType;
export const Temperature24: CarbonIconType;
export const Temperature32: CarbonIconType;
export const TemperatureFrigid16: CarbonIconType;
export const TemperatureFrigid20: CarbonIconType;
export const TemperatureFrigid24: CarbonIconType;
export const TemperatureFrigid32: CarbonIconType;
export const TemperatureHot16: CarbonIconType;
export const TemperatureHot20: CarbonIconType;
export const TemperatureHot24: CarbonIconType;
export const TemperatureHot32: CarbonIconType;
export const Template16: CarbonIconType;
export const Template20: CarbonIconType;
export const Template24: CarbonIconType;
export const Template32: CarbonIconType;
export const Tennis16: CarbonIconType;
export const Tennis20: CarbonIconType;
export const Tennis24: CarbonIconType;
export const Tennis32: CarbonIconType;
export const TennisBall16: CarbonIconType;
export const TennisBall20: CarbonIconType;
export const TennisBall24: CarbonIconType;
export const TennisBall32: CarbonIconType;
export const Term16: CarbonIconType;
export const Term20: CarbonIconType;
export const Term24: CarbonIconType;
export const Term32: CarbonIconType;
export const Terminal16: CarbonIconType;
export const Terminal20: CarbonIconType;
export const Terminal24: CarbonIconType;
export const Terminal32: CarbonIconType;
export const TextAlignCenter16: CarbonIconType;
export const TextAlignCenter20: CarbonIconType;
export const TextAlignCenter24: CarbonIconType;
export const TextAlignCenter32: CarbonIconType;
export const TextAlignJustify16: CarbonIconType;
export const TextAlignJustify20: CarbonIconType;
export const TextAlignJustify24: CarbonIconType;
export const TextAlignJustify32: CarbonIconType;
export const TextAlignLeft16: CarbonIconType;
export const TextAlignLeft20: CarbonIconType;
export const TextAlignLeft24: CarbonIconType;
export const TextAlignLeft32: CarbonIconType;
export const TextAlignRight16: CarbonIconType;
export const TextAlignRight20: CarbonIconType;
export const TextAlignRight24: CarbonIconType;
export const TextAlignRight32: CarbonIconType;
export const TextAllCaps16: CarbonIconType;
export const TextAllCaps20: CarbonIconType;
export const TextAllCaps24: CarbonIconType;
export const TextAllCaps32: CarbonIconType;
export const TextBold16: CarbonIconType;
export const TextBold20: CarbonIconType;
export const TextBold24: CarbonIconType;
export const TextBold32: CarbonIconType;
export const TextColor16: CarbonIconType;
export const TextColor20: CarbonIconType;
export const TextColor24: CarbonIconType;
export const TextColor32: CarbonIconType;
export const TextCreation16: CarbonIconType;
export const TextCreation20: CarbonIconType;
export const TextCreation24: CarbonIconType;
export const TextCreation32: CarbonIconType;
export const TextFill16: CarbonIconType;
export const TextFill20: CarbonIconType;
export const TextFill24: CarbonIconType;
export const TextFill32: CarbonIconType;
export const TextHighlight16: CarbonIconType;
export const TextHighlight20: CarbonIconType;
export const TextHighlight24: CarbonIconType;
export const TextHighlight32: CarbonIconType;
export const TextIndent16: CarbonIconType;
export const TextIndent20: CarbonIconType;
export const TextIndent24: CarbonIconType;
export const TextIndent32: CarbonIconType;
export const TextIndentLess16: CarbonIconType;
export const TextIndentLess20: CarbonIconType;
export const TextIndentLess24: CarbonIconType;
export const TextIndentLess32: CarbonIconType;
export const TextIndentMore16: CarbonIconType;
export const TextIndentMore20: CarbonIconType;
export const TextIndentMore24: CarbonIconType;
export const TextIndentMore32: CarbonIconType;
export const TextItalic16: CarbonIconType;
export const TextItalic20: CarbonIconType;
export const TextItalic24: CarbonIconType;
export const TextItalic32: CarbonIconType;
export const TextKerning16: CarbonIconType;
export const TextKerning20: CarbonIconType;
export const TextKerning24: CarbonIconType;
export const TextKerning32: CarbonIconType;
export const TextLeading16: CarbonIconType;
export const TextLeading20: CarbonIconType;
export const TextLeading24: CarbonIconType;
export const TextLeading32: CarbonIconType;
export const TextLineSpacing16: CarbonIconType;
export const TextLineSpacing20: CarbonIconType;
export const TextLineSpacing24: CarbonIconType;
export const TextLineSpacing32: CarbonIconType;
export const TextLink16: CarbonIconType;
export const TextLink20: CarbonIconType;
export const TextLink24: CarbonIconType;
export const TextLink32: CarbonIconType;
export const TextLinkAnalysis16: CarbonIconType;
export const TextLinkAnalysis20: CarbonIconType;
export const TextLinkAnalysis24: CarbonIconType;
export const TextLinkAnalysis32: CarbonIconType;
export const TextMining16: CarbonIconType;
export const TextMining20: CarbonIconType;
export const TextMining24: CarbonIconType;
export const TextMining32: CarbonIconType;
export const TextMiningApplier16: CarbonIconType;
export const TextMiningApplier20: CarbonIconType;
export const TextMiningApplier24: CarbonIconType;
export const TextMiningApplier32: CarbonIconType;
export const TextNewLine16: CarbonIconType;
export const TextNewLine20: CarbonIconType;
export const TextNewLine24: CarbonIconType;
export const TextNewLine32: CarbonIconType;
export const TextScale16: CarbonIconType;
export const TextScale20: CarbonIconType;
export const TextScale24: CarbonIconType;
export const TextScale32: CarbonIconType;
export const TextSelection16: CarbonIconType;
export const TextSelection20: CarbonIconType;
export const TextSelection24: CarbonIconType;
export const TextSelection32: CarbonIconType;
export const TextSmallCaps16: CarbonIconType;
export const TextSmallCaps20: CarbonIconType;
export const TextSmallCaps24: CarbonIconType;
export const TextSmallCaps32: CarbonIconType;
export const TextStrikethrough16: CarbonIconType;
export const TextStrikethrough20: CarbonIconType;
export const TextStrikethrough24: CarbonIconType;
export const TextStrikethrough32: CarbonIconType;
export const TextSubscript16: CarbonIconType;
export const TextSubscript20: CarbonIconType;
export const TextSubscript24: CarbonIconType;
export const TextSubscript32: CarbonIconType;
export const TextSuperscript16: CarbonIconType;
export const TextSuperscript20: CarbonIconType;
export const TextSuperscript24: CarbonIconType;
export const TextSuperscript32: CarbonIconType;
export const TextTracking16: CarbonIconType;
export const TextTracking20: CarbonIconType;
export const TextTracking24: CarbonIconType;
export const TextTracking32: CarbonIconType;
export const TextUnderline16: CarbonIconType;
export const TextUnderline20: CarbonIconType;
export const TextUnderline24: CarbonIconType;
export const TextUnderline32: CarbonIconType;
export const TextVerticalAlignment16: CarbonIconType;
export const TextVerticalAlignment20: CarbonIconType;
export const TextVerticalAlignment24: CarbonIconType;
export const TextVerticalAlignment32: CarbonIconType;
export const TextWrap16: CarbonIconType;
export const TextWrap20: CarbonIconType;
export const TextWrap24: CarbonIconType;
export const TextWrap32: CarbonIconType;
export const Theater16: CarbonIconType;
export const Theater20: CarbonIconType;
export const Theater24: CarbonIconType;
export const Theater32: CarbonIconType;
export const Thumbnail_116: CarbonIconType;
export const Thumbnail_120: CarbonIconType;
export const Thumbnail_124: CarbonIconType;
export const Thumbnail_132: CarbonIconType;
export const Thumbnail_216: CarbonIconType;
export const Thumbnail_220: CarbonIconType;
export const Thumbnail_224: CarbonIconType;
export const Thumbnail_232: CarbonIconType;
export const ThumbsDown16: CarbonIconType;
export const ThumbsDown20: CarbonIconType;
export const ThumbsDown24: CarbonIconType;
export const ThumbsDown32: CarbonIconType;
export const ThumbsUp16: CarbonIconType;
export const ThumbsUp20: CarbonIconType;
export const ThumbsUp24: CarbonIconType;
export const ThumbsUp32: CarbonIconType;
export const Thunderstorm16: CarbonIconType;
export const Thunderstorm20: CarbonIconType;
export const Thunderstorm24: CarbonIconType;
export const Thunderstorm32: CarbonIconType;
export const ThunderstormScattered16: CarbonIconType;
export const ThunderstormScattered20: CarbonIconType;
export const ThunderstormScattered24: CarbonIconType;
export const ThunderstormScattered32: CarbonIconType;
export const ThunderstormScatteredNight16: CarbonIconType;
export const ThunderstormScatteredNight20: CarbonIconType;
export const ThunderstormScatteredNight24: CarbonIconType;
export const ThunderstormScatteredNight32: CarbonIconType;
export const ThunderstormSevere16: CarbonIconType;
export const ThunderstormSevere20: CarbonIconType;
export const ThunderstormSevere24: CarbonIconType;
export const ThunderstormSevere32: CarbonIconType;
export const ThunderstormStrong16: CarbonIconType;
export const ThunderstormStrong20: CarbonIconType;
export const ThunderstormStrong24: CarbonIconType;
export const ThunderstormStrong32: CarbonIconType;
export const Ticket16: CarbonIconType;
export const Ticket20: CarbonIconType;
export const Ticket24: CarbonIconType;
export const Ticket32: CarbonIconType;
export const Tif16: CarbonIconType;
export const Tif20: CarbonIconType;
export const Tif24: CarbonIconType;
export const Tif32: CarbonIconType;
export const Time16: CarbonIconType;
export const Time20: CarbonIconType;
export const Time24: CarbonIconType;
export const Time32: CarbonIconType;
export const Timer16: CarbonIconType;
export const Timer20: CarbonIconType;
export const Timer24: CarbonIconType;
export const Timer32: CarbonIconType;
export const ToolBox16: CarbonIconType;
export const ToolBox20: CarbonIconType;
export const ToolBox24: CarbonIconType;
export const ToolBox32: CarbonIconType;
export const Tools16: CarbonIconType;
export const Tools20: CarbonIconType;
export const Tools24: CarbonIconType;
export const Tools32: CarbonIconType;
export const Tornado16: CarbonIconType;
export const Tornado20: CarbonIconType;
export const Tornado24: CarbonIconType;
export const Tornado32: CarbonIconType;
export const TouchInteraction16: CarbonIconType;
export const TouchInteraction20: CarbonIconType;
export const TouchInteraction24: CarbonIconType;
export const TouchInteraction32: CarbonIconType;
export const Touch_116: CarbonIconType;
export const Touch_120: CarbonIconType;
export const Touch_124: CarbonIconType;
export const Touch_132: CarbonIconType;
export const Touch_216: CarbonIconType;
export const Touch_220: CarbonIconType;
export const Touch_224: CarbonIconType;
export const Touch_232: CarbonIconType;
export const Train16: CarbonIconType;
export const Train20: CarbonIconType;
export const Train24: CarbonIconType;
export const Train32: CarbonIconType;
export const Tram16: CarbonIconType;
export const Tram20: CarbonIconType;
export const Tram24: CarbonIconType;
export const Tram32: CarbonIconType;
export const Translate16: CarbonIconType;
export const Translate20: CarbonIconType;
export const Translate24: CarbonIconType;
export const Translate32: CarbonIconType;
export const TrashCan16: CarbonIconType;
export const TrashCan20: CarbonIconType;
export const TrashCan24: CarbonIconType;
export const TrashCan32: CarbonIconType;
export const Tree16: CarbonIconType;
export const Tree20: CarbonIconType;
export const Tree24: CarbonIconType;
export const Tree32: CarbonIconType;
export const TreeView16: CarbonIconType;
export const TreeView20: CarbonIconType;
export const TreeView24: CarbonIconType;
export const TreeView32: CarbonIconType;
export const TreeViewAlt16: CarbonIconType;
export const TreeViewAlt20: CarbonIconType;
export const TreeViewAlt24: CarbonIconType;
export const TreeViewAlt32: CarbonIconType;
export const Trophy16: CarbonIconType;
export const Trophy20: CarbonIconType;
export const Trophy24: CarbonIconType;
export const Trophy32: CarbonIconType;
export const TrophyFilled16: CarbonIconType;
export const TrophyFilled20: CarbonIconType;
export const TrophyFilled24: CarbonIconType;
export const TrophyFilled32: CarbonIconType;
export const TropicalStorm16: CarbonIconType;
export const TropicalStorm20: CarbonIconType;
export const TropicalStorm24: CarbonIconType;
export const TropicalStorm32: CarbonIconType;
export const Tsv16: CarbonIconType;
export const Tsv20: CarbonIconType;
export const Tsv24: CarbonIconType;
export const Tsv32: CarbonIconType;
export const Txt16: CarbonIconType;
export const Txt20: CarbonIconType;
export const Txt24: CarbonIconType;
export const Txt32: CarbonIconType;
export const TypePattern16: CarbonIconType;
export const TypePattern20: CarbonIconType;
export const TypePattern24: CarbonIconType;
export const TypePattern32: CarbonIconType;
export const Types16: CarbonIconType;
export const Types20: CarbonIconType;
export const Types24: CarbonIconType;
export const Types32: CarbonIconType;
export const Umbrella16: CarbonIconType;
export const Umbrella20: CarbonIconType;
export const Umbrella24: CarbonIconType;
export const Umbrella32: CarbonIconType;
export const Undefined16: CarbonIconType;
export const Undefined20: CarbonIconType;
export const Undefined24: CarbonIconType;
export const Undefined32: CarbonIconType;
export const UndefinedFilled16: CarbonIconType;
export const UndefinedFilled20: CarbonIconType;
export const UndefinedFilled24: CarbonIconType;
export const UndefinedFilled32: CarbonIconType;
export const Undo16: CarbonIconType;
export const Undo20: CarbonIconType;
export const Undo24: CarbonIconType;
export const Undo32: CarbonIconType;
export const Unknown16: CarbonIconType;
export const Unknown20: CarbonIconType;
export const Unknown24: CarbonIconType;
export const Unknown32: CarbonIconType;
export const UnknownFilled16: CarbonIconType;
export const UnknownFilled20: CarbonIconType;
export const UnknownFilled24: CarbonIconType;
export const UnknownFilled32: CarbonIconType;
export const Unlink16: CarbonIconType;
export const Unlink20: CarbonIconType;
export const Unlink24: CarbonIconType;
export const Unlink32: CarbonIconType;
export const Unlocked16: CarbonIconType;
export const Unlocked20: CarbonIconType;
export const Unlocked24: CarbonIconType;
export const Unlocked32: CarbonIconType;
export const UpToTop16: CarbonIconType;
export const UpToTop20: CarbonIconType;
export const UpToTop24: CarbonIconType;
export const UpToTop32: CarbonIconType;
export const Upgrade16: CarbonIconType;
export const Upgrade20: CarbonIconType;
export const Upgrade24: CarbonIconType;
export const Upgrade32: CarbonIconType;
export const Upload16: CarbonIconType;
export const Upload20: CarbonIconType;
export const Upload24: CarbonIconType;
export const Upload32: CarbonIconType;
export const Usb16: CarbonIconType;
export const Usb20: CarbonIconType;
export const Usb24: CarbonIconType;
export const Usb32: CarbonIconType;
export const User16: CarbonIconType;
export const User20: CarbonIconType;
export const User24: CarbonIconType;
export const User32: CarbonIconType;
export const UserActivity16: CarbonIconType;
export const UserActivity20: CarbonIconType;
export const UserActivity24: CarbonIconType;
export const UserActivity32: CarbonIconType;
export const UserAdmin16: CarbonIconType;
export const UserAdmin20: CarbonIconType;
export const UserAdmin24: CarbonIconType;
export const UserAdmin32: CarbonIconType;
export const UserAvatar16: CarbonIconType;
export const UserAvatar20: CarbonIconType;
export const UserAvatar24: CarbonIconType;
export const UserAvatar32: CarbonIconType;
export const UserAvatarFilled16: CarbonIconType;
export const UserAvatarFilled20: CarbonIconType;
export const UserAvatarFilled24: CarbonIconType;
export const UserAvatarFilled32: CarbonIconType;
export const UserAvatarFilledAlt16: CarbonIconType;
export const UserAvatarFilledAlt20: CarbonIconType;
export const UserAvatarFilledAlt24: CarbonIconType;
export const UserAvatarFilledAlt32: CarbonIconType;
export const UserCertification16: CarbonIconType;
export const UserCertification20: CarbonIconType;
export const UserCertification24: CarbonIconType;
export const UserCertification32: CarbonIconType;
export const UserData16: CarbonIconType;
export const UserData20: CarbonIconType;
export const UserData24: CarbonIconType;
export const UserData32: CarbonIconType;
export const UserFavorite16: CarbonIconType;
export const UserFavorite20: CarbonIconType;
export const UserFavorite24: CarbonIconType;
export const UserFavorite32: CarbonIconType;
export const UserFavoriteAlt16: CarbonIconType;
export const UserFavoriteAlt20: CarbonIconType;
export const UserFavoriteAlt24: CarbonIconType;
export const UserFavoriteAlt32: CarbonIconType;
export const UserFavoriteAltFilled16: CarbonIconType;
export const UserFavoriteAltFilled20: CarbonIconType;
export const UserFavoriteAltFilled24: CarbonIconType;
export const UserFavoriteAltFilled32: CarbonIconType;
export const UserFilled16: CarbonIconType;
export const UserFilled20: CarbonIconType;
export const UserFilled24: CarbonIconType;
export const UserFilled32: CarbonIconType;
export const UserFollow16: CarbonIconType;
export const UserFollow20: CarbonIconType;
export const UserFollow24: CarbonIconType;
export const UserFollow32: CarbonIconType;
export const UserIdentification16: CarbonIconType;
export const UserIdentification20: CarbonIconType;
export const UserIdentification24: CarbonIconType;
export const UserIdentification32: CarbonIconType;
export const UserMultiple16: CarbonIconType;
export const UserMultiple20: CarbonIconType;
export const UserMultiple24: CarbonIconType;
export const UserMultiple32: CarbonIconType;
export const UserOnline16: CarbonIconType;
export const UserOnline20: CarbonIconType;
export const UserOnline24: CarbonIconType;
export const UserOnline32: CarbonIconType;
export const UserProfile16: CarbonIconType;
export const UserProfile20: CarbonIconType;
export const UserProfile24: CarbonIconType;
export const UserProfile32: CarbonIconType;
export const UserProfileAlt16: CarbonIconType;
export const UserProfileAlt20: CarbonIconType;
export const UserProfileAlt24: CarbonIconType;
export const UserProfileAlt32: CarbonIconType;
export const UserRole16: CarbonIconType;
export const UserRole20: CarbonIconType;
export const UserRole24: CarbonIconType;
export const UserRole32: CarbonIconType;
export const UserSimulation16: CarbonIconType;
export const UserSimulation20: CarbonIconType;
export const UserSimulation24: CarbonIconType;
export const UserSimulation32: CarbonIconType;
export const UserSpeaker16: CarbonIconType;
export const UserSpeaker20: CarbonIconType;
export const UserSpeaker24: CarbonIconType;
export const UserSpeaker32: CarbonIconType;
export const UserXRay16: CarbonIconType;
export const UserXRay20: CarbonIconType;
export const UserXRay24: CarbonIconType;
export const UserXRay32: CarbonIconType;
export const UvIndex16: CarbonIconType;
export const UvIndex20: CarbonIconType;
export const UvIndex24: CarbonIconType;
export const UvIndex32: CarbonIconType;
export const UvIndexFilled16: CarbonIconType;
export const UvIndexFilled20: CarbonIconType;
export const UvIndexFilled24: CarbonIconType;
export const UvIndexFilled32: CarbonIconType;
export const Van16: CarbonIconType;
export const Van20: CarbonIconType;
export const Van24: CarbonIconType;
export const Van32: CarbonIconType;
export const Video16: CarbonIconType;
export const Video20: CarbonIconType;
export const Video24: CarbonIconType;
export const Video32: CarbonIconType;
export const VideoAdd16: CarbonIconType;
export const VideoAdd20: CarbonIconType;
export const VideoAdd24: CarbonIconType;
export const VideoAdd32: CarbonIconType;
export const VideoChat16: CarbonIconType;
export const VideoChat20: CarbonIconType;
export const VideoChat24: CarbonIconType;
export const VideoChat32: CarbonIconType;
export const VideoFilled16: CarbonIconType;
export const VideoFilled20: CarbonIconType;
export const VideoFilled24: CarbonIconType;
export const VideoFilled32: CarbonIconType;
export const VideoOff16: CarbonIconType;
export const VideoOff20: CarbonIconType;
export const VideoOff24: CarbonIconType;
export const VideoOff32: CarbonIconType;
export const VideoOffFilled16: CarbonIconType;
export const VideoOffFilled20: CarbonIconType;
export const VideoOffFilled24: CarbonIconType;
export const VideoOffFilled32: CarbonIconType;
export const View16: CarbonIconType;
export const View20: CarbonIconType;
export const View24: CarbonIconType;
export const View32: CarbonIconType;
export const ViewFilled16: CarbonIconType;
export const ViewFilled20: CarbonIconType;
export const ViewFilled24: CarbonIconType;
export const ViewFilled32: CarbonIconType;
export const ViewMode_116: CarbonIconType;
export const ViewMode_120: CarbonIconType;
export const ViewMode_124: CarbonIconType;
export const ViewMode_132: CarbonIconType;
export const ViewMode_216: CarbonIconType;
export const ViewMode_220: CarbonIconType;
export const ViewMode_224: CarbonIconType;
export const ViewMode_232: CarbonIconType;
export const ViewOff16: CarbonIconType;
export const ViewOff20: CarbonIconType;
export const ViewOff24: CarbonIconType;
export const ViewOff32: CarbonIconType;
export const ViewOffFilled16: CarbonIconType;
export const ViewOffFilled20: CarbonIconType;
export const ViewOffFilled24: CarbonIconType;
export const ViewOffFilled32: CarbonIconType;
export const VirtualColumn16: CarbonIconType;
export const VirtualColumn20: CarbonIconType;
export const VirtualColumn24: CarbonIconType;
export const VirtualColumn32: CarbonIconType;
export const VirtualColumnKey16: CarbonIconType;
export const VirtualColumnKey20: CarbonIconType;
export const VirtualColumnKey24: CarbonIconType;
export const VirtualColumnKey32: CarbonIconType;
export const VirtualMachine16: CarbonIconType;
export const VirtualMachine20: CarbonIconType;
export const VirtualMachine24: CarbonIconType;
export const VirtualMachine32: CarbonIconType;
export const VirtualPrivateCloud16: CarbonIconType;
export const VirtualPrivateCloud20: CarbonIconType;
export const VirtualPrivateCloud24: CarbonIconType;
export const VirtualPrivateCloud32: CarbonIconType;
export const VirtualPrivateCloudAlt16: CarbonIconType;
export const VirtualPrivateCloudAlt20: CarbonIconType;
export const VirtualPrivateCloudAlt24: CarbonIconType;
export const VirtualPrivateCloudAlt32: CarbonIconType;
export const VisualRecognition16: CarbonIconType;
export const VisualRecognition20: CarbonIconType;
export const VisualRecognition24: CarbonIconType;
export const VisualRecognition32: CarbonIconType;
export const VmdkDisk16: CarbonIconType;
export const VmdkDisk20: CarbonIconType;
export const VmdkDisk24: CarbonIconType;
export const VmdkDisk32: CarbonIconType;
export const Voicemail16: CarbonIconType;
export const Voicemail20: CarbonIconType;
export const Voicemail24: CarbonIconType;
export const Voicemail32: CarbonIconType;
export const VolumeDown16: CarbonIconType;
export const VolumeDown20: CarbonIconType;
export const VolumeDown24: CarbonIconType;
export const VolumeDown32: CarbonIconType;
export const VolumeDownFilled16: CarbonIconType;
export const VolumeDownFilled20: CarbonIconType;
export const VolumeDownFilled24: CarbonIconType;
export const VolumeDownFilled32: CarbonIconType;
export const VolumeMute16: CarbonIconType;
export const VolumeMute20: CarbonIconType;
export const VolumeMute24: CarbonIconType;
export const VolumeMute32: CarbonIconType;
export const VolumeMuteFilled16: CarbonIconType;
export const VolumeMuteFilled20: CarbonIconType;
export const VolumeMuteFilled24: CarbonIconType;
export const VolumeMuteFilled32: CarbonIconType;
export const VolumeUp16: CarbonIconType;
export const VolumeUp20: CarbonIconType;
export const VolumeUp24: CarbonIconType;
export const VolumeUp32: CarbonIconType;
export const VolumeUpFilled16: CarbonIconType;
export const VolumeUpFilled20: CarbonIconType;
export const VolumeUpFilled24: CarbonIconType;
export const VolumeUpFilled32: CarbonIconType;
export const Vpn16: CarbonIconType;
export const Vpn20: CarbonIconType;
export const Vpn24: CarbonIconType;
export const Vpn32: CarbonIconType;
export const Wallet16: CarbonIconType;
export const Wallet20: CarbonIconType;
export const Wallet24: CarbonIconType;
export const Wallet32: CarbonIconType;
export const Warning16: CarbonIconType;
export const Warning20: CarbonIconType;
export const Warning24: CarbonIconType;
export const Warning32: CarbonIconType;
export const WarningAlt16: CarbonIconType;
export const WarningAlt20: CarbonIconType;
export const WarningAlt24: CarbonIconType;
export const WarningAlt32: CarbonIconType;
export const WarningAltFilled16: CarbonIconType;
export const WarningAltFilled20: CarbonIconType;
export const WarningAltFilled24: CarbonIconType;
export const WarningAltFilled32: CarbonIconType;
export const WarningAltInverted16: CarbonIconType;
export const WarningAltInverted20: CarbonIconType;
export const WarningAltInverted24: CarbonIconType;
export const WarningAltInverted32: CarbonIconType;
export const WarningAltInvertedFilled16: CarbonIconType;
export const WarningAltInvertedFilled20: CarbonIconType;
export const WarningAltInvertedFilled24: CarbonIconType;
export const WarningAltInvertedFilled32: CarbonIconType;
export const WarningFilled16: CarbonIconType;
export const WarningFilled20: CarbonIconType;
export const WarningFilled24: CarbonIconType;
export const WarningFilled32: CarbonIconType;
export const WarningSquare16: CarbonIconType;
export const WarningSquare20: CarbonIconType;
export const WarningSquare24: CarbonIconType;
export const WarningSquare32: CarbonIconType;
export const WarningSquareFilled16: CarbonIconType;
export const WarningSquareFilled20: CarbonIconType;
export const WarningSquareFilled24: CarbonIconType;
export const WarningSquareFilled32: CarbonIconType;
export const Watch16: CarbonIconType;
export const Watch20: CarbonIconType;
export const Watch24: CarbonIconType;
export const Watch32: CarbonIconType;
export const Watson16: CarbonIconType;
export const Watson20: CarbonIconType;
export const Watson24: CarbonIconType;
export const Watson32: CarbonIconType;
export const WatsonHealth3DCursor16: CarbonIconType;
export const WatsonHealth3DCursor20: CarbonIconType;
export const WatsonHealth3DCursor24: CarbonIconType;
export const WatsonHealth3DCursor32: CarbonIconType;
export const WatsonHealth3DCursorAlt16: CarbonIconType;
export const WatsonHealth3DCursorAlt20: CarbonIconType;
export const WatsonHealth3DCursorAlt24: CarbonIconType;
export const WatsonHealth3DCursorAlt32: CarbonIconType;
export const WatsonHealth3DCurveAutoColon16: CarbonIconType;
export const WatsonHealth3DCurveAutoColon20: CarbonIconType;
export const WatsonHealth3DCurveAutoColon24: CarbonIconType;
export const WatsonHealth3DCurveAutoColon32: CarbonIconType;
export const WatsonHealth3DCurveAutoVessels16: CarbonIconType;
export const WatsonHealth3DCurveAutoVessels20: CarbonIconType;
export const WatsonHealth3DCurveAutoVessels24: CarbonIconType;
export const WatsonHealth3DCurveAutoVessels32: CarbonIconType;
export const WatsonHealth3DCurveManual16: CarbonIconType;
export const WatsonHealth3DCurveManual20: CarbonIconType;
export const WatsonHealth3DCurveManual24: CarbonIconType;
export const WatsonHealth3DCurveManual32: CarbonIconType;
export const WatsonHealth3DICa16: CarbonIconType;
export const WatsonHealth3DICa20: CarbonIconType;
export const WatsonHealth3DICa24: CarbonIconType;
export const WatsonHealth3DICa32: CarbonIconType;
export const WatsonHealth3DMprToggle16: CarbonIconType;
export const WatsonHealth3DMprToggle20: CarbonIconType;
export const WatsonHealth3DMprToggle24: CarbonIconType;
export const WatsonHealth3DMprToggle32: CarbonIconType;
export const WatsonHealth3DSoftware16: CarbonIconType;
export const WatsonHealth3DSoftware20: CarbonIconType;
export const WatsonHealth3DSoftware24: CarbonIconType;
export const WatsonHealth3DSoftware32: CarbonIconType;
export const WatsonHealth3rdPartyConnected16: CarbonIconType;
export const WatsonHealth3rdPartyConnected20: CarbonIconType;
export const WatsonHealth3rdPartyConnected24: CarbonIconType;
export const WatsonHealth3rdPartyConnected32: CarbonIconType;
export const WatsonHealthAngle16: CarbonIconType;
export const WatsonHealthAngle20: CarbonIconType;
export const WatsonHealthAngle24: CarbonIconType;
export const WatsonHealthAngle32: CarbonIconType;
export const WatsonHealthAnnotationVisibility16: CarbonIconType;
export const WatsonHealthAnnotationVisibility20: CarbonIconType;
export const WatsonHealthAnnotationVisibility24: CarbonIconType;
export const WatsonHealthAnnotationVisibility32: CarbonIconType;
export const WatsonHealthArrowAnnotation16: CarbonIconType;
export const WatsonHealthArrowAnnotation20: CarbonIconType;
export const WatsonHealthArrowAnnotation24: CarbonIconType;
export const WatsonHealthArrowAnnotation32: CarbonIconType;
export const WatsonHealthAutoScroll16: CarbonIconType;
export const WatsonHealthAutoScroll20: CarbonIconType;
export const WatsonHealthAutoScroll24: CarbonIconType;
export const WatsonHealthAutoScroll32: CarbonIconType;
export const WatsonHealthCdArchive16: CarbonIconType;
export const WatsonHealthCdArchive20: CarbonIconType;
export const WatsonHealthCdArchive24: CarbonIconType;
export const WatsonHealthCdArchive32: CarbonIconType;
export const WatsonHealthCdCreateArchive16: CarbonIconType;
export const WatsonHealthCdCreateArchive20: CarbonIconType;
export const WatsonHealthCdCreateArchive24: CarbonIconType;
export const WatsonHealthCdCreateArchive32: CarbonIconType;
export const WatsonHealthCdCreateExchange16: CarbonIconType;
export const WatsonHealthCdCreateExchange20: CarbonIconType;
export const WatsonHealthCdCreateExchange24: CarbonIconType;
export const WatsonHealthCdCreateExchange32: CarbonIconType;
export const WatsonHealthCircleMeasurement16: CarbonIconType;
export const WatsonHealthCircleMeasurement20: CarbonIconType;
export const WatsonHealthCircleMeasurement24: CarbonIconType;
export const WatsonHealthCircleMeasurement32: CarbonIconType;
export const WatsonHealthCobbAngle16: CarbonIconType;
export const WatsonHealthCobbAngle20: CarbonIconType;
export const WatsonHealthCobbAngle24: CarbonIconType;
export const WatsonHealthCobbAngle32: CarbonIconType;
export const WatsonHealthCrossReference16: CarbonIconType;
export const WatsonHealthCrossReference20: CarbonIconType;
export const WatsonHealthCrossReference24: CarbonIconType;
export const WatsonHealthCrossReference32: CarbonIconType;
export const WatsonHealthCutInHalf16: CarbonIconType;
export const WatsonHealthCutInHalf20: CarbonIconType;
export const WatsonHealthCutInHalf24: CarbonIconType;
export const WatsonHealthCutInHalf32: CarbonIconType;
export const WatsonHealthDenominate16: CarbonIconType;
export const WatsonHealthDenominate20: CarbonIconType;
export const WatsonHealthDenominate24: CarbonIconType;
export const WatsonHealthDenominate32: CarbonIconType;
export const WatsonHealthDicomOverlay16: CarbonIconType;
export const WatsonHealthDicomOverlay20: CarbonIconType;
export const WatsonHealthDicomOverlay24: CarbonIconType;
export const WatsonHealthDicomOverlay32: CarbonIconType;
export const WatsonHealthDicom_600016: CarbonIconType;
export const WatsonHealthDicom_600020: CarbonIconType;
export const WatsonHealthDicom_600024: CarbonIconType;
export const WatsonHealthDicom_600032: CarbonIconType;
export const WatsonHealthDna16: CarbonIconType;
export const WatsonHealthDna20: CarbonIconType;
export const WatsonHealthDna24: CarbonIconType;
export const WatsonHealthDna32: CarbonIconType;
export const WatsonHealthDownloadStudy16: CarbonIconType;
export const WatsonHealthDownloadStudy20: CarbonIconType;
export const WatsonHealthDownloadStudy24: CarbonIconType;
export const WatsonHealthDownloadStudy32: CarbonIconType;
export const WatsonHealthEdgeEnhancement16: CarbonIconType;
export const WatsonHealthEdgeEnhancement20: CarbonIconType;
export const WatsonHealthEdgeEnhancement24: CarbonIconType;
export const WatsonHealthEdgeEnhancement32: CarbonIconType;
export const WatsonHealthEditFilter16: CarbonIconType;
export const WatsonHealthEditFilter20: CarbonIconType;
export const WatsonHealthEditFilter24: CarbonIconType;
export const WatsonHealthEditFilter32: CarbonIconType;
export const WatsonHealthErase_3D16: CarbonIconType;
export const WatsonHealthErase_3D20: CarbonIconType;
export const WatsonHealthErase_3D24: CarbonIconType;
export const WatsonHealthErase_3D32: CarbonIconType;
export const WatsonHealthFusionBlender16: CarbonIconType;
export const WatsonHealthFusionBlender20: CarbonIconType;
export const WatsonHealthFusionBlender24: CarbonIconType;
export const WatsonHealthFusionBlender32: CarbonIconType;
export const WatsonHealthHangingProtocol16: CarbonIconType;
export const WatsonHealthHangingProtocol20: CarbonIconType;
export const WatsonHealthHangingProtocol24: CarbonIconType;
export const WatsonHealthHangingProtocol32: CarbonIconType;
export const WatsonHealthHoleFilling16: CarbonIconType;
export const WatsonHealthHoleFilling20: CarbonIconType;
export const WatsonHealthHoleFilling24: CarbonIconType;
export const WatsonHealthHoleFilling32: CarbonIconType;
export const WatsonHealthHoleFillingCursor16: CarbonIconType;
export const WatsonHealthHoleFillingCursor20: CarbonIconType;
export const WatsonHealthHoleFillingCursor24: CarbonIconType;
export const WatsonHealthHoleFillingCursor32: CarbonIconType;
export const WatsonHealthICa_2D16: CarbonIconType;
export const WatsonHealthICa_2D20: CarbonIconType;
export const WatsonHealthICa_2D24: CarbonIconType;
export const WatsonHealthICa_2D32: CarbonIconType;
export const WatsonHealthInteractiveSegmentationCursor16: CarbonIconType;
export const WatsonHealthInteractiveSegmentationCursor20: CarbonIconType;
export const WatsonHealthInteractiveSegmentationCursor24: CarbonIconType;
export const WatsonHealthInteractiveSegmentationCursor32: CarbonIconType;
export const WatsonHealthLaunchStudy_116: CarbonIconType;
export const WatsonHealthLaunchStudy_120: CarbonIconType;
export const WatsonHealthLaunchStudy_124: CarbonIconType;
export const WatsonHealthLaunchStudy_132: CarbonIconType;
export const WatsonHealthLaunchStudy_216: CarbonIconType;
export const WatsonHealthLaunchStudy_220: CarbonIconType;
export const WatsonHealthLaunchStudy_224: CarbonIconType;
export const WatsonHealthLaunchStudy_232: CarbonIconType;
export const WatsonHealthLaunchStudy_316: CarbonIconType;
export const WatsonHealthLaunchStudy_320: CarbonIconType;
export const WatsonHealthLaunchStudy_324: CarbonIconType;
export const WatsonHealthLaunchStudy_332: CarbonIconType;
export const WatsonHealthMagnify16: CarbonIconType;
export const WatsonHealthMagnify20: CarbonIconType;
export const WatsonHealthMagnify24: CarbonIconType;
export const WatsonHealthMagnify32: CarbonIconType;
export const WatsonHealthMammogram16: CarbonIconType;
export const WatsonHealthMammogram20: CarbonIconType;
export const WatsonHealthMammogram24: CarbonIconType;
export const WatsonHealthMammogram32: CarbonIconType;
export const WatsonHealthNominate16: CarbonIconType;
export const WatsonHealthNominate20: CarbonIconType;
export const WatsonHealthNominate24: CarbonIconType;
export const WatsonHealthNominate32: CarbonIconType;
export const WatsonHealthPageScroll16: CarbonIconType;
export const WatsonHealthPageScroll20: CarbonIconType;
export const WatsonHealthPageScroll24: CarbonIconType;
export const WatsonHealthPageScroll32: CarbonIconType;
export const WatsonHealthPetImageB16: CarbonIconType;
export const WatsonHealthPetImageB20: CarbonIconType;
export const WatsonHealthPetImageB24: CarbonIconType;
export const WatsonHealthPetImageB32: CarbonIconType;
export const WatsonHealthPetImageO16: CarbonIconType;
export const WatsonHealthPetImageO20: CarbonIconType;
export const WatsonHealthPetImageO24: CarbonIconType;
export const WatsonHealthPetImageO32: CarbonIconType;
export const WatsonHealthPointerText16: CarbonIconType;
export const WatsonHealthPointerText20: CarbonIconType;
export const WatsonHealthPointerText24: CarbonIconType;
export const WatsonHealthPointerText32: CarbonIconType;
export const WatsonHealthRegionAnalysisArea16: CarbonIconType;
export const WatsonHealthRegionAnalysisArea20: CarbonIconType;
export const WatsonHealthRegionAnalysisArea24: CarbonIconType;
export const WatsonHealthRegionAnalysisArea32: CarbonIconType;
export const WatsonHealthRegionAnalysisVolume16: CarbonIconType;
export const WatsonHealthRegionAnalysisVolume20: CarbonIconType;
export const WatsonHealthRegionAnalysisVolume24: CarbonIconType;
export const WatsonHealthRegionAnalysisVolume32: CarbonIconType;
export const WatsonHealthRegistration16: CarbonIconType;
export const WatsonHealthRegistration20: CarbonIconType;
export const WatsonHealthRegistration24: CarbonIconType;
export const WatsonHealthRegistration32: CarbonIconType;
export const WatsonHealthRotate_18016: CarbonIconType;
export const WatsonHealthRotate_18020: CarbonIconType;
export const WatsonHealthRotate_18024: CarbonIconType;
export const WatsonHealthRotate_18032: CarbonIconType;
export const WatsonHealthRotate_36016: CarbonIconType;
export const WatsonHealthRotate_36020: CarbonIconType;
export const WatsonHealthRotate_36024: CarbonIconType;
export const WatsonHealthRotate_36032: CarbonIconType;
export const WatsonHealthSaveAnnotation16: CarbonIconType;
export const WatsonHealthSaveAnnotation20: CarbonIconType;
export const WatsonHealthSaveAnnotation24: CarbonIconType;
export const WatsonHealthSaveAnnotation32: CarbonIconType;
export const WatsonHealthSaveImage16: CarbonIconType;
export const WatsonHealthSaveImage20: CarbonIconType;
export const WatsonHealthSaveImage24: CarbonIconType;
export const WatsonHealthSaveImage32: CarbonIconType;
export const WatsonHealthSaveSeries16: CarbonIconType;
export const WatsonHealthSaveSeries20: CarbonIconType;
export const WatsonHealthSaveSeries24: CarbonIconType;
export const WatsonHealthSaveSeries32: CarbonIconType;
export const WatsonHealthScalpelCursor16: CarbonIconType;
export const WatsonHealthScalpelCursor20: CarbonIconType;
export const WatsonHealthScalpelCursor24: CarbonIconType;
export const WatsonHealthScalpelCursor32: CarbonIconType;
export const WatsonHealthScalpelLasso16: CarbonIconType;
export const WatsonHealthScalpelLasso20: CarbonIconType;
export const WatsonHealthScalpelLasso24: CarbonIconType;
export const WatsonHealthScalpelLasso32: CarbonIconType;
export const WatsonHealthScalpelSelect16: CarbonIconType;
export const WatsonHealthScalpelSelect20: CarbonIconType;
export const WatsonHealthScalpelSelect24: CarbonIconType;
export const WatsonHealthScalpelSelect32: CarbonIconType;
export const WatsonHealthSmoothing16: CarbonIconType;
export const WatsonHealthSmoothing20: CarbonIconType;
export const WatsonHealthSmoothing24: CarbonIconType;
export const WatsonHealthSmoothing32: CarbonIconType;
export const WatsonHealthSmoothingCursor16: CarbonIconType;
export const WatsonHealthSmoothingCursor20: CarbonIconType;
export const WatsonHealthSmoothingCursor24: CarbonIconType;
export const WatsonHealthSmoothingCursor32: CarbonIconType;
export const WatsonHealthSpineLabel16: CarbonIconType;
export const WatsonHealthSpineLabel20: CarbonIconType;
export const WatsonHealthSpineLabel24: CarbonIconType;
export const WatsonHealthSpineLabel32: CarbonIconType;
export const WatsonHealthStackedMove16: CarbonIconType;
export const WatsonHealthStackedMove20: CarbonIconType;
export const WatsonHealthStackedMove24: CarbonIconType;
export const WatsonHealthStackedMove32: CarbonIconType;
export const WatsonHealthStackedScrolling_116: CarbonIconType;
export const WatsonHealthStackedScrolling_120: CarbonIconType;
export const WatsonHealthStackedScrolling_124: CarbonIconType;
export const WatsonHealthStackedScrolling_132: CarbonIconType;
export const WatsonHealthStackedScrolling_216: CarbonIconType;
export const WatsonHealthStackedScrolling_220: CarbonIconType;
export const WatsonHealthStackedScrolling_224: CarbonIconType;
export const WatsonHealthStackedScrolling_232: CarbonIconType;
export const WatsonHealthStressBreathEditor16: CarbonIconType;
export const WatsonHealthStressBreathEditor20: CarbonIconType;
export const WatsonHealthStressBreathEditor24: CarbonIconType;
export const WatsonHealthStressBreathEditor32: CarbonIconType;
export const WatsonHealthStudyNext16: CarbonIconType;
export const WatsonHealthStudyNext20: CarbonIconType;
export const WatsonHealthStudyNext24: CarbonIconType;
export const WatsonHealthStudyNext32: CarbonIconType;
export const WatsonHealthStudyPrevious16: CarbonIconType;
export const WatsonHealthStudyPrevious20: CarbonIconType;
export const WatsonHealthStudyPrevious24: CarbonIconType;
export const WatsonHealthStudyPrevious32: CarbonIconType;
export const WatsonHealthStudySkip16: CarbonIconType;
export const WatsonHealthStudySkip20: CarbonIconType;
export const WatsonHealthStudySkip24: CarbonIconType;
export const WatsonHealthStudySkip32: CarbonIconType;
export const WatsonHealthTextAnnotationToggle16: CarbonIconType;
export const WatsonHealthTextAnnotationToggle20: CarbonIconType;
export const WatsonHealthTextAnnotationToggle24: CarbonIconType;
export const WatsonHealthTextAnnotationToggle32: CarbonIconType;
export const WatsonHealthThreshold16: CarbonIconType;
export const WatsonHealthThreshold20: CarbonIconType;
export const WatsonHealthThreshold24: CarbonIconType;
export const WatsonHealthThreshold32: CarbonIconType;
export const WatsonHealthThumbnailPreview16: CarbonIconType;
export const WatsonHealthThumbnailPreview20: CarbonIconType;
export const WatsonHealthThumbnailPreview24: CarbonIconType;
export const WatsonHealthThumbnailPreview32: CarbonIconType;
export const WatsonHealthWindowAuto16: CarbonIconType;
export const WatsonHealthWindowAuto20: CarbonIconType;
export const WatsonHealthWindowAuto24: CarbonIconType;
export const WatsonHealthWindowAuto32: CarbonIconType;
export const WatsonHealthWindowBase16: CarbonIconType;
export const WatsonHealthWindowBase20: CarbonIconType;
export const WatsonHealthWindowBase24: CarbonIconType;
export const WatsonHealthWindowBase32: CarbonIconType;
export const WatsonHealthWindowOverlay16: CarbonIconType;
export const WatsonHealthWindowOverlay20: CarbonIconType;
export const WatsonHealthWindowOverlay24: CarbonIconType;
export const WatsonHealthWindowOverlay32: CarbonIconType;
export const WatsonHealthZoomPan16: CarbonIconType;
export const WatsonHealthZoomPan20: CarbonIconType;
export const WatsonHealthZoomPan24: CarbonIconType;
export const WatsonHealthZoomPan32: CarbonIconType;
export const WatsonMachineLearning16: CarbonIconType;
export const WatsonMachineLearning20: CarbonIconType;
export const WatsonMachineLearning24: CarbonIconType;
export const WatsonMachineLearning32: CarbonIconType;
export const Wheat16: CarbonIconType;
export const Wheat20: CarbonIconType;
export const Wheat24: CarbonIconType;
export const Wheat32: CarbonIconType;
export const Wifi16: CarbonIconType;
export const Wifi20: CarbonIconType;
export const Wifi24: CarbonIconType;
export const Wifi32: CarbonIconType;
export const WifiOff16: CarbonIconType;
export const WifiOff20: CarbonIconType;
export const WifiOff24: CarbonIconType;
export const WifiOff32: CarbonIconType;
export const Wikis16: CarbonIconType;
export const Wikis20: CarbonIconType;
export const Wikis24: CarbonIconType;
export const Wikis32: CarbonIconType;
export const Windy16: CarbonIconType;
export const Windy20: CarbonIconType;
export const Windy24: CarbonIconType;
export const Windy32: CarbonIconType;
export const WindyDust16: CarbonIconType;
export const WindyDust20: CarbonIconType;
export const WindyDust24: CarbonIconType;
export const WindyDust32: CarbonIconType;
export const WindySnow16: CarbonIconType;
export const WindySnow20: CarbonIconType;
export const WindySnow24: CarbonIconType;
export const WindySnow32: CarbonIconType;
export const WindyStrong16: CarbonIconType;
export const WindyStrong20: CarbonIconType;
export const WindyStrong24: CarbonIconType;
export const WindyStrong32: CarbonIconType;
export const WintryMix16: CarbonIconType;
export const WintryMix20: CarbonIconType;
export const WintryMix24: CarbonIconType;
export const WintryMix32: CarbonIconType;
export const WirelessCheckout16: CarbonIconType;
export const WirelessCheckout20: CarbonIconType;
export const WirelessCheckout24: CarbonIconType;
export const WirelessCheckout32: CarbonIconType;
export const Wmv16: CarbonIconType;
export const Wmv20: CarbonIconType;
export const Wmv24: CarbonIconType;
export const Wmv32: CarbonIconType;
export const WordCloud16: CarbonIconType;
export const WordCloud20: CarbonIconType;
export const WordCloud24: CarbonIconType;
export const WordCloud32: CarbonIconType;
export const Workspace16: CarbonIconType;
export const Workspace20: CarbonIconType;
export const Workspace24: CarbonIconType;
export const Workspace32: CarbonIconType;
export const Worship16: CarbonIconType;
export const Worship20: CarbonIconType;
export const Worship24: CarbonIconType;
export const Worship32: CarbonIconType;
export const WorshipChristian16: CarbonIconType;
export const WorshipChristian20: CarbonIconType;
export const WorshipChristian24: CarbonIconType;
export const WorshipChristian32: CarbonIconType;
export const WorshipJewish16: CarbonIconType;
export const WorshipJewish20: CarbonIconType;
export const WorshipJewish24: CarbonIconType;
export const WorshipJewish32: CarbonIconType;
export const WorshipMuslim16: CarbonIconType;
export const WorshipMuslim20: CarbonIconType;
export const WorshipMuslim24: CarbonIconType;
export const WorshipMuslim32: CarbonIconType;
export const XAxis16: CarbonIconType;
export const XAxis20: CarbonIconType;
export const XAxis24: CarbonIconType;
export const XAxis32: CarbonIconType;
export const Xls16: CarbonIconType;
export const Xls20: CarbonIconType;
export const Xls24: CarbonIconType;
export const Xls32: CarbonIconType;
export const Xml16: CarbonIconType;
export const Xml20: CarbonIconType;
export const Xml24: CarbonIconType;
export const Xml32: CarbonIconType;
export const YAxis16: CarbonIconType;
export const YAxis20: CarbonIconType;
export const YAxis24: CarbonIconType;
export const YAxis32: CarbonIconType;
export const ZAxis16: CarbonIconType;
export const ZAxis20: CarbonIconType;
export const ZAxis24: CarbonIconType;
export const ZAxis32: CarbonIconType;
export const Zip16: CarbonIconType;
export const Zip20: CarbonIconType;
export const Zip24: CarbonIconType;
export const Zip32: CarbonIconType;
export const ZoomIn16: CarbonIconType;
export const ZoomIn20: CarbonIconType;
export const ZoomIn24: CarbonIconType;
export const ZoomIn32: CarbonIconType;
export const ZoomOut16: CarbonIconType;
export const ZoomOut20: CarbonIconType;
export const ZoomOut24: CarbonIconType;
export const ZoomOut32: CarbonIconType;
export const ZoomReset16: CarbonIconType;
export const ZoomReset20: CarbonIconType;
export const ZoomReset24: CarbonIconType;
export const ZoomReset32: CarbonIconType;
export const _4K16: CarbonIconType;
export const _4K20: CarbonIconType;
export const _4K24: CarbonIconType;
export const _4K32: CarbonIconType;
export const _4KFilled16: CarbonIconType;
export const _4KFilled20: CarbonIconType;
export const _4KFilled24: CarbonIconType;
export const _4KFilled32: CarbonIconType;
