"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.install = void 0;

var _name = require("@kui-shell/client/config.d/name.json");

var _electron = require("electron");

/*
 * Copyright 2017-18 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}; // require('electron-is-dev');


const isDev = false;
/**
 * Tell the renderer to execute a command
 *
 */

const tellRendererToExecute = (command, exec = 'qexec') => __awaiter(void 0, void 0, void 0, function* () {
  const {
    webContents
  } = yield Promise.resolve().then(() => require('electron'));
  const focusedWindow = webContents.getFocusedWebContents() || webContents.getAllWebContents()[0]; // see https://github.com/IBM/kui/issues/1717

  const devTools = webContents.getAllWebContents().map(_ => _.devToolsWebContents).filter(x => x);
  const isFocusedWindowDevTools = devTools.find(_ => _.id === focusedWindow.id);

  if (isFocusedWindowDevTools) {
    // debug('closing dev tools')
    const owningWindow = webContents.getAllWebContents().find(_ => {
      return _.devToolsWebContents && _.devToolsWebContents.id === focusedWindow.id;
    });

    if (owningWindow) {
      owningWindow.closeDevTools();
    }
  } else {
    // debug('closing kui window')
    focusedWindow.send(`/repl/${exec}`, {
      command
    });
  }
});
/**
 * tell the current window to open a new tab
 *
 */


const newTab = () => tellRendererToExecute('tab new');
/**
 * tell the current window to close the current tab
 *
 */


const closeTab = () => tellRendererToExecute('tab close');

const isDarwin = process.platform === 'darwin';
const closeAccelerator = isDarwin ? 'Command+W' : 'Control+Shift+W';

const install = createWindow => {
  if (!isDev) {
    const fileMenuItems = [{
      label: 'New Window',
      click: () => createWindow(),
      accelerator: 'CommandOrControl+N'
    }, {
      label: 'New Tab',
      click: () => newTab(),
      accelerator: 'CommandOrControl+T'
    }, {
      type: 'separator'
    }, {
      label: 'Close Tab',
      click: closeTab,
      accelerator: closeAccelerator
    }, {
      role: 'close',
      accelerator: undefined
    }];

    if (process.platform !== 'darwin') {
      fileMenuItems.push({
        type: 'separator'
      });
      fileMenuItems.push({
        role: 'quit'
      });
    }

    const themeMenuItem = {
      label: 'Choose a Theme',
      click: () => {
        try {
          tellRendererToExecute('themes', 'pexec');
        } catch (err) {
          console.log(err);
        }
      }
    };
    const helpMenuItems = [{
      label: `Getting Started with ${_name.productName}`,
      click: () => {
        try {
          tellRendererToExecute('getting started', 'pexec');
        } catch (err) {
          console.log(err);
        }
      }
    }, {
      type: 'separator'
    }, {
      label: 'Report Issue...',

      click() {
        require('electron').shell.openExternal('https://github.com/IBM/kui/issues/new');
      }

    }];
    const menuTemplate = [{
      label: 'File',
      submenu: fileMenuItems
    }, {
      label: 'Edit',
      submenu: [{
        role: 'undo'
      }, {
        role: 'redo'
      }, {
        type: 'separator'
      }, {
        role: 'cut'
      }, {
        role: 'copy'
      }, {
        role: 'paste'
      }, {
        role: 'pasteAndMatchStyle'
      }, {
        role: 'delete'
      }, {
        role: 'selectAll'
      }]
    }, {
      label: 'View',
      submenu: [themeMenuItem, {
        type: 'separator'
      }, {
        accelerator: process.platform === 'darwin' ? 'Meta+R' : 'Shift+CmdOrCtrl+R',
        role: 'reload'
      }, //          { role: 'forcereload' },
      {
        role: 'toggleDevTools'
      }, {
        type: 'separator'
      }, {
        role: 'resetZoom'
      }, {
        role: 'zoomIn'
      }, {
        role: 'zoomOut'
      }, {
        type: 'separator'
      }, {
        role: 'togglefullscreen'
      }]
    }, {
      role: 'window',
      submenu: [{
        role: 'minimize'
      }, {
        role: 'close',
        accelerator: closeAccelerator
      }]
    }, {
      role: 'help',
      submenu: helpMenuItems
    }];
    const about = {
      label: `About ${_name.productName}`,
      click: () => {
        try {
          tellRendererToExecute('about', 'pexec');
        } catch (err) {
          console.log(err);
        }
      }
    };
    const separator = {
      type: 'separator'
    };
    const submenu = [about, separator, {
      role: 'services',
      submenu: []
    }, separator, {
      role: 'hide'
    }, {
      role: 'hideOthers'
    }, {
      role: 'unhide'
    }, separator, {
      role: 'quit'
    }];

    if (process.platform === 'darwin') {
      menuTemplate.unshift({
        label: _name.productName,
        submenu
      });
    } else {
      // for windows and linux, put About in the Help menu
      helpMenuItems.push({
        type: 'separator'
      });
      helpMenuItems.push(about);
    }

    const menu = _electron.Menu.buildFromTemplate(menuTemplate);

    _electron.Menu.setApplicationMenu(menu);
  }
};

exports.install = install;