"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getSize;

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function paddingHorizontal(elt) {
  const style = window.getComputedStyle(elt);
  return parseInt(style.getPropertyValue('padding-left') || '0', 10) + parseInt(style.getPropertyValue('padding-right') || '0', 10);
}

function paddingVertical(elt) {
  const style = window.getComputedStyle(elt);
  return parseInt(style.getPropertyValue('padding-top') || '0', 10) + parseInt(style.getPropertyValue('padding-bottom') || '0', 10);
}

function getSize() {
  const enclosingRect = this.getBoundingClientRect();
  const selectorForWidthPad = '.repl-block .repl-output';
  const widthPadElement = this.querySelector(selectorForWidthPad);
  /* const heightPadElement = this */

  const width = enclosingRect.width - paddingHorizontal(widthPadElement);
  const height = enclosingRect.height - paddingVertical(this
  /* heightPadElement */
  );
  return {
    width,
    height
  };
}