function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { storiesOf } from '@storybook/react';
import { settings } from 'carbon-components';
import { withKnobs, select, text, number } from '@storybook/addon-knobs';
import Tooltip from '../Tooltip';
import Button from '../Button';
import { OverflowMenuVertical16 } from '@carbon/icons-react';
var prefix = settings.prefix;
var directions = {
  'Bottom (bottom)': 'bottom',
  'Left (left)': 'left',
  'Top (top)': 'top',
  'Right (right)': 'right'
};
var props = {
  withIcon: function withIcon() {
    return {
      direction: select('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: text('Trigger text (triggerText)', 'Tooltip label'),
      tabIndex: number('Tab index (tabIndex in <Tooltip>)', 0)
    };
  },
  withoutIcon: function withoutIcon() {
    return {
      showIcon: false,
      direction: select('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: text('Trigger text (triggerText)', 'Tooltip label'),
      tabIndex: number('Tab index (tabIndex in <Tooltip>)', 0)
    };
  },
  customIcon: function customIcon() {
    return {
      showIcon: true,
      direction: select('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: text('Trigger text (triggerText)', 'Tooltip label'),
      tabIndex: number('Tab index (tabIndex in <Tooltip>)', 0),
      renderIcon: React.forwardRef(function (props, ref) {
        return React.createElement("div", {
          ref: ref
        }, React.createElement("svg", {
          xmlns: "http://www.w3.org/2000/svg",
          width: "16",
          height: "16"
        }, React.createElement("path", {
          d: "M8.5 11V6.5h-2v1h1V11H6v1h4v-1zM8 3.5c-.4 0-.8.3-.8.8s.4.7.8.7.8-.3.8-.8-.4-.7-.8-.7z"
        }), React.createElement("path", {
          d: "M8 15c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7zM8 2C4.7 2 2 4.7 2 8s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6z"
        }), React.createElement("path", {
          fill: "none",
          d: "M0 0h16v16H0z"
        })));
      })
    };
  },
  customIconOnly: function customIconOnly() {
    return {
      showIcon: true,
      direction: select('Tooltip direction (direction)', directions, 'bottom'),
      iconDescription: 'Helpful Information',
      tabIndex: number('Tab index (tabIndex in <Tooltip>)', 0),
      renderIcon: OverflowMenuVertical16
    };
  }
};
var containerStyles = {
  height: 'calc(100vh - 6rem)',
  display: 'flex',
  justifyContent: 'center',
  alignItems: 'center'
};
Tooltip.displayName = 'Tooltip';

function UncontrolledTooltipExample() {
  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];

  return React.createElement(React.Fragment, null, React.createElement(Button, {
    style: {
      padding: '15px 20px',
      margin: '4px 20px'
    },
    onClick: function onClick() {
      return setValue(false);
    }
  }, "Hide"), React.createElement(Button, {
    style: {
      padding: '15px 20px',
      margin: '4px 20px'
    },
    onClick: function onClick() {
      return setValue(true);
    }
  }, "Show"), React.createElement("div", {
    style: {
      padding: '15px',
      margin: '4px 20px'
    }
  }, React.createElement(Tooltip, {
    triggerText: React.createElement("div", null, "My text wrapped with tooltip"),
    open: value,
    showIcon: false
  }, "Some text")));
}

storiesOf('Tooltip', module).addDecorator(withKnobs).add('default (bottom)', function () {
  return React.createElement("div", {
    style: containerStyles
  }, React.createElement(Tooltip, _extends({}, props.withIcon(), {
    tooltipBodyId: "tooltip-body"
  }), React.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), React.createElement(Button, {
    size: "small"
  }, "Create"))));
}, {
  info: {
    text: "\n            Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n            For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n            By default, the tooltip will render above the element. The example below shows the default scenario.\n          "
  }
}).add('no icon', function () {
  return React.createElement("div", {
    style: containerStyles
  }, React.createElement(Tooltip, props.withoutIcon(), React.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), React.createElement(Button, {
    size: "small"
  }, "Create"))));
}, {
  info: {
    text: "\n            Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n            For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n            By default, the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n          "
  }
}).add('render custom icon', function () {
  return React.createElement("div", {
    style: containerStyles
  }, React.createElement(Tooltip, props.customIcon(), React.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), React.createElement(Button, {
    size: "small"
  }, "Create"))));
}, {
  info: {
    text: "\n            Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n            For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n            By default, the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n          "
  }
}).add('only custom icon', function () {
  return React.createElement("div", {
    style: containerStyles
  }, React.createElement(Tooltip, props.customIconOnly(), React.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), React.createElement(Button, {
    size: "small"
  }, "Create"))));
}, {
  info: {
    text: "\n            Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n            For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n            By default, the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n          "
  }
}).add('uncontrolled tooltip', function () {
  return React.createElement(UncontrolledTooltipExample, null);
});