/// <reference types="react" />
import { Tab, NavResponse, ParsedOptions } from '@kui-shell/core';
import Width from './width';
import { BaseSidecar, Props } from './BaseSidecar';
import { HistoryEntry } from '../../spi/Navigation';
/**
 *
 * LeftNavSidecar
 * -------------------------
 * | <TitleBar/>           |
 * -------------------------
 * | A1   |                |
 * |  a1  | <Content>      |
 * |  a2  |  <KuiContent/> |
 * | B1   | </Content>     |
 * |  b1  |                |
 * |  b2  |                |
 * -------------------------
 *  ^^^^^ <SideNav/>
 *   A1, B1: <SideNavMenu/>
 *   a1, b1: <SideNavMenuItem/>
 *
 */
export default class LeftNavSidecar extends BaseSidecar<NavResponse, HistoryEntry> {
    constructor(props: Props);
    /** Is getState() idempotent? i.e. Will two command executions that satisfy `sameCommand` always produce the same response? */
    protected idempotent(): boolean;
    /** Should we display Back/Forward arrows for history navigation? */
    protected useArrowNavigation(): boolean;
    /** 30/70 split between the Terminal and the LeftNavSidecar */
    protected defaultWidth(): Width;
    /** @return a `HistoryEntry` for the given `Response` */
    protected getState(tab: Tab, response: NavResponse, execUUID: string, argvNoOptions: string[], parsedOptions: ParsedOptions): HistoryEntry;
    protected isFixedWidth(): boolean;
    private changeCurrent;
    /** render the leftnav part */
    protected nav(): JSX.Element;
    protected bodyContent(tabIdx: number, menuIdx?: number): JSX.Element;
    protected bodyContainer(tabIdx: number, menuIdx: number): JSX.Element;
    render(): JSX.Element;
}
