import * as React from 'react';
import * as lodash from 'lodash';
import { CheckmarkFilled16, ErrorFilled16, WarningFilled16, Unknown16 } from '@carbon/icons-react';
export const status = [
    {
        type: 'success',
        icon: React.createElement(CheckmarkFilled16, { className: `status-success` }),
        values: [
            'Running',
            'DEPLOYED',
            'Active',
            'OK',
            'Available',
            'Ready',
        ],
    },
    {
        type: 'warning',
        icon: React.createElement(WarningFilled16, { className: `status-warning` }),
        values: [
            'Pending',
            'Terminating',
            'ContainerCreating',
        ],
    },
    {
        type: 'failed',
        icon: React.createElement(ErrorFilled16, { className: `status-failed` }),
        values: [
            'Failed',
            'CrashLoopBackOff',
            'ImagePullBackOff',
            'ErrImagePull',
            'Error',
            'OOMKilled',
            'Init:OOMKilled',
        ],
    },
    {
        type: 'completed',
        icon: React.createElement(CheckmarkFilled16, { className: `status-completed` }),
        values: [
            'Completed',
            'Succeeded',
        ],
    },
    {
        type: 'unknown',
        icon: React.createElement(Unknown16, { className: 'status-unknown' }),
        values: [
            'Unknown',
        ],
    },
];
export const getStatusIcon = (data) => {
    const _ = status.filter((stat) => stat.values.includes(data));
    return lodash.get(_, '[0].icon', '');
};
//# sourceMappingURL=status.js.map