"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _resource = require("../../../model/resource");

var _Deployment = _interopRequireDefault(require("./impl/Deployment"));

var _Generic = _interopRequireDefault(require("./impl/Generic"));

var _Node = _interopRequireDefault(require("./impl/Node"));

var _Pod = _interopRequireDefault(require("./impl/Pod"));

var _ReplicaSet = _interopRequireDefault(require("./impl/ReplicaSet"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-kubectl');
/**
 * The content renderer for the summary tab
 *
 */

function renderSummary({
  REPL
}, resource) {
  return __awaiter(this, void 0, void 0, function* () {
    if ((0, _resource.isKubeResourceWithItsOwnSummary)(resource)) {
      return resource.summary;
    }

    try {
      const jsyaml = Promise.resolve().then(() => require('js-yaml'));
      const map = (0, _resource.isPod)(resource) ? (0, _Pod.default)(resource) : (0, _resource.isDeployment)(resource) ? (0, _Deployment.default)(resource) : (0, _resource.isReplicaSet)(resource) ? (0, _ReplicaSet.default)(resource) : (0, _resource.isNode)(resource) ? (0, _Node.default)(resource) : (0, _Generic.default)(resource, REPL); // our content is that map, rendered as yaml

      return {
        content: (yield jsyaml).safeDump(yield map),
        contentType: 'yaml'
      };
    } catch (err) {
      if (err.code === 404) {
        return strings('This resource has been deleted');
      } else {
        console.error(err);
        return {
          content: resource.kuiRawData,
          contentType: 'yaml'
        };
      }
    }
  });
}
/**
 * The Summary mode applies to all KubeResources, and uses
 * `renderContent` to render the view.
 *
 */


const summaryMode = {
  when: _resource.isSummarizableKubeResource,
  mode: {
    mode: 'summary',
    label: strings('summary'),
    content: renderSummary,
    // traits:
    defaultMode: true,
    order: -999 // we want this to be placed as the first tab

  }
};
var _default = summaryMode;
exports.default = _default;