"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderReact;

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _ResourceTable = _interopRequireDefault(require("../components/ResourceTable"));

var _core = require("@kui-shell/core");

var _i18n = _interopRequireDefault(require("./i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function renderReact(data, node, command) {
  const uniqueKinds = [...new Set(data.items ? data.items.map(item => item.kind) : data.map(item => item.kind))];

  const searchResource = () => {
    return /*#__PURE__*/React.createElement("div", {
      className: 'search--resource'
    }, data.related && data.related.length > 0 && command.includes(':') ? /*#__PURE__*/React.createElement("div", {
      className: 'related--resource-table-header'
    }, /*#__PURE__*/React.createElement("button", {
      onClick: () => {
        (0, _core.getCurrentTab)().REPL.pexec(command.concat(' --related'));
      },
      className: 'related--resource-table-header-button'
    }, /*#__PURE__*/React.createElement("div", {
      className: 'linked-resources'
    }, (0, _i18n.default)('search.label.view.related')), /*#__PURE__*/React.createElement("span", {
      className: 'arrow-right'
    }, "\u2192"))) : null, uniqueKinds.map(kind => /*#__PURE__*/React.createElement("div", {
      className: 'search--resource-table',
      key: kind.toString()
    }, /*#__PURE__*/React.createElement(_ResourceTable.default, {
      items: data.items ? data.items.filter(item => item.kind === kind) : data.filter(item => item.kind === kind),
      kind: kind.toString()
    }))));
  };

  ReactDOM.render( /*#__PURE__*/React.createElement(searchResource), node);
  return node;
}