import * as React from 'react';
export declare const enum BarColor {
    CPU = "var(--color-latency-0)",
    Memory = "var(--color-latency-1)",
    Overcommitted = "var(--color-error)"
}
declare type WithFraction = {
    fraction: number;
};
declare type WithFractionString = {
    fractionString: string;
};
declare type BarProps = {
    color: BarColor;
} & (WithFraction | WithFractionString);
/**
 * Create a bar, and place it in the given container. If the optional
 * initialFraction is given, then set the bar's width to that value.
 * |    >   |
 *
 * where, in the code below:
 * - `bar` is |        |
 * - `live` is the region of `bar` up to the >
 */
export declare function Bar(props: BarProps): JSX.Element;
/**
 * Create a container for one or more bars.
 *
 * @param alignment for singleton bars, probably 'center'; for
 * multi-bar content, probably 'space-between'
 *
 * @return the container DOM
 *
 */
export declare function BarContainer(props: {
    children?: React.ReactNode;
    alignment?: 'space-between' | 'center';
    flexDirection?: 'column' | 'row';
    onClick?: string;
}): JSX.Element;
/**
 * Create a single bar with its own container, and return the container.
 *
 */
declare type BP = BarProps & {
    text?: boolean;
};
export declare function SingletonBar(props: BP): JSX.Element;
export declare function singletonBar(props: BP): JSX.Element;
export {};
