/**
 * Turns plugin-X/dist/entry.js into X. This helps us with webpack
 * dynamic imports. We can then use:
 * `import('@kui-shell/plugin-' + webpackPath(path) + '/mdist/preload.js')`
 * which will guide webpack towards a smaller set of possibly touched files.
 *
 */
export declare function webpackPath(path: string): string;
/**
 * For electron-main (i.e. "headless"), right now we are stil using
 * commonjs imports, so we don't need to be as clever. At some point,
 * we will probably switch over to using webpack with an electron-main
 * target. At that point, this will go away.
 *
 */
export declare function mainPath(path: string): string;
