import Tab from '../webapp/tab';
import ExecOptions from '../models/execOptions';
import { CommandOptions, ExecType, KResponse, ParsedOptions } from '../models/command';
export interface CommandStartEvent {
    tab: Tab;
    route: string;
    command: string;
    execUUID: string;
    execType: ExecType;
    echo: boolean;
}
declare type ResponseTypeStr = 'MultiModalResponse' | 'NavResponse' | 'ScalarResponse' | 'Incomplete' | 'Error';
export interface CommandCompleteEvent<R extends KResponse = KResponse, T extends ResponseTypeStr = ResponseTypeStr> {
    tab: Tab;
    command: string;
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
    execOptions: ExecOptions;
    execUUID: string;
    execType: ExecType;
    cancelled: boolean;
    echo: boolean;
    evaluatorOptions: CommandOptions;
    response: R;
    responseType: T;
}
export declare type CommandStartHandler = (event: CommandStartEvent) => void;
export declare type CommandCompleteHandler<R extends KResponse = KResponse, T extends ResponseTypeStr = ResponseTypeStr> = (event: CommandCompleteEvent<R, T>) => void;
export {};
