"use strict";

var _react = _interopRequireDefault(require("react"));

var _Tag = _interopRequireDefault(require("../Tag"));

var _Tag2 = _interopRequireDefault(require("../Tag/Tag.Skeleton"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

var _react2 = require("@carbon/test-utils/react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var prefix = _carbonComponents.settings.prefix;
describe('Tag', function () {
  afterEach(_react2.cleanup);
  describe('automated accessibility testing', function () {
    it('should have no Axe violations',
    /*#__PURE__*/
    _asyncToGenerator(
    /*#__PURE__*/
    regeneratorRuntime.mark(function _callee() {
      var _render, container;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _render = (0, _react2.render)(_react.default.createElement(_Tag.default, {
                type: "red"
              }, "This is not a tag")), container = _render.container;
              _context.next = 3;
              return expect(container).toHaveNoAxeViolations();

            case 3:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));
    it('should have no DAP violations',
    /*#__PURE__*/
    _asyncToGenerator(
    /*#__PURE__*/
    regeneratorRuntime.mark(function _callee2() {
      var _render2, container;

      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _render2 = (0, _react2.render)(_react.default.createElement("main", null, _react.default.createElement(_Tag.default, {
                type: "red"
              }, "This is not a tag"))), container = _render2.container;
              _context2.next = 3;
              return expect(container).toHaveNoDAPViolations('Tag');

            case 3:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));
  });
  describe('with a screenreader', function () {
    it('filtered variant should have appropriate aria-label', function () {
      var children = 'tag content';

      var _render3 = (0, _react2.render)(_react.default.createElement(_Tag.default, {
        type: "red",
        filter: true
      }, children)),
          container = _render3.container;

      var button = container.querySelector('[aria-label], [aria-labelledby]');
      var accessibilityLabel = button.getAttribute('aria-label') || button.getAttribute('aria-labelledby'); // This check would mirror our "Accessibility label must contain at least all of visible label"
      // requirement

      expect(accessibilityLabel).toEqual(expect.stringContaining(children));
    });
  });
  describe('Renders as expected', function () {
    it('should render with the appropriate type', function () {
      var tag = (0, _enzyme.shallow)(_react.default.createElement(_Tag.default, {
        type: "red"
      }));
      expect(tag.hasClass("".concat(prefix, "--tag"))).toEqual(true);
      expect(tag.hasClass("".concat(prefix, "--tag--red"))).toEqual(true);
    });
  });
  it('should allow for a custom label', function () {
    var tag = (0, _enzyme.shallow)(_react.default.createElement(_Tag.default, {
      type: "red"
    }, "New Version!"));
    expect(tag.text()).toEqual('New Version!');
  });
  it('should support extra class names', function () {
    var tag = (0, _enzyme.shallow)(_react.default.createElement(_Tag.default, {
      type: "red",
      className: "extra-class"
    }));
    expect(tag.hasClass('extra-class')).toEqual(true);
  });
});
describe('TagSkeleton', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react.default.createElement(_Tag2.default, null));
    it('Has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--skeleton"))).toEqual(true);
      expect(wrapper.hasClass("".concat(prefix, "--tag"))).toEqual(true);
    });
  });
});