import * as React from 'react';
import { Tab as KuiTab } from '@kui-shell/core';
import Block from './Block';
import KuiConfiguration from '../../Client/KuiConfiguration';
import { BlockModel } from './Block/BlockModel';
import '../../../../web/scss/components/Terminal/_index.scss';
declare type Cleaner = () => void;
export interface TerminalOptions {
    noActiveInput?: boolean;
}
declare type Props = TerminalOptions & {
    /** tab UUID */
    uuid: string;
    /** tab model */
    tab: KuiTab;
    /** handler for terminal clear */
    onClear?: () => void;
    /** KuiConfiguration */
    config: KuiConfiguration;
    sidecarIsVisible?: boolean;
    closeSidecar: () => void;
};
interface ScrollbackState {
    uuid: string;
    blocks: BlockModel[];
    /** tab facade */
    facade?: KuiTab;
    /** grab a ref to the active block, to help us maintain focus */
    _activeBlock?: Block;
    /** cleanup routines for this split */
    cleaners: Cleaner[];
}
interface State {
    focusedIdx: number;
    splits: ScrollbackState[];
}
/** Split the given tab uuid */
export declare function doSplitView(tab: KuiTab): Promise<unknown>;
export default class ScrollableTerminal extends React.PureComponent<Props, State> {
    constructor(props: Props);
    /** add welcome blocks at the top of scrollback */
    private scrollbackWithWelcome;
    private allocateUUIDForScrollback;
    private scrollback;
    private get current();
    /** Clear Terminal; TODO: also clear persisted state, when we have it */
    private clear;
    /** Output.tsx finished rendering something */
    private onOutputRender;
    /** the REPL started executing a command */
    private onExecStart;
    /** Format a MarkdownResponse */
    private markdown;
    /** is the number of pinned views reached the max limit? */
    private hasReachedMaxPinnned;
    /**
     * When the following requirements meet, auto-pin the command block:
     * 1. user has enabled the enableWatcherAutoPin feature flag
     * 2. not in popup mode
     * 3. the scalar response is watchable, e.g. watchable table,
     * 4. the command option or exec options doesn't say alwaysViewIn Terminal,
     * i.e. crud command may always want to be displayed in terminal even though it's watchable,
     *
     */
    private shouldPinTheBlock;
    /** the REPL finished executing a command */
    private onExecEnd;
    /** Owner wants us to focus on the current prompt */
    doFocus(scrollback?: ScrollbackState): any;
    /**
     * Handle CommandStart/Complete events directed at the given
     * scrollback region.
     *
     */
    private hookIntoREPL;
    /**
     * Handle events directed at the given scrollback region.
     *
     */
    private initEvents;
    private numPinnedSplits;
    /** Split the view */
    private onSplit;
    /** Detach hooks that might have been registered */
    private uninitEvents;
    componentWillUnmount(): void;
    private onClick;
    /**
     * @return the index of the given scrollback, in the context of the
     * current (given) state
     *
     */
    private findSplit;
    /** does the scrollback has pinned blocks? */
    private hasPinned;
    /**
     * @return the index of the given scrollback, in the context of the
     * current (given) state
     * Note: if theres's no unpinned scrollback matched the given state,
     * e.g. the scrollback has been removed, return 0
     *
     */
    private findAvailableSplit;
    private removeWatchableBlock;
    /**
     * Remove the given split (identified by `sbuuid`) from the state.
     *
     */
    private removeSplit;
    /**
     * Splice in an update to the given split (identified by `sbuuid`),
     * using the giving ScrollbackState mutator.
     *
     */
    private splice;
    /** remove the pinned block, and show the original response in a non-pinned scrollback */
    private unPinTheBlock;
    /** remove the block at the given index */
    private willRemoveBlock;
    private tabRefFor;
    private tabFor;
    render(): JSX.Element;
}
export {};
