/*
 * Copyright 2017-18 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
const debug = Debug('webapp/electron-events');
debug('loading');
import { inElectron, Media, setMedia } from '../core/capabilities';
/**
 * Listen for the main process telling us to execute a command
 *
 */
const listenForRemoteEvents = (ipcRenderer) => {
    debug('listenForRemoteEvents');
    if (inElectron() && ipcRenderer) {
        ipcRenderer.on('/repl/pexec', (event, { command }) => __awaiter(void 0, void 0, void 0, function* () {
            debug('remote pexec', command);
            const { pexec } = yield import('../repl/exec');
            return pexec(command);
        }));
        ipcRenderer.on('/repl/qexec', (event, { command }) => __awaiter(void 0, void 0, void 0, function* () {
            debug('remote qexec', command);
            const { qexec } = yield import('../repl/exec');
            return qexec(command);
        }));
    }
};
/**
 * Set up the IPC channel to the main process
 *
 */
const initializeIPC = () => __awaiter(void 0, void 0, void 0, function* () {
    debug('initializeIPC');
    const electron = yield import('electron');
    const ipcRenderer = electron.ipcRenderer;
    setMedia(Media.Electron);
    return { ipcRenderer };
});
/**
 * Send a synchronous message to the main process
 *
 */
export const tellMain = (message, // eslint-disable-line @typescript-eslint/no-explicit-any
channel) => 
// eslint-disable-next-line no-async-promise-executor
new Promise((resolve, reject) => __awaiter(void 0, void 0, void 0, function* () {
    const electron = yield import('electron');
    const ipcRenderer = electron.ipcRenderer;
    ipcRenderer[channel === 'asynchronous-message' ? 'send' : 'sendSync'](channel || 'synchronous-message', typeof message === 'string' ? JSON.stringify({ operation: message }) : JSON.stringify(message));
    if (channel === 'asynchronous-message') {
        console.log('listening');
        ipcRenderer.on('asynchronous-reply', (event, response) => {
            console.log('got response', response);
            if (response === 'true') {
                resolve(true);
            }
            else {
                reject(response);
            }
        });
    }
    else {
        resolve(true);
    }
}));
// eslint-disable-next-line @typescript-eslint/no-unused-vars
export const init = (prefs = {}) => {
    return initializeIPC().then(({ ipcRenderer }) => {
        listenForRemoteEvents(ipcRenderer);
    });
};
//# sourceMappingURL=electron-events.js.map