import REPL from '../models/repl';
import { CommandLine } from '../models/command';
/**
 * A registrar for enumerators
 *
 */
export interface TabCompletionSpec {
    /**
     * The prefix of the to-be-completed parameter that has been typed
     * so far.
     */
    toBeCompleted: string;
    /**
     * An index into CommandLine.argv, or -1 if it is the trailing
     * argument that is to be completed.
     */
    toBeCompletedIdx: number;
}
export declare type CompletionResponse = string | {
    completion: string;
    addSpace: boolean;
    docs?: string;
    label?: string;
};
export declare function isStringResponse(response: CompletionResponse): response is string;
/**
 * Plugins may register enumerators. A tab completion Enumerator takes
 * a CommandLine and a TabCompletionSpec and produceds an array of
 * CompletionResponse.
 *
 */
declare type Enumerator = (tab: {
    REPL: REPL;
}, commandLine: CommandLine, spec: TabCompletionSpec) => CompletionResponse[] | Promise<CompletionResponse[]>;
/** A plugin has offered a tab completion Enumerator */
export declare function registerEnumerator(enumerator: Enumerator, priority?: number): void;
/**
 * Consult each registered enumerator to see what it has to offer in
 * the way of completions. Pick the one with highest priority, or the
 * first to register in the case of a tie-breaker.
 *
 */
export declare function applyEnumerator(tab: {
    REPL: REPL;
}, commandLine: CommandLine, spec: TabCompletionSpec): Promise<CompletionResponse[]>;
export {};
