"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _HTMLDom = _interopRequireDefault(require("./HTMLDom"));

var _Table = _interopRequireDefault(require("../Table"));

var _Markdown = _interopRequireDefault(require("../Markdown"));

var _ = require("../../../");

var _RadioTable = _interopRequireDefault(require("../../spi/RadioTable"));

var _BlockModel = require("../../Views/Terminal/Block/BlockModel");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Component that renders a "ScalarResponse", which is a command
 * response that doesn't require any particularly special
 * interpretation or visualization of the inner structure --- i.e. a
 * response that is suitable for rendering directly in the Terminal.
 *
 */
class Scalar extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      catastrophicError: undefined
    };
  }

  static getDerivedStateFromError(error) {
    return {
      catastrophicError: error
    };
  }

  componentDidCatch(error, errorInfo) {
    console.error('catastrophic error in Scalar', error, errorInfo);
  }

  render() {
    if (this.state.catastrophicError) {
      return React.createElement("div", {
        className: "oops"
      }, this.state.catastrophicError.toString());
    }

    const {
      tab,
      response
    } = this.props;

    try {
      if (typeof response === 'number' || typeof response === 'string' || typeof response === 'boolean') {
        return React.createElement("pre", null, response);
      } else if ((0, _core.isRadioTable)(response)) {
        return React.createElement(_.KuiContext.Consumer, null, config => React.createElement(_RadioTable.default, {
          table: response,
          title: !config.disableTableTitle
        }));
      } else if ((0, _core.isTable)(response)) {
        const renderBottomToolbar = !this.props.isPinned;
        const renderGrid = this.props.isPinned;
        return (0, _Table.default)(tab, tab.REPL, response, undefined, renderBottomToolbar, renderGrid, this.props.onRender); // ^^^ Notes: typescript doesn't like this, and i don't know why:
        // "is not assignable to type IntrinsicAttributes..."
        // <PaginatedTable {...props} />
      } else if ((0, _core.isMixedResponse)(response)) {
        return React.createElement("div", {
          className: "result-vertical flex-layout",
          style: {
            flex: 1,
            alignItems: 'unset'
          }
        }, response.map((part, idx) => React.createElement(Scalar, Object.assign({}, this.props, {
          key: idx,
          response: part
        }))));
      } else if ((0, _core.isUsageError)(response)) {
        // hopefully we can do away with this shortly
        if (typeof response.raw === 'string') {
          return React.createElement("pre", null, response.raw);
        } else if ((0, _core.isMessageWithUsageModel)(response.raw) || (0, _core.isMessageWithCode)(response.raw)) {
          return React.createElement("pre", null, response.raw.message);
        } else {
          return React.createElement(_HTMLDom.default, {
            content: response.raw
          });
        }
      } else if ((0, _BlockModel.isError)(response)) {
        return React.createElement("div", {
          className: "oops"
        }, response.message);
      } else if ((0, _core.isReactResponse)(response)) {
        return response.react;
      } else if ((0, _core.isHTML)(response)) {
        // ^^^ intentionally using an "else" so that typescript double
        // checks that we've covered every case of ScalarResponse
        return React.createElement(_HTMLDom.default, {
          content: response
        });
      } else if ((0, _core.isMarkdownResponse)(response)) {
        return React.createElement(_Markdown.default, {
          source: response.content
        });
      }
    } catch (err) {
      console.error('catastrophic error rendering Scalar', err);
      return React.createElement("pre", null, err.toString());
    }

    console.error('unexpected null return from Scalar:', response);
    return React.createElement("pre", {
      className: "oops"
    }, "Internal Error in command execution");
  }

}

exports.default = Scalar;