/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as React from 'react';
import { Icons, TextWithIconWidget } from '@kui-shell/plugin-client-common';
import { eventChannelUnsafe, getTab, wireToTabEvents, wireToStandardEvents, inBrowser, i18n } from '@kui-shell/core';
import { getCurrentDefaultNamespace, onKubectlConfigChangeEvents, offKubectlConfigChangeEvents } from '@kui-shell/plugin-kubectl';
const strings = i18n('plugin-kubectl');
export default class CurrentNamespace extends React.PureComponent {
    constructor(props = {}) {
        super(props);
        this.handler = this.reportCurrentNamespace.bind(this);
        this.state = {
            text: '',
            viewLevel: 'hidden'
        };
    }
    /** @return a short string that we can fit into a context UI widget */
    renderNamespace(context) {
        return context.metadata.namespace;
    }
    reportCurrentNamespace(idx) {
        return __awaiter(this, void 0, void 0, function* () {
            const tab = getTab(idx);
            if (!tab || !tab.REPL) {
                if (tab && !tab.REPL) {
                    eventChannelUnsafe.once(`/tab/new/${tab.uuid}`, () => this.reportCurrentNamespace());
                }
                return;
            }
            try {
                const ns = yield getCurrentDefaultNamespace(tab);
                if (ns) {
                    this.setState({
                        text: ns,
                        viewLevel: 'normal' // only show normally if we succeed; see https://github.com/IBM/kui/issues/3537
                    });
                }
            }
            catch (err) {
                console.error(err);
                this.setState({
                    text: '',
                    viewLevel: 'hidden' // only show normally if we succeed; see https://github.com/IBM/kui/issues/3537
                });
            }
        });
    }
    /**
     * Once we have mounted, we immediately check the current branch,
     * and schedule an update based on standard REPL events.
     *
     */
    componentDidMount() {
        if (inBrowser()) {
            wireToTabEvents(this.handler);
            onKubectlConfigChangeEvents(this.handler);
        }
        else {
            wireToStandardEvents(this.handler);
        }
    }
    /** Bye! */
    componentWillUnmount() {
        if (inBrowser()) {
            offKubectlConfigChangeEvents(this.handler);
        }
        else {
            // FIXME wireToStandardEvents(handler)
        }
    }
    render() {
        // FIXME disable the on-hover effect with the icon
        return (React.createElement(TextWithIconWidget, { text: this.state.text, viewLevel: this.state.viewLevel, id: "kui--plugin-kubeui--current-namespace", textOnclick: "kubectl get namespaces", title: strings('Kubernetes namespace') },
            React.createElement("div", { className: "current-namesapce-button", onClick: () => false },
                React.createElement(Icons, { icon: "At" }))));
    }
}
//# sourceMappingURL=CurrentNamespace.js.map