import { Entity } from '../models/entity';
import { ExecOptions } from '../models/execOptions';
import ISubwindowPrefs from '../models/SubwindowPrefs';
declare type QuitFunction = () => void;
declare type CreateWindowFunction = (commandLine: string[], subwindowPlease: boolean, subwindowPrefs: ISubwindowPrefs) => void;
export declare const createWindow: (argv: string[], subwindowPlease: boolean, subwindowPrefs: ISubwindowPrefs) => Promise<void>;
/**
 * Initialize headless mode
 *
 */
export declare const main: (app: {
    quit: QuitFunction;
}, mainFunctions: {
    createWindow: CreateWindowFunction;
}, rawArgv?: string[], execOptions?: ExecOptions) => Promise<Entity<void, import("..").Row, import("../models/entity").MetadataBearing<void>>>;
/**
 * Bootstrap headless mode
 *
 */
export declare function initHeadless(argv: string[], force?: boolean, isRunningHeadless?: boolean, execOptions?: ExecOptions): Promise<Entity<void, import("..").Row, import("../models/entity").MetadataBearing<void>>>;
export {};
