/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// temporary with disabled popup test
/* eslint-disable @typescript-eslint/no-unused-vars */
import { Common, Selectors, SidecarExpect, ReplExpect } from '@kui-shell/test';
import { waitForGreen, waitForRed, createNS, defaultModeForGet } from '@kui-shell/plugin-kubectl/tests/lib/k8s/utils';
const wdescribe = process.env.USE_WATCH_PANE ? Common.localDescribe : xdescribe;
const ns1 = createNS();
const ns2 = createNS();
const kubectl = 'kubectl';
/** wait for a deletion to complete */
const waitForDelete = function ({ name }) {
    it(`should wait for deletion of resource named ${name}`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            yield waitForRed(this.app, Selectors.BY_NAME(name));
        }
        catch (err) {
            return Common.oops(this)(err);
        }
    }));
};
/** verify that the monaco editor component contains the given substring */
const verifyTextExists = function (expectedSubstring) {
    return __awaiter(this, void 0, void 0, function* () {
        yield SidecarExpect.textPlainContentFromMonaco(expectedSubstring, false)(this.app);
    });
};
const waitForCreate = function (spec) {
    const { name, kind, ns } = spec;
    it(`should wait for creation of resource named ${name} in namespace ${ns}`, () => __awaiter(this, void 0, void 0, function* () {
        const textExists = verifyTextExists.bind(this);
        const waitForDescribeContent = () => __awaiter(this, void 0, void 0, function* () {
            yield SidecarExpect.yaml({ Name: name, Status: spec.status })(this.app);
        });
        const waitForRawContent = () => __awaiter(this, void 0, void 0, function* () {
            yield textExists(`apiVersion: v1`);
            yield textExists(`kind: ${kind}`);
        });
        try {
            // first wait for the table entry to turn green
            yield waitForGreen(this.app, Selectors.BY_NAME(name));
            // then click on the table row and switch back and forth between
            // raw and summary modes, each time ensuring that the editor
            // shows the expected content await this.app.client.click(`${Selectors.BY_NAME(name)} .clickable`)
            yield this.app.client.click(`${Selectors.BY_NAME(name)} .clickable`);
            yield SidecarExpect.open(this.app).then(SidecarExpect.mode(defaultModeForGet));
            yield waitForDescribeContent();
            yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('raw'));
            yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('raw'));
            yield waitForRawContent();
            yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('summary'));
            yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('summary'));
            yield waitForDescribeContent();
            yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('raw'));
            yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('raw'));
        }
        catch (err) {
            return Common.oops(this, true)(err);
        }
    }));
};
/** resource names */
const pod = 'nginx';
wdescribe(`popup should error out for non-existant command`, function () {
    before(Common.before(this, { popup: ['yoyo'] }));
    after(Common.after(this));
    it(`should error out for non-existant command`, () => {
        return ReplExpect.error(127)({ app: this.app, count: 0 }).catch(Common.oops(this, true));
    });
});
wdescribe(`popup create pod creating namespace ${ns1}`, function () {
    before(Common.before(this, { popup: [kubectl, 'create', 'ns', ns1] }));
    after(Common.after(this));
    waitForCreate.bind(this)({ name: ns1, kind: 'Namespace', status: 'Active' });
});
wdescribe(`popup create pod creating pod in ${ns1}`, function () {
    before(Common.before(this, {
        popup: [
            kubectl,
            'create',
            '-f',
            'https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod',
            '-n',
            ns1
        ]
    }));
    after(Common.after(this));
    waitForCreate.bind(this)({ name: pod, kind: 'Pod', ns: ns1, status: 'Running' });
});
wdescribe(`popup watch pods in ${ns1}`, function () {
    before(Common.before(this, { popup: [kubectl, 'get', 'pods', '-w', '-n', ns1] }));
    after(Common.after(this));
    waitForCreate.bind(this)({ name: pod, kind: 'Pod', ns: ns1, status: 'Running' });
});
wdescribe(`popup create pod creating namespace ${ns2}`, function () {
    before(Common.before(this, { popup: [kubectl, 'create', 'ns', ns2] }));
    after(Common.after(this));
    waitForCreate.bind(this)({ name: ns2, kind: 'Namespace', status: 'Active' });
});
wdescribe(`popup create pod creating pod in ${ns2}`, function () {
    before(Common.before(this, {
        popup: [
            kubectl,
            'create',
            '-f',
            'https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod',
            '-n',
            ns2
        ]
    }));
    after(Common.after(this));
    waitForCreate.bind(this)({ name: pod, kind: 'Pod', ns: ns2, status: 'Running' });
});
wdescribe(`popup create pod deleting pod in ${ns1}`, function () {
    before(Common.before(this, { popup: [kubectl, 'delete', 'pod', pod, '-n', ns1] }));
    after(Common.after(this));
    waitForDelete.bind(this)({ name: pod });
});
wdescribe(`popup create pod deleting pod in ${ns2}`, function () {
    before(Common.before(this, { popup: [kubectl, 'delete', 'pod', pod, '-n', ns2] }));
    after(Common.after(this));
    waitForDelete.bind(this)({ name: pod });
});
wdescribe(`popup create pod deleting namespace ${ns1}`, function () {
    before(Common.before(this, { popup: [kubectl, 'delete', 'ns', ns1] }));
    after(Common.after(this));
    waitForDelete.bind(this)({ name: ns1 });
});
wdescribe(`popup create pod deleting namespace ${ns2}`, function () {
    before(Common.before(this, { popup: [kubectl, 'delete', 'ns', ns2] }));
    after(Common.after(this));
    waitForDelete.bind(this)({ name: ns2 });
});
//# sourceMappingURL=create-pod-popup.js.map