import { CommandRegistrar } from './command';
import { PrescanUsage } from '../plugins/prescan';
import { MetadataBearing } from '../models/entity';
import { BadgeRegistration } from '../webapp/views/registrar/badges';
import { ModeRegistration } from '../webapp/views/registrar/modes';
import { SessionInitializer } from '../session/registrar';
export declare type KuiPlugin = void | Promise<void>;
export declare type PluginRegistration = (commandTree: CommandRegistrar, options?: {
    usage: PrescanUsage;
}) => KuiPlugin;
export interface PreloadRegistrar extends CommandRegistrar {
    /** sidecar modes */
    registerMode<Resource extends MetadataBearing>(registration: ModeRegistration<Resource>): void;
    registerModes<Resource extends MetadataBearing>(...registrations: ModeRegistration<Resource>[]): void;
    /** sidecar badges */
    registerBadge<Resource extends MetadataBearing>(registration: BadgeRegistration<Resource>): void;
    registerBadges<Resource extends MetadataBearing>(...registrations: BadgeRegistration<Resource>[]): void;
    /** session initializers */
    registerSessionInitializer(init: SessionInitializer): void;
}
export declare type PreloadRegistration = (registrar: PreloadRegistrar) => Promise<void | void[]>;
export declare type CapabilityRegistration = (registrar: PreloadRegistrar) => void | Promise<void>;
