"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withRetryOn404 = exports.withOkOn404 = exports.withOkOnCode = exports.withRetryOnCode = void 0;

var _debug = _interopRequireDefault(require("debug"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2018 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('k8s/util/retry');

const withRetryOnCode = code => (fn, cmd) => new Promise((resolve, reject) => {
  const iter = () => __awaiter(void 0, void 0, void 0, function* () {
    try {
      resolve(yield fn());
    } catch (err) {
      if (err.code === code) {
        debug('retrying', cmd);
        setTimeout(iter, 5000);
      } else {
        debug('rejecting', err.code, err);
        reject(err);
      }
    }
  });

  iter();
});

exports.withRetryOnCode = withRetryOnCode;

const withOkOnCode = code => (fn, cmd) => fn().catch(err => {
  if (err.code === code) {
    debug('404 ok', cmd);
  } else {
    throw err;
  }
});

exports.withOkOnCode = withOkOnCode;
const withOkOn404 = withOkOnCode(404);
exports.withOkOn404 = withOkOn404;
const withRetryOn404 = withRetryOnCode(404);
exports.withRetryOn404 = withRetryOn404;