var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import axios from 'axios';
import * as needle from 'needle';
import { getConfig } from '../lib/shared/config';
function getHeaders(config) {
    if (process.env.NODE_ENV === 'development') {
        return {
            'content-type': 'application/json',
            authorization: config.authorization,
            Cookie: config.cookie,
        };
    }
    return {
        'content-type': 'application/json',
        'csrf-token': config.xsrfToken,
    };
}
export default function HTTPClient(method, urlType, requestBody) {
    return __awaiter(this, void 0, void 0, function* () {
        const config = yield getConfig();
        const url = urlType === 'search' ? config.SEARCH_API : config.CONSOLE_API;
        let agent = null;
        if (config.env === 'development') {
            const { Agent } = yield import('https');
            agent = new Agent({ rejectUnauthorized: false });
        }
        if (process.env.NODE_ENV === 'development') {
            return needle(method, url, requestBody || {}, {
                json: true,
                headers: getHeaders(config),
                agent,
                timeout: 5000,
            }).then((res) => {
                return res.body;
            }).catch((err) => {
                throw new Error(err);
            });
        }
        return (axios({
            method,
            url,
            headers: getHeaders(config),
            data: requestBody,
            withCredentials: true,
            httpsAgent: agent,
            timeout: 10000,
        }).then((res) => {
            return res.data;
        }).catch((err) => {
            throw new Error(err);
        }));
    });
}
//# sourceMappingURL=HTTPClient.js.map