"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _context = _interopRequireDefault(require("../context"));

var _split = _interopRequireDefault(require("../../../controller/split"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common');
/**
 * re: the impl of the onClick handler, see
 * https://github.com/IBM/kui/issues/4876
 *
 */

class SplitTerminalButtonButton extends React.PureComponent {
  render() {
    return React.createElement(_context.default.Consumer, null, config => config.splitTerminals && React.createElement("a", {
      href: "#",
      className: "kui--tab-navigatable kui--top-tab-button",
      id: "kui--split-terminal-button",
      "aria-label": "Split terminal",
      tabIndex: 0,
      title: strings('Split the Terminal'),
      onClick: () => (0, _split.default)().catch(() => (0, _core.pexecInCurrentTab)('split'))
    }, React.createElement(_Icons.default, {
      icon: "Split"
    })));
  }

}

exports.default = SplitTerminalButtonButton;