/**
 * Render the given pre-rendered content as a sidecar-compatible dom
 *
 */
export declare const asSidecarContent: (renderedContent: string | Element, tag?: string) => HTMLDivElement;
/**
 * Render the given pre-rendered content as a sidecar entity
 *
 * @param renderedContent either a DOM Element or a rendered HTML string
 */
export declare const asSidecarEntity: (cmdLine: string, renderedContent: string | Element, options?: {}, tag?: string, prettyType?: string, subtext?: string | Element | Promise<string | Element>) => {
    type: string;
    prettyType: string;
    isEntity: boolean;
    subtext: string | Element | Promise<string | Element>;
    name: string;
    content: HTMLDivElement;
};
